/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.object;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.GridComponentIndex;
import com.simsilica.es.SpatialEntityContainer;
import com.simsilica.es.SpawnPositionIndex;
import com.simsilica.es.WatchedEntity;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mphys.DynArray;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mythruna.GameConstants;
import mythruna.client.GameSessionState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.object.AreaField;
import mythruna.client.view.object.ModelViewState;
import mythruna.client.view.object.TemporaryView;
import mythruna.es.ClaimArea;
import mythruna.es.ClaimMarker;
import mythruna.es.ClaimPermissions;
import mythruna.es.ClaimType;
import mythruna.es.OwnedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaimAreaState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ClaimAreaState.class);
    private static ClaimPermissions DEFAULT_PERMS = new ClaimPermissions(null, new int[]{4, 2, 8, 16, 32, 64, 128, 256, 512, 1024});
    private EntityData ed;
    private ModelViewState models;
    private VersionedReference<Vec3d> posRef;
    private Node root;
    private Grid grid = GameConstants.PHYSICS_GRID;
    private Vec3i centerCell = new Vec3i(0, -10000, 0);
    private Vec3i centerWorld;
    private int markerGridRadius = 4;
    private MarkerContainer markers;
    private Map<EntityId, AreaView> areas = new HashMap<EntityId, AreaView>();
    private DynArray<AreaView> areaList = new DynArray(AreaView.class);

    protected AreaView getBestClaim(Vec3i loc) {
        AreaView best = null;
        int smallest = Integer.MAX_VALUE;
        for (AreaView view : (AreaView[])this.areaList.getArray()) {
            if (log.isTraceEnabled()) {
                log.trace("   checking:" + view);
            }
            if (view.area == null) continue;
            if (log.isTraceEnabled()) {
                log.trace("   contains?:" + view.area.contains(loc));
            }
            if (!view.area.contains(loc)) continue;
            if (log.isTraceEnabled()) {
                log.trace("   owner:" + view.owner + "  us:" + ((AvatarState)this.getState(AvatarState.class)).getAvatarId());
            }
            if (view.area.getArea() >= smallest) continue;
            smallest = view.area.getArea();
            best = view;
        }
        return best;
    }

    public ClaimPermissions getPerms(Vec3i loc) {
        if (log.isTraceEnabled()) {
            log.trace("getPerms(" + loc + ")");
        }
        if (!this.isEnabled()) {
            this.update(0.0f);
        }
        AreaView view = this.getBestClaim(loc);
        return this.getPerms(view);
    }

    protected ClaimPermissions getPerms(AreaView view) {
        if (view == null) {
            return DEFAULT_PERMS;
        }
        if (view.type == null) {
            log.warn("AreaView has no claim type:" + view.entityId);
            return ClaimPermissions.createNoAccess((EntityId)view.entityId);
        }
        EntityId avatar = ((AvatarState)this.getState(AvatarState.class)).getAvatarId();
        EntityId parent = view.type.getParent();
        if (parent != null) {
            AreaView parentView = this.areas.get(parent);
            if (parentView == null) {
                log.warn("No parent found for:" + parent);
                return ClaimPermissions.createNoAccess((EntityId)view.entityId);
            }
            if (Objects.equals(parentView.owner, avatar)) {
                return ClaimPermissions.createOwnerPermissions((EntityId)view.entityId);
            }
            if (Objects.equals(view.owner, avatar)) {
                return ClaimPermissions.createChildPlotPermissions((EntityId)view.entityId);
            }
        } else if (Objects.equals(view.owner, avatar)) {
            return ClaimPermissions.createOwnerPermissions((EntityId)view.entityId);
        }
        return ClaimPermissions.createNoAccess((EntityId)view.entityId);
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected void initialize(Application app) {
        this.ed = ((GameSessionState)this.getState(GameSessionState.class)).getEntityData();
        this.root = new Node("areaRoot");
        this.models = (ModelViewState)this.getState(ModelViewState.class, true);
        this.markers = new MarkerContainer(this.ed);
        this.posRef = ((AvatarState)this.getState(AvatarState.class)).createPositionReference();
        this.updateViewPosition((Vec3d)this.posRef.get(), true);
        this.markers.start();
    }

    protected void cleanup(Application app) {
        this.markers.stop();
    }

    public void setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return;
        }
        if (visible) {
            this.getRoot().attachChild((Spatial)this.root);
            for (Marker marker : this.markers.getArray()) {
                marker.resetVisibility();
            }
        } else {
            this.root.removeFromParent();
            for (Marker marker : this.markers.getArray()) {
                marker.resetVisibility();
            }
        }
    }

    public boolean isVisible() {
        return this.root != null && this.root.getParent() != null;
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            this.updateViewPosition((Vec3d)this.posRef.get(), false);
        }
        this.markers.update();
        for (AreaView view : (AreaView[])this.areaList.getArray()) {
            view.update();
        }
    }

    protected void updateViewPosition(Vec3d center, boolean forceUpdate) {
        Vec3i newCenter = this.grid.worldToCell(center);
        if (!forceUpdate && newCenter.equals((Object)this.centerCell)) {
            return;
        }
        this.centerCell.set(newCenter);
        this.centerWorld = this.grid.cellToWorld(this.centerCell);
        this.resetRelativeCoordinates();
        this.markers.setCenter(center, forceUpdate);
    }

    protected void resetRelativeCoordinates() {
        for (AreaView view : (AreaView[])this.areaList.getArray()) {
            view.updateRelativePosition();
        }
    }

    protected AreaView acquireAreaView(EntityId id) {
        AreaView result = this.areas.get(id);
        if (result == null) {
            result = new AreaView(id);
            this.areas.put(id, result);
            this.areaList.add((Object)result);
            this.updateChildren(result);
        }
        result.acquire();
        return result;
    }

    protected void releaseAreaView(EntityId id) {
        AreaView result = this.areas.get(id);
        if (result != null && result.release()) {
            this.areaList.remove((Object)result);
        }
    }

    protected ColorRGBA getPermColor(AreaView view) {
        EntityId avatar = ((AvatarState)this.getState(AvatarState.class)).getAvatarId();
        EntityId parent = view.type.getParent();
        if (parent != null) {
            AreaView parentView = this.areas.get(parent);
            if (parentView == null) {
                log.warn("No parent found for:" + parent);
                return ColorRGBA.Red;
            }
            if (Objects.equals(parentView.owner, avatar)) {
                if (Objects.equals(view.owner, avatar)) {
                    return ColorRGBA.Blue;
                }
                return ColorRGBA.Green;
            }
            if (Objects.equals(view.owner, avatar)) {
                return ColorRGBA.Magenta;
            }
        } else if (Objects.equals(view.owner, avatar)) {
            return ColorRGBA.Cyan;
        }
        return ColorRGBA.Red;
    }

    protected void updateChildren(AreaView parent) {
        if (!parent.type.canBeParent()) {
            return;
        }
        for (AreaView view : (AreaView[])this.areaList.getArray()) {
            if (!Objects.equals(parent.entityId, view.type.getParent())) continue;
            view.updateParentState();
        }
    }

    private class AreaView {
        private EntityId entityId;
        private WatchedEntity entity;
        private SpawnPosition pos;
        private ColorRGBA color;
        private ClaimArea area;
        private ClaimType type;
        private EntityId owner;
        private Vec3i basePos;
        private int yBase;
        private int useCount;
        private AreaField areaGeom;
        private boolean invalid = true;

        public AreaView(EntityId entityId) {
            this.entityId = entityId;
            this.entity = ClaimAreaState.this.ed.watchEntity(entityId, new Class[]{SpawnPosition.class, ClaimType.class, ClaimArea.class, OwnedBy.class});
            log.info("Created AreaView(" + entityId + "):" + this.entity);
            this.updateFields();
        }

        public void update() {
            if (this.entity.applyChanges()) {
                log.info("Area changed:" + this.entity);
                this.updateFields();
            }
            if (this.invalid) {
                this.updateGeometry();
            }
        }

        protected void updateParentState() {
            ColorRGBA newColor = ClaimAreaState.this.getPermColor(this);
            if (!Objects.equals(newColor, this.color)) {
                this.color = newColor;
                if (this.areaGeom != null) {
                    this.areaGeom.setColor(this.color);
                }
            }
        }

        protected void updateFields() {
            OwnedBy owned;
            this.type = (ClaimType)this.entity.get(ClaimType.class);
            SpawnPosition newPos = (SpawnPosition)this.entity.get(SpawnPosition.class);
            if (newPos == null) {
                if (this.areaGeom != null) {
                    this.areaGeom.removeFromParent();
                }
                this.pos = null;
            } else {
                int y = (int)Math.floor(newPos.getLocation().y);
                if (y != this.yBase) {
                    this.invalid = true;
                }
                this.pos = newPos;
                this.yBase = y;
            }
            ClaimArea newArea = (ClaimArea)this.entity.get(ClaimArea.class);
            if (!Objects.equals(newArea, this.area)) {
                this.area = newArea;
                this.invalid = true;
            }
            this.owner = (owned = (OwnedBy)this.entity.get(OwnedBy.class)) != null && Objects.equals(owned.getOwner(), ((AvatarState)ClaimAreaState.this.getState(AvatarState.class)).getAvatarId()) ? owned.getOwner() : null;
            this.color = ClaimAreaState.this.getPermColor(this);
            if (this.areaGeom != null) {
                this.areaGeom.setColor(this.color);
            }
        }

        protected void updateGeometry() {
            if (this.area == null) {
                if (this.pos != null) {
                    log.warn("area is null for:" + this.entityId);
                }
                return;
            }
            this.basePos = this.area.getMin().clone();
            Vec3i min = new Vec3i();
            Vec3i max = this.area.getMax().subtract(this.basePos);
            this.basePos.y = this.yBase;
            if (this.areaGeom == null) {
                this.areaGeom = new AreaField(ClaimAreaState.this.getApplication().getAssetManager(), min, max);
                this.areaGeom.setColor(this.color);
                ClaimAreaState.this.root.attachChild((Spatial)this.areaGeom);
            } else {
                this.areaGeom.setArea(min, max);
            }
            log.info("Updated geomtry for:" + this.entityId + " to:" + this.basePos + " -> + " + max);
            this.updateRelativePosition();
            this.invalid = false;
        }

        protected void acquire() {
            ++this.useCount;
        }

        protected boolean release() {
            --this.useCount;
            if (this.useCount <= 0) {
                log.info("Releasing AreaView(" + this.entityId + ")");
                ClaimAreaState.this.areas.remove(this.entityId);
                if (this.areaGeom == null) {
                    log.warn("Removing area view that never had geometry:" + this.entityId);
                } else {
                    this.areaGeom.removeFromParent();
                }
                return true;
            }
            return false;
        }

        public void updateRelativePosition() {
            if (this.basePos == null) {
                log.warn("AreaView: Base position is null for:" + this.entityId);
                return;
            }
            Vec3i loc = this.basePos.clone();
            loc.subtractLocal(ClaimAreaState.this.centerWorld);
            this.areaGeom.setLocalTranslation(loc.toVector3f());
        }
    }

    private class MarkerContainer
    extends SpatialEntityContainer<Marker, SpawnPosition> {
        public MarkerContainer(EntityData ed) {
            super((GridComponentIndex)new SpawnPositionIndex(GameConstants.PHYSICS_GRID, ClaimAreaState.this.markerGridRadius), ed, new Class[]{SpawnPosition.class, ClaimMarker.class});
        }

        public Marker[] getArray() {
            return (Marker[])super.getArray();
        }

        protected Marker addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("add marker for:" + e.getId());
            }
            Marker marker = new Marker(e);
            this.updateObject(marker, e);
            return marker;
        }

        protected void updateObject(Marker object, Entity e) {
            object.update();
        }

        protected void removeObject(Marker object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("remove marker for:" + e.getId());
            }
            object.release();
        }
    }

    private class Marker {
        private Entity entity;
        private ClaimMarker claimMarker;
        private AreaView area;
        private TemporaryView tempView;

        public Marker(Entity entity) {
            this.entity = entity;
            this.claimMarker = (ClaimMarker)entity.get(ClaimMarker.class);
            this.area = ClaimAreaState.this.acquireAreaView(this.claimMarker.getClaim());
            this.resetVisibility();
        }

        protected boolean isVisible() {
            return this.tempView != null;
        }

        protected void setVisible(boolean visible) {
            if (visible == this.isVisible()) {
                return;
            }
            if (visible) {
                int typeId = this.claimMarker.getTypeId();
                this.tempView = ClaimAreaState.this.models.createTemporaryView(this.entity.getId(), new ShapeInfo(typeId, 0.25));
                this.update();
            } else {
                this.tempView.release();
                this.tempView = null;
            }
        }

        public void resetVisibility() {
            this.setVisible(ClaimAreaState.this.isVisible());
        }

        public void update() {
            if (this.tempView != null) {
                SpawnPosition pos = (SpawnPosition)this.entity.get(SpawnPosition.class);
                this.tempView.setWorldPosition(pos.getLocation(), pos.getOrientation());
            }
        }

        public void release() {
            ClaimAreaState.this.releaseAreaView(this.claimMarker.getClaim());
            this.setVisible(false);
        }
    }
}

