/*
 * Decompiled with CFR 0.152.
 */
package mythruna.character;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.mblock.CellArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import mythruna.character.ClothingType;
import mythruna.text.CsvUtils;
import mythruna.text.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingTypeIndex {
    static Logger log = LoggerFactory.getLogger(ClothingTypeIndex.class);
    public static final String CLOTHING_INDEX_CSV = "races/random-clothing.csv";
    private Map<String, Map<Part, PartIndex>> raceIndex = new HashMap<String, Map<Part, PartIndex>>();

    public ClothingTypeIndex(List<ClothingType> clothing) {
        for (ClothingType type : clothing) {
            for (String race : type.getRaces()) {
                if (type.getShirtLayer() >= 0) {
                    this.getPartIndex(race, Part.Shirt, true).add(type);
                }
                if (type.getPantsLayer() >= 0) {
                    this.getPartIndex(race, Part.Pants, true).add(type);
                }
                if (type.getFeetLayer() >= 0) {
                    this.getPartIndex(race, Part.Feet, true).add(type);
                }
                if (type.getMiscLayer() < 0) continue;
                this.getPartIndex(race, Part.Misc, true).add(type);
            }
        }
    }

    protected Map<Part, PartIndex> getPartMap(String race, boolean create) {
        Map<Part, PartIndex> map = this.raceIndex.get(race);
        if (map == null && create) {
            map = new HashMap<Part, PartIndex>();
            this.raceIndex.put(race, map);
        }
        return map;
    }

    protected PartIndex getPartIndex(String race, Part part, boolean create) {
        Map<Part, PartIndex> map = this.getPartMap(race, create);
        if (map == null) {
            return null;
        }
        PartIndex index = map.get((Object)part);
        if (index == null && create) {
            index = new PartIndex(this);
            map.put(part, index);
        }
        return index;
    }

    public List<ClothingType> getRandomClothes(String race, Random rand) {
        ArrayList<ClothingType> results = new ArrayList<ClothingType>();
        this.getPartIndex(race, Part.Pants, false).addRandomParts(results, rand);
        this.getPartIndex(race, Part.Shirt, false).addRandomParts(results, rand);
        this.getPartIndex(race, Part.Feet, false).addRandomParts(results, rand);
        double roll = rand.nextDouble();
        int miscCount = 0;
        if (roll < 0.25) {
            miscCount = 2;
        } else if (roll < 0.5) {
            miscCount = 1;
        }
        for (int i = 0; i < miscCount; ++i) {
            results.add(this.getPartIndex(race, Part.Misc, false).getRandomType(0, rand));
        }
        return results;
    }

    public static ClothingTypeIndex create(Function<String, String> textFunc, Function<String, CellArray> cellFunc) {
        String text = textFunc.apply(CLOTHING_INDEX_CSV);
        ClothingTypeIndex index = ClothingTypeIndex.create(text, cellFunc);
        return index;
    }

    public static ClothingTypeIndex create(String text, Function<String, CellArray> cellFunc) {
        List<Map<String, String>> records = CsvUtils.csvToRecords(text, 0, '\t');
        List<ClothingType> clothing = MapUtils.toObjects(records, ClothingType.class);
        if (cellFunc != null) {
            for (ClothingType type : clothing) {
                type.populateCells(cellFunc);
            }
        }
        return new ClothingTypeIndex(clothing);
    }

    public static enum Part {
        Shirt,
        Pants,
        Feet,
        Misc;

    }

    private class PartIndex {
        private ListMultimap<Integer, ClothingType> parts = MultimapBuilder.hashKeys().arrayListValues().build();

        private PartIndex(ClothingTypeIndex clothingTypeIndex) {
        }

        public void add(ClothingType type) {
            for (int i = 0; i <= type.getLayer(); ++i) {
                this.parts.put((Object)i, (Object)type);
            }
        }

        public int addRandomParts(List<ClothingType> results, Random rand) {
            int layer = 0;
            ClothingType part = null;
            int count = 0;
            while ((part = this.getRandomType(layer, rand)) != null) {
                results.add(part);
                layer = part.getLayer() + 1;
                ++count;
                if (!rand.nextBoolean()) continue;
                break;
            }
            return count;
        }

        public ClothingType getRandomType(int layer, Random rand) {
            List types = this.parts.get((Object)layer);
            if (types.isEmpty()) {
                return null;
            }
            int index = rand.nextInt(types.size());
            return (ClothingType)types.get(index);
        }
    }
}

