/*
 * Decompiled with CFR 0.152.
 */
package mythruna.fabric;

import com.simsilica.mblock.CellArray;
import mythruna.fabric.ClothingAccumulator;
import mythruna.fabric.FabricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClothingAccumulator
implements ClothingAccumulator {
    static Logger log = LoggerFactory.getLogger(DefaultClothingAccumulator.class);
    private CellArray swatches;
    private int xSize;
    private int ySize;
    private int layers;
    private int[][] levels;

    public DefaultClothingAccumulator(int xSize, int ySize, int layers) {
        this.xSize = xSize;
        this.ySize = ySize;
        this.layers = layers;
        this.swatches = new CellArray(xSize, ySize, layers);
        this.levels = new int[xSize][ySize];
    }

    public boolean isClear() {
        return this.swatches.isClear();
    }

    @Override
    public int getSizeX() {
        return this.xSize;
    }

    @Override
    public int getSizeY() {
        return this.ySize;
    }

    public void clear() {
        this.swatches.clear(0);
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                this.levels[i][j] = 0;
            }
        }
    }

    @Override
    public int getValue(int x, int y, int layer) {
        return this.swatches.getCell(x, y, layer);
    }

    @Override
    public int getTopValue(int x, int y) {
        if (this.levels[x][y] <= 0) {
            return 0;
        }
        return this.swatches.getCell(x, y, this.levels[x][y] - 1);
    }

    public void addCells(CellArray source) {
        for (int i = 0; i < this.xSize; ++i) {
            for (int j = 0; j < this.ySize; ++j) {
                int val;
                for (int k = 0; k < this.layers && (val = source.getCell(i, j, k)) != 0; ++k) {
                    this.addValue(i, j, val);
                }
            }
        }
    }

    public CellArray getCells() {
        return this.swatches;
    }

    @Override
    public int getLayer(int x, int y) {
        return this.levels[x][y];
    }

    public int addSwatch(int x, int y, int shape, int fabric) {
        int value = FabricUtils.toCell(shape, fabric);
        return this.addValue(x, y, value);
    }

    @Override
    public int addValue(int x, int y, int value) {
        if (x < 0 || x >= 32 || y < 0 || y >= 32) {
            return -1;
        }
        int layer = this.levels[x][y];
        if (layer >= 32) {
            return 0;
        }
        if (layer > 0 && this.swatches.getCell(x, y, layer - 1) == value) {
            return 0;
        }
        this.swatches.setCell(x, y, layer, value);
        this.levels[x][y] = layer + 1;
        return value;
    }

    @Override
    public int insertValue(int x, int y, int value) {
        if (x < 0 || x >= 32 || y < 0 || y >= 32) {
            return -1;
        }
        int layer = this.levels[x][y];
        if (layer >= 32) {
            return 0;
        }
        for (int i = layer - 1; i >= 0; --i) {
            int v = this.swatches.getCell(x, y, i);
            this.swatches.setCell(x, y, i + 1, v);
        }
        this.swatches.setCell(x, y, 0, value);
        this.levels[x][y] = layer + 1;
        return value;
    }

    @Override
    public int removeSwatch(int x, int y) {
        int existing;
        int layer = this.levels[x][y];
        if (layer <= 0) {
            return 0;
        }
        if ((existing = this.swatches.getCell(x, y, --layer)) != 0) {
            this.swatches.setCell(x, y, layer, 0);
        }
        this.levels[x][y] = layer;
        return existing;
    }

    @Override
    public int deleteValue(int x, int y) {
        if (x < 0 || x >= 32 || y < 0 || y >= 32) {
            return -1;
        }
        int layer = this.levels[x][y];
        if (layer == 0) {
            return 0;
        }
        int existing = this.swatches.getCell(x, y, 0);
        --layer;
        for (int i = 0; i < layer; ++i) {
            int v = this.swatches.getCell(x, y, i + 1);
            this.swatches.setCell(x, y, i, v);
        }
        this.swatches.setCell(x, y, layer, 0);
        this.levels[x][y] = layer;
        return existing;
    }
}

