/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.bpos.BodyPosition;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mythruna.es.AgentType;
import mythruna.es.EncounterTrigger;
import mythruna.es.ObjectName;
import mythruna.es.ObjectTypeInfo;
import mythruna.es.OwnedBy;
import mythruna.sim.GameActionSystem;
import mythruna.sim.ai.ActivationZoneListener;
import mythruna.sim.ai.AgentActivationSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobEncounterSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(MobEncounterSystem.class);
    private EntityData ed;
    private AgentActivationSystem activationSystem;
    private ZoneObserver zoneObserver = new ZoneObserver();
    private GameActionSystem gameActions;
    private Map<EntityId, Encounter> encounterIndex = new HashMap<EntityId, Encounter>();
    private EncounterTriggerContainer triggers;
    private Set<Long> activeZones = new HashSet<Long>();
    private boolean filterInvalid = true;
    private Thread gameThread;
    private long scriptTime = 0L;

    public boolean isActiveZone(long zoneId) {
        assert (Thread.currentThread() == this.gameThread);
        return this.activeZones.contains(zoneId);
    }

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.activationSystem = (AgentActivationSystem)((Object)this.getSystem(AgentActivationSystem.class, true));
        this.activationSystem.addActivationZoneListener(this.zoneObserver);
        this.gameActions = (GameActionSystem)((Object)this.getSystem(GameActionSystem.class, true));
        this.gameThread = Thread.currentThread();
    }

    protected void terminate() {
        this.activationSystem.removeActivationZoneListener(this.zoneObserver);
    }

    public void start() {
        this.triggers = new EncounterTriggerContainer(this.ed);
        this.recalculateFilter();
        this.triggers.start();
    }

    public void update(SimTime time) {
        long start = System.nanoTime();
        if (this.filterInvalid) {
            this.recalculateFilter();
        }
        long mid = System.nanoTime();
        this.scriptTime = 0L;
        this.triggers.update();
        long end = System.nanoTime();
        if (end - start > 13000000L) {
            log.warn(String.format("long update total: %.03f ms  filter: %.03f ms  update: %.03f  scripts: %.03f", (double)(end - start) / 1000000.0, (double)(mid - start) / 1000000.0, (double)(end - mid) / 1000000.0, (double)this.scriptTime / 1000000.0));
        }
    }

    public void stop() {
        this.triggers.stop();
        this.triggers = null;
        this.gameActions.spool(this::checkLeaks);
    }

    protected void checkLeaks() {
        log.info("---------checking for leaks:");
        HashSet<EntityId> leakedEncounterSpawnOwners = new HashSet<EntityId>();
        int leakedMobCount = 0;
        for (Object id : this.ed.findEntities(null, new Class[]{AgentType.class, ObjectTypeInfo.class, SpawnPosition.class})) {
            OwnedBy ownedBy;
            log.info("Existing mob:" + (EntityId)id);
            String type = ((ObjectTypeInfo)this.ed.getComponent((EntityId)id, ObjectTypeInfo.class)).getTypeName(this.ed);
            if (type == "Animal") {
                type = ((ObjectName)this.ed.getComponent((EntityId)id, ObjectName.class)).getName(this.ed);
            }
            log.info("  type:" + type);
            log.info("  zone:" + ((SpawnPosition)this.ed.getComponent((EntityId)id, SpawnPosition.class)).getBinId());
            if ("Butterfly".equals(type)) {
                ownedBy = (OwnedBy)this.ed.getComponent((EntityId)id, OwnedBy.class);
                log.info("  ownedBy:" + ownedBy);
                ++leakedMobCount;
                if (ownedBy != null) {
                    leakedEncounterSpawnOwners.add(ownedBy.getOwner());
                } else {
                    log.warn("  has no owner");
                }
                log.info("  bufferly agent type:" + this.ed.getComponent((EntityId)id, AgentType.class));
                log.info("  body pos:" + this.ed.getComponent((EntityId)id, BodyPosition.class));
            }
            if (!"Bird".equals(type)) continue;
            ownedBy = (OwnedBy)this.ed.getComponent((EntityId)id, OwnedBy.class);
            log.info("  ownedBy:" + ownedBy);
            ++leakedMobCount;
            if (ownedBy != null) {
                leakedEncounterSpawnOwners.add(ownedBy.getOwner());
            } else {
                log.warn("  has no owner");
            }
            log.info("  bird agent type:" + this.ed.getComponent((EntityId)id, AgentType.class));
            log.info("  body pos:" + this.ed.getComponent((EntityId)id, BodyPosition.class));
        }
        HashSet<EntityId> leakedEncounters = new HashSet<EntityId>();
        for (Object id : this.ed.findEntities(ObjectTypeInfo.typeFilter("ButterflyEncounter", this.ed), new Class[]{ObjectTypeInfo.class})) {
            leakedEncounters.add((EntityId)id);
            log.info("Found existing butterfly encounter:" + (EntityId)id);
        }
        for (Object id : this.ed.findEntities(ObjectTypeInfo.typeFilter("BirdEncounter", this.ed), new Class[]{ObjectTypeInfo.class})) {
            leakedEncounters.add((EntityId)id);
            log.info("Found existing bird encounter:" + (EntityId)id);
        }
        HashSet<EntityId> leakedTriggers = new HashSet<EntityId>();
        for (EntityId id : this.ed.findEntities(null, new Class[]{EncounterTrigger.class})) {
            leakedTriggers.add(id);
            ObjectTypeInfo typeInfo = (ObjectTypeInfo)this.ed.getComponent(id, ObjectTypeInfo.class);
            String type = typeInfo == null ? null : typeInfo.getTypeName(this.ed);
            log.info("Found trigger:" + id + " type:" + type);
            for (EntityId mob : this.ed.findEntities(OwnedBy.filter(id), new Class[]{OwnedBy.class, ShapeInfo.class, AgentType.class})) {
                log.info("  spawn:" + mob);
            }
        }
        log.info("Leaked mobs:" + leakedMobCount + " leakedEncounters:" + leakedEncounters.size());
        HashSet check = new HashSet(leakedEncounterSpawnOwners);
        check.removeAll(leakedEncounters);
        log.info("Unmatched encounter spawn owners:" + check);
        check = new HashSet(leakedTriggers);
        check.removeAll(leakedEncounters);
        log.info("Triggers without encounters:" + check);
        check = new HashSet(leakedEncounters);
        check.removeAll(leakedTriggers);
        log.info("Encountes without triggers:" + check);
    }

    protected Encounter getEncounter(EntityId entityId, boolean create) {
        Encounter result = this.encounterIndex.get(entityId);
        if (result == null && create) {
            result = new Encounter(entityId);
            this.encounterIndex.put(entityId, result);
        }
        return result;
    }

    protected Encounter acquireEncounter(EntityId entityId) {
        if (log.isTraceEnabled()) {
            log.trace("acquireEncounter(" + entityId + ") standard-mobs");
        }
        Encounter encounter = this.getEncounter(entityId, true);
        encounter.acquire();
        return encounter;
    }

    protected void releaseEncounter(EntityId entityId) {
        Encounter encounter;
        if (log.isTraceEnabled()) {
            log.trace("releaseEncounter(" + entityId + ") standard-mobs");
        }
        if ((encounter = this.encounterIndex.get(entityId)) == null) {
            return;
        }
        if (encounter.release()) {
            this.encounterIndex.remove(entityId);
        }
    }

    protected void addActiveZone(long zoneId) {
        if (log.isTraceEnabled()) {
            log.trace("activateZone(" + zoneId + ")");
        }
        assert (Thread.currentThread() == this.gameThread);
        if (this.activeZones.add(zoneId)) {
            this.filterInvalid = true;
        }
    }

    protected void removeActiveZone(long zoneId) {
        if (log.isTraceEnabled()) {
            log.trace("deactivateZone(" + zoneId + ")");
        }
        assert (Thread.currentThread() == this.gameThread);
        if (this.activeZones.remove(zoneId)) {
            this.filterInvalid = true;
        }
    }

    protected void recalculateFilter() {
        if (log.isTraceEnabled()) {
            log.trace("recalculateFilter() zone count:" + this.activeZones.size());
        }
        this.filterInvalid = false;
        if (this.activeZones.isEmpty()) {
            ComponentFilter<EncounterTrigger> f1 = EncounterTrigger.zoneFilter(1L);
            ComponentFilter<EncounterTrigger> f2 = EncounterTrigger.zoneFilter(0L);
            this.triggers.setFilter(Filters.and(EncounterTrigger.class, (ComponentFilter[])new ComponentFilter[]{f1, f2}));
            return;
        }
        ComponentFilter[] filterArray = new ComponentFilter[this.activeZones.size()];
        int index = 0;
        for (Long zoneId : this.activeZones) {
            filterArray[index++] = EncounterTrigger.zoneFilter(zoneId);
        }
        this.triggers.setFilter(Filters.or(EncounterTrigger.class, (ComponentFilter[])filterArray));
    }

    private class ZoneObserver
    implements ActivationZoneListener {
        private ZoneObserver() {
        }

        @Override
        public void activateZone(long zoneId) {
            if (log.isTraceEnabled()) {
                log.trace("activateZone(" + zoneId + ") standard-mobs");
            }
            MobEncounterSystem.this.addActiveZone(zoneId);
        }

        @Override
        public void deactivateZone(long zoneId) {
            if (log.isTraceEnabled()) {
                log.trace("deactivateZone(" + zoneId + ") standard-mobs");
            }
            MobEncounterSystem.this.removeActiveZone(zoneId);
        }
    }

    private class EncounterTriggerContainer
    extends EntityContainer<Trigger> {
        public EncounterTriggerContainer(EntityData ed) {
            super(ed, new Class[]{EncounterTrigger.class});
        }

        public void setFilter(ComponentFilter filter) {
            super.setFilter(filter);
        }

        protected Trigger addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("addTrigger(" + e + ") standard-mobs");
            }
            Trigger trigger = new Trigger(e);
            this.updateObject(trigger, e);
            return trigger;
        }

        protected void updateObject(Trigger object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("updateTrigger(" + object + ", " + e + ") standard-mobs");
            }
            object.update();
        }

        protected void removeObject(Trigger object, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("removeTrigger(" + object + ", " + e + ") standard-mobs");
            }
            object.release();
        }
    }

    private class Encounter {
        private EntityId entityId;
        private int useCount;
        private boolean valid;
        private boolean activated;

        public Encounter(EntityId entityId) {
            this.entityId = entityId;
            boolean bl = this.valid = MobEncounterSystem.this.gameActions.getType(entityId).findAction("activateEncounter", new Object[0]) != null;
            if (!this.valid) {
                log.warn("Encounter entity:" + entityId + " is not a valid encounter type:" + MobEncounterSystem.this.gameActions.getType(entityId));
            }
        }

        public void acquire() {
            if (log.isTraceEnabled()) {
                log.trace("acquire():" + this.entityId);
            }
            ++this.useCount;
            if (log.isTraceEnabled()) {
                log.info("acquire():" + this.entityId + " useCount:" + this.useCount + " valid:" + this.valid + " standard-mobs");
            }
            if (this.useCount == 1 && this.valid) {
                MobEncounterSystem.this.gameActions.spool(() -> {
                    if (this.useCount > 0 && !this.activated) {
                        try {
                            if (log.isTraceEnabled()) {
                                log.trace("calling activateEncounter on:" + this.entityId + " should run standard-mobs");
                            }
                            MobEncounterSystem.this.gameActions.runAction(this.entityId, "activateEncounter", new Object[0]);
                            this.activated = true;
                        }
                        catch (Exception e) {
                            log.error("Error activating encounter:" + this.entityId, (Throwable)e);
                        }
                    } else if (log.isTraceEnabled()) {
                        log.trace("Not activating " + this.entityId + " because it's already deactivated again. standard-mobs");
                    }
                });
            }
        }

        public boolean release() {
            if (log.isTraceEnabled()) {
                log.trace("release():" + this.entityId);
            }
            --this.useCount;
            if (this.useCount < 0) {
                log.warn("Use count went below 0 for:" + this.entityId);
            }
            if (log.isTraceEnabled()) {
                log.trace("release():" + this.entityId + " useCount:" + this.useCount + " valid:" + this.valid + " standard-mobs");
            }
            if (this.useCount == 0 && this.valid) {
                MobEncounterSystem.this.gameActions.spool(() -> {
                    if (log.isTraceEnabled()) {
                        log.trace("spooled release():" + this.entityId + " useCount:" + this.useCount + " activated:" + this.activated + " standard-mobs");
                    }
                    if (this.useCount <= 0) {
                        try {
                            if (log.isTraceEnabled()) {
                                log.trace("calling deactivateEncounter on:" + this.entityId + " should run standard-mobs");
                            }
                            MobEncounterSystem.this.gameActions.runAction(this.entityId, "deactivateEncounter", new Object[0]);
                        }
                        catch (Exception e) {
                            log.error("Error deactivating encounter:" + this.entityId, (Throwable)e);
                        }
                        this.activated = false;
                    } else if (log.isTraceEnabled()) {
                        log.trace("Not deactivating " + this.entityId + " because it's active again. standard-mobs");
                    }
                });
            }
            return this.useCount <= 0;
        }
    }

    private class Trigger {
        private Entity entity;
        private EncounterTrigger lastTrigger;
        private Encounter encounter;

        public Trigger(Entity entity) {
            this.entity = entity;
        }

        public void update() {
            EncounterTrigger t = (EncounterTrigger)this.entity.get(EncounterTrigger.class);
            if (log.isTraceEnabled()) {
                log.trace("update() trigger:" + t + "  last:" + this.lastTrigger + " standard-mobs");
            }
            if (Objects.equals(t, this.lastTrigger)) {
                return;
            }
            if (this.lastTrigger != null) {
                MobEncounterSystem.this.releaseEncounter(this.lastTrigger.getEncounterId());
            }
            this.lastTrigger = t;
            if (this.lastTrigger != null) {
                this.encounter = MobEncounterSystem.this.acquireEncounter(this.lastTrigger.getEncounterId());
            }
        }

        public void release() {
            if (this.lastTrigger != null) {
                MobEncounterSystem.this.releaseEncounter(this.lastTrigger.getEncounterId());
            }
        }
    }
}

