/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.simsilica.es.EntityId;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.AbstractBody;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.QueryFilter;
import com.simsilica.mphys.QueryVolume;
import com.simsilica.mphys.RigidBody;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerceptionSet {
    static Logger log = LoggerFactory.getLogger(PerceptionSet.class);
    private PhysicsSpace<EntityId, MBlockShape> physics;
    private QueryVolume queryVolume;
    private QueryFilter<EntityId, MBlockShape> filter;
    private double interval = 0.2;
    private double time = 0.0;
    private Set<EntityId> skip = new HashSet<EntityId>();
    private Predicate<RigidBody<EntityId, MBlockShape>> skipPredicate = new Predicate<RigidBody<EntityId, MBlockShape>>(){

        public boolean apply(RigidBody<EntityId, MBlockShape> body) {
            return !PerceptionSet.this.skip.contains(body.id);
        }
    };
    private Set<AbstractBody<EntityId, MBlockShape>> inView = new HashSet<AbstractBody<EntityId, MBlockShape>>();
    private Set<AbstractBody<EntityId, MBlockShape>> entered = new HashSet<AbstractBody<EntityId, MBlockShape>>();
    private Set<AbstractBody<EntityId, MBlockShape>> exited = new HashSet<AbstractBody<EntityId, MBlockShape>>();

    public PerceptionSet(QueryVolume queryVolume, PhysicsSpace<EntityId, MBlockShape> physics) {
        this.queryVolume = queryVolume;
        this.physics = physics;
        this.filter = new QueryFilter(255, this.skipPredicate, Predicates.alwaysTrue());
    }

    public void setSkip(EntityId ... skip) {
        this.skip.clear();
        this.skip.addAll(Arrays.asList(skip));
    }

    public QueryVolume getQueryVolume() {
        return this.queryVolume;
    }

    public Iterable<AbstractBody<EntityId, MBlockShape>> getEntered() {
        return this.entered;
    }

    public Iterable<AbstractBody<EntityId, MBlockShape>> getExited() {
        return this.exited;
    }

    public void clearPendingState() {
        this.entered.clear();
        this.exited.clear();
    }

    public boolean update(double tpf) {
        this.time += tpf;
        if (this.time < this.interval) {
            return false;
        }
        this.time = 0.0;
        Collection results = this.physics.queryBounds(this.queryVolume, this.filter);
        this.exited.addAll(this.inView);
        for (AbstractBody body : results) {
            if (this.skip.contains(body.id)) continue;
            if (this.inView.add((AbstractBody<EntityId, MBlockShape>)body)) {
                this.entered.add((AbstractBody<EntityId, MBlockShape>)body);
            }
            this.exited.remove(body);
        }
        this.inView.removeAll(this.exited);
        return true;
    }
}

