/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mphys;

import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import com.simsilica.ext.mphys.BinEntityManager;
import com.simsilica.ext.mphys.EntityBodyFactory;
import com.simsilica.ext.mphys.Impulse;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.CollisionSystem;
import com.simsilica.mphys.PhysicsListener;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.PhysicsStats;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPhysSystem<S extends AbstractShape>
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(MPhysSystem.class);
    private PhysicsSpace<EntityId, S> phys;
    private Grid zoneGrid;
    private EntityData ed;
    private BinEntityManager<S> binManager;
    private EntityBodyFactory<S> bodyFactory;
    private EntitySet impulses;
    private static double FPS60 = 0.016666666666666666;

    public MPhysSystem(Grid zoneGrid, EntityBodyFactory<S> bodyFactory) {
        this(zoneGrid, null, bodyFactory);
    }

    public MPhysSystem(Grid zoneGrid, Vec3i gridRadius, EntityBodyFactory<S> bodyFactory) {
        this.zoneGrid = zoneGrid;
        this.bodyFactory = bodyFactory;
        this.phys = new PhysicsSpace(zoneGrid, gridRadius);
    }

    public String getDiagnostics() {
        PhysicsStats stats = this.phys.getStats();
        return String.format("active bins: %d/%d, active bodies: %d/%d, frame: %.03f ms (avg: %.03f), integrate: %.03f ms (avg: %.03f), driver: %.03f ms (avg: %.03f), binUpdate: %.03f ms (avg: %.03f), contactGen: %.03f ms (avg: %.03f), contactRes: %.03f (avg: %.03f)", stats.getLong("activeBinCount"), stats.getLong("binCount"), stats.getLong("activeBodyCount"), stats.getLong("bodyCount"), stats.getLastDouble("frameTime") / 1000000.0, stats.getDouble("frameTime") / 1000000.0, stats.getLastDouble("integrationTime") / 1000000.0, stats.getDouble("integrationTime") / 1000000.0, stats.getLastDouble("driverTime") / 1000000.0, stats.getDouble("driverTime") / 1000000.0, stats.getLastDouble("binUpdateTime") / 1000000.0, stats.getDouble("binUpdateTime") / 1000000.0, stats.getLastDouble("contactGenTime") / 1000000.0, stats.getDouble("contactGenTime") / 1000000.0, stats.getLastDouble("contactResTime") / 1000000.0, stats.getDouble("contactResTime") / 1000000.0);
    }

    public String getDiagnostics2() {
        StringWriter sOut = new StringWriter();
        try (PrintWriter out = new PrintWriter(sOut);){
            this.phys.getBinIndex().writeDebugInfo(out);
        }
        return sOut.toString();
    }

    public void setEntityData(EntityData ed) {
        if (this.isInitialized()) {
            throw new IllegalStateException("System is already initialized");
        }
        this.ed = ed;
    }

    public EntityData getEntityData() {
        return this.ed;
    }

    public PhysicsSpace<EntityId, S> getPhysicsSpace() {
        return this.phys;
    }

    public BinEntityManager<S> getBinEntityManager() {
        return this.binManager;
    }

    public EntityBodyFactory<S> getBodyFactory() {
        return this.bodyFactory;
    }

    public void setCollisionSystem(CollisionSystem<EntityId, S> collisionSystem) {
        this.phys.setCollisionSystem(collisionSystem);
    }

    public CollisionSystem<EntityId, S> getCollisionSystem() {
        return this.phys.getCollisionSystem();
    }

    public void addPhysicsListener(PhysicsListener<EntityId, S> l) {
        this.phys.addPhysicsListener(l);
    }

    public void removePhysicsListener(PhysicsListener<EntityId, S> l) {
        this.phys.removePhysicsListener(l);
    }

    protected void initialize() {
        if (this.ed == null) {
            this.ed = (EntityData)this.getSystem(EntityData.class, true);
        }
        this.binManager = new BinEntityManager(this.ed);
        this.phys.addBinListener(this.binManager);
        this.phys.setPhysicsFactory(this.bodyFactory);
    }

    protected void terminate() {
    }

    public void start() {
        super.start();
        this.impulses = this.ed.getEntities(new Class[]{ShapeInfo.class, Mass.class, Impulse.class});
    }

    public void update(SimTime time) {
        long start = System.nanoTime();
        this.binManager.update();
        long time1 = System.nanoTime();
        this.impulses.applyChanges();
        if (!this.impulses.isEmpty()) {
            this.applyImpulses((Set<Entity>)this.impulses);
        }
        long time2 = System.nanoTime();
        double tpf = FPS60;
        this.phys.integrate(time.getTime(), tpf);
        long end = System.nanoTime();
        if (end - start > 50000000L) {
            log.warn(String.format("update time: %.03f ms, binManager: %.03f, impulses: %.03f, integration: %.03f, diag: %s", (double)(end - start) / 1000000.0, (double)(time1 - start) / 1000000.0, (double)(time2 - time2) / 1000000.0, (double)(end - time2) / 1000000.0, this.getDiagnostics()));
        }
    }

    public void stop() {
        super.stop();
        this.impulses.release();
    }

    protected void applyImpulses(Set<Entity> impulses) {
        for (Entity e : impulses) {
            Impulse imp = (Impulse)e.get(Impulse.class);
            if (!this.phys.applyImpulse((Object)e.getId(), imp.getLinearVelocity())) continue;
            this.ed.removeComponent(e.getId(), Impulse.class);
        }
    }
}

