/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.account.base;

import com.simsilica.account.Account;
import com.simsilica.account.AccountManager;
import com.simsilica.account.base.AccountStorage;
import com.simsilica.account.base.AuthResult;
import com.simsilica.account.base.Authenticator;
import com.simsilica.account.base.DefaultAccount;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccountManager
implements AccountManager {
    static Logger log = LoggerFactory.getLogger(DefaultAccountManager.class);
    private AccountStorage storage;
    private Map<String, Authenticator> auths = new LinkedHashMap<String, Authenticator>();
    private Function<String, String> guidGenerator;

    public DefaultAccountManager(AccountStorage storage) {
        this.storage = storage;
    }

    public void setGuidGenerator(Function<String, String> guidGenerator) {
        this.guidGenerator = guidGenerator;
    }

    protected DefaultAccount createDefaultAccount(String globalUserId, String userId, Map<String, Object> properties) {
        return new DefaultAccount(globalUserId, userId, properties);
    }

    public void addAuthenticator(Authenticator auth) {
        this.auths.put(auth.getName(), auth);
    }

    public void removeAuthenticator(Authenticator auth) {
        this.auths.values().remove(auth);
    }

    @Override
    public List<String> getCredentialTypes() {
        return new ArrayList<String>(this.auths.keySet());
    }

    @Override
    public Account login(String userId, String randomSalt, Map<String, Object> credentials) {
        Account account = this.getAccount(userId);
        if (account == null) {
            throw new IllegalArgumentException("Invalid user ID");
        }
        for (Authenticator auth : this.auths.values()) {
            AuthResult result = auth.authenticate(account, randomSalt, credentials);
            switch (result) {
                case Success: {
                    return account;
                }
                default: {
                    throw new RuntimeException("Invalid credentials");
                }
                case Ignore: 
            }
        }
        throw new IllegalArgumentException("No authenticators matched supplied credentials");
    }

    @Override
    public Account createAccount(String userId, Map<String, Object> info) {
        DefaultAccount account = (DefaultAccount)this.getAccount(userId);
        if (account != null) {
            throw new IllegalArgumentException("User already exists:" + userId + "  global ID:" + account.getGlobalUserId());
        }
        String guid = userId;
        if (this.guidGenerator != null) {
            guid = this.guidGenerator.apply(userId);
        }
        account = this.createDefaultAccount(guid, userId, info);
        this.storage.store(account);
        return account;
    }

    @Override
    public void saveAccount(Account account) {
        if (!this.storage.exists(account.getGlobalUserId())) {
            throw new IllegalArgumentException("Account has not been created");
        }
        this.storage.store((DefaultAccount)account);
    }

    @Override
    public Account getAccount(String userId) {
        DefaultAccount result = this.storage.load(userId);
        if (result != null) {
            return result;
        }
        if (this.guidGenerator == null) {
            return null;
        }
        String guid = this.guidGenerator.apply(userId);
        result = this.storage.load(guid);
        return result;
    }
}

