/*
 * Decompiled with CFR 0.152.
 */
package mythruna;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.List;
import mythruna.Coordinates;
import mythruna.Direction;
import mythruna.World;
import mythruna.db.BlueprintData;
import mythruna.db.BlueprintDatabase;
import mythruna.db.CachingBlueprintDatabase;
import mythruna.db.CellAccess;
import mythruna.db.LeafData;
import mythruna.db.WorldDatabase;
import mythruna.es.EntityData;

public class DefaultWorld
implements World {
    public static final int CACHE_DEPTH = 1210;
    private static final Vector3f SPAWN_LOCATION = new Vector3f(512.5f, 512.5f, 78.0f);
    private static final Quaternion SPAWN_DIRECTION = Quaternion.DIRECTION_Z;
    private WorldDatabase worldDb;
    private CellAccess cellAccess;
    private CachingBlueprintDatabase bpDb;
    private EntityData entityData;
    private Vector3f defaultLoc = SPAWN_LOCATION;
    private Quaternion defaultDir = SPAWN_DIRECTION;

    public DefaultWorld(WorldDatabase worldDb, BlueprintDatabase bpDb, EntityData entityData) {
        this.worldDb = worldDb;
        this.cellAccess = worldDb;
        this.entityData = entityData;
        this.bpDb = new CachingBlueprintDatabase(bpDb);
    }

    @Override
    public void setCellAccess(CellAccess access) {
        this.cellAccess = access;
    }

    @Override
    public void close() {
        this.entityData.close();
        this.worldDb.close();
        this.bpDb.close();
    }

    @Override
    public EntityData getEntityData() {
        return this.entityData;
    }

    @Override
    public WorldDatabase getWorldDatabase() {
        return this.worldDb;
    }

    @Override
    public List<Long> getBlueprintIds() {
        return this.bpDb.getIds();
    }

    @Override
    public BlueprintData getBlueprint(long id) {
        return this.bpDb.getBlueprint(id);
    }

    @Override
    public BlueprintData getBlueprint(long id, boolean load) {
        return this.bpDb.getBlueprint(id, load);
    }

    @Override
    public BlueprintData createBlueprint(String name, int xSize, int ySize, int zSize, float scale, int[][][] cells) {
        return this.bpDb.createBlueprint(name, xSize, ySize, zSize, scale, cells);
    }

    @Override
    public void setDefaultSpawnLocation(Vector3f loc) {
        this.defaultLoc = loc;
    }

    @Override
    public Vector3f getDefaultSpawnLocation() {
        return this.defaultLoc;
    }

    @Override
    public void setDefaultSpawnDirection(Quaternion quat) {
        this.defaultDir = quat;
    }

    @Override
    public Quaternion getDefaultSpawnDirection() {
        return this.defaultDir;
    }

    @Override
    public int findEmptySpace(float x, float y, float z, int height, LeafData local) {
        return this.findEmptySpace(Coordinates.worldToCell(x), Coordinates.worldToCell(y), Coordinates.worldToCell(z), height, local);
    }

    @Override
    public final int findEmptySpace(int x, int y, int z, int height, LeafData local) {
        int z1 = z;
        for (int z2 = z; z1 > 0 && z2 < 160; --z1, ++z2) {
            int type;
            int count = 0;
            int i = z1;
            while (i < z1 + height && (type = this.getType(x, y, i, local)) == 0) {
                ++i;
                ++count;
            }
            if (count == height) {
                return z1;
            }
            count = 0;
            i = z2;
            while (i < z2 + height && (type = this.getType(x, y, i, local)) == 0) {
                ++i;
                ++count;
            }
            if (count != height) continue;
            return z2;
        }
        return 160;
    }

    public final LeafData getLeaf(int x, int y, int z, LeafData local) {
        if (local != null && local.contains(x, y, z)) {
            return local;
        }
        return this.worldDb.getLeaf(x, y, z);
    }

    @Override
    public final int getType(float x, float y, float z, LeafData local) {
        return this.getType(Coordinates.worldToCell(x), Coordinates.worldToCell(y), Coordinates.worldToCell(z), local);
    }

    @Override
    public final int getType(int x, int y, int z, LeafData local) {
        if (z < 0) {
            return 1;
        }
        LeafData leaf = this.getLeaf(x, y, z, local);
        if (leaf == null) {
            return 0;
        }
        return leaf.getWorld(x, y, z);
    }

    @Override
    public final int getType(int x, int y, int z, int dir, LeafData local) {
        return this.getType(x += Direction.DIRS[dir][0], y += Direction.DIRS[dir][1], z += Direction.DIRS[dir][2], local);
    }

    @Override
    public final int getSunlight(int x, int y, int z, LeafData local) {
        LeafData leaf = this.getLeaf(x, y, z, local);
        if (leaf == null) {
            return 15;
        }
        return leaf.getWorldSunlight(x, y, z);
    }

    @Override
    public final int getLocalLight(int x, int y, int z, LeafData local) {
        LeafData leaf = this.getLeaf(x, y, z, local);
        if (leaf == null) {
            return 15;
        }
        return leaf.getWorldLocalLight(x, y, z);
    }

    @Override
    public final int getCellType(int x, int y, int z) {
        return this.worldDb.getCellType(x, y, z);
    }

    @Override
    public final int getLight(int lightType, int x, int y, int z) {
        return this.worldDb.getLight(lightType, x, y, z);
    }

    @Override
    public final void setCellType(int x, int y, int z, int type) {
        this.cellAccess.setCellType(x, y, z, type);
    }
}

