/*
 * Decompiled with CFR 0.152.
 */
package mythruna;

import mythruna.Month;

public class GameTime {
    private static final double TO_MINUTES = 0.016666666666666666;
    private static final double TO_HOURS = 2.777777777777778E-4;
    private static final double TO_DAYS = 1.1574074074074073E-5;
    private static final int MONTHS_IN_A_YEAR = 4;
    private static final int DAYS_IN_A_WEEK = 7;
    private static final int DAYS_IN_A_MONTH = 28;
    private static final int DAYS_IN_A_YEAR = 112;
    private long offset;
    private double scale = 1.0;
    private double toGameTime = this.scale / 1000.0;

    public final int getGameDay() {
        double t = this.getTime();
        double d = t * 1.1574074074074073E-5;
        return (int)Math.floor(d);
    }

    public static int toGameDay(double time) {
        double d = time * 1.1574074074074073E-5;
        return (int)Math.floor(d);
    }

    public static int dayOfMonth(int gameDay) {
        int m = gameDay / 28;
        return gameDay - m * 28;
    }

    public final int getMonthDay() {
        int d = this.getGameDay();
        int m = d / 28;
        return d - m * 28;
    }

    public final int getMonthNumber() {
        int m = this.getGameDay() / 28;
        return m;
    }

    public final Month getMonth() {
        int m = this.getMonthNumber() % 4;
        switch (m) {
            default: {
                return Month.SPRING;
            }
            case 1: {
                return Month.SUMMER;
            }
            case 2: {
                return Month.FALL;
            }
            case 3: 
        }
        return Month.WINTER;
    }

    public final int getYear() {
        int d = this.getGameDay();
        return d / 112;
    }

    public void setTimeScale(double scale) {
        this.scale = scale;
        this.toGameTime = scale / 1000.0;
    }

    public double getTimeScale() {
        return this.scale;
    }

    public void setTime(double seconds) {
        if (seconds < 0.0) {
            seconds += 86400.0;
        }
        long ms = (long)(seconds / this.toGameTime);
        long current = System.currentTimeMillis();
        this.offset = current - ms;
    }

    public double getTime() {
        long current = System.currentTimeMillis() - this.offset;
        return (double)current * this.toGameTime;
    }
}

