/*
 * Decompiled with CFR 0.152.
 */
package mythruna;

import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.material.MaterialDef;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector4f;
import com.jme3.texture.Texture;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class MaterialIndex {
    public static final int MAT_DIRT = 0;
    public static final int MAT_GRASS_SIDE = 1;
    public static final int MAT_GRASS = 2;
    public static final int MAT_SAND = 3;
    public static final int MAT_STONE = 4;
    public static final int MAT_COBBLE = 5;
    public static final int MAT_ROCK = 6;
    public static final int MAT_WATER = 7;
    public static final int MAT_BARK = 8;
    public static final int MAT_LEAVES = 9;
    public static final int MAT_WADDLE = 10;
    public static final int MAT_PLANKS_LR = 11;
    public static final int MAT_FIRE = 12;
    public static final int MAT_RAW_WOOD = 13;
    public static final int MAT_ROCK_WALL_SIDE = 14;
    public static final int MAT_STONE_TILE = 15;
    public static final int MAT_ROCK_TOP = 16;
    public static final int MAT_DIRT_TOP = 17;
    public static final int MAT_GLASS = 18;
    public static final int MAT_MINERALS = 19;
    public static final int MAT_BLACK_MARBLE = 20;
    public static final int MAT_PLANKS_UD = 21;
    public static final int MAT_GRASS_BLADES = 22;
    public static final int MAT_WATER2 = 24;
    public static final int MAT_LEAVES2 = 25;
    public static final int MAT_LEAVES3 = 26;
    public static final int MAT_PINE = 32;
    public static final int MAT_FLORA = 33;
    public static final int MAT_GRASS_BLADES_TEST = 500;
    public static Material DEBUG_MATERIAL;
    public static Material TRANSPARENT_MATERIAL;
    public static Material FIELD_MATERIAL;
    public static Material ROPE_MATERIAL;
    private static final String baseLightingDef = "MatDefs/LightingWithFog.j3md";
    private static final String baseWaterDef = "MatDefs/WaterLightingWithFog.j3md";
    private static final String baseGrassDef = "MatDefs/Grass.j3md";
    private static final String baseFlatDef = "Common/MatDefs/Misc/Unshaded.j3md";
    private static final String noiseTex = "Textures/noise.png";
    private static final String softNoiseTex = "Textures/soft-noise-256.jpg";
    private static final String baseLeafDef = "MatDefs/Leaf.j3md";
    protected static ColorRGBA ambient;
    protected static ColorRGBA diffuse;
    protected static ColorRGBA specular;
    protected static ColorRGBA fogColor;
    protected static Vector4f timeParms;
    private static MaterialIndex instance;
    private AssetManager assets;
    private List<Material> materials = new ArrayList<Material>();
    private static Material waterMaterial1;
    private static Material waterMaterial2;
    private static boolean flat;
    private static String size;
    private static boolean vertexLighting;
    private static boolean lowQuality;
    private static boolean gritty;

    public static void initialize(AssetManager assets) {
        if (MaterialIndex.instance.assets != null) {
            throw new RuntimeException("Material index already initialized.");
        }
        instance.createBaseMaterials(assets);
        DEBUG_MATERIAL = new Material(assets, baseFlatDef);
        DEBUG_MATERIAL.setColor("Color", ColorRGBA.Red);
        TRANSPARENT_MATERIAL = new Material(assets, baseFlatDef);
        TRANSPARENT_MATERIAL.setColor("Color", new ColorRGBA(1.0f, 0.0f, 0.0f, 0.0f));
        TRANSPARENT_MATERIAL.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        TextureKey key = new TextureKey(softNoiseTex);
        key.setGenerateMips(false);
        Texture t = assets.loadTexture(key);
        t.setWrap(Texture.WrapMode.Repeat);
        FIELD_MATERIAL = new Material(assets, "MatDefs/ForceField.j3md");
        FIELD_MATERIAL.setColor("Color", ColorRGBA.Red);
        FIELD_MATERIAL.setTexture("ColorMap", t);
        FIELD_MATERIAL.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        ROPE_MATERIAL = instance.createRopeMaterial(assets);
    }

    public static void setResolution(int width, int height) {
        float quadratic = (float)height / 720.0f * 6.0f;
        for (Material m : MaterialIndex.getInstance().materials) {
            if (m == null || m.getParam("Quadratic") == null) continue;
            m.setFloat("Quadratic", quadratic);
        }
    }

    public static void setVertexLighting(boolean flag) {
        if (vertexLighting == flag) {
            return;
        }
        vertexLighting = flag;
        for (Material m : MaterialIndex.getInstance().materials) {
            if (m == null || m.getParam("VertexLighting") == null) continue;
            m.setBoolean("VertexLighting", vertexLighting);
        }
    }

    public static boolean getVertexLighting() {
        return vertexLighting;
    }

    public static void setLowQuality(boolean flag) {
        if (lowQuality == flag) {
            return;
        }
        lowQuality = flag;
        for (Material m : MaterialIndex.getInstance().materials) {
            if (m == null || m.getParam("LowQuality") == null) continue;
            m.setBoolean("LowQuality", lowQuality);
        }
    }

    public static boolean getLowQuality() {
        return lowQuality;
    }

    public static void setGritty(boolean flag) {
        if (gritty == flag) {
            return;
        }
        gritty = flag;
        if (instance == null) {
            return;
        }
        Texture gritTexture = MaterialIndex.getInstance().loadTexture(softNoiseTex, TextureRepeat.XY, true);
        MaterialIndex.dump();
        for (Material m : MaterialIndex.getInstance().materials) {
            MaterialDef def;
            String name;
            if (m == null || m.getParam("DiffuseMap") == null || !baseLightingDef.equals(name = (def = m.getMaterialDef()).getAssetName())) continue;
            if (gritty) {
                m.setTexture("NoiseMap", gritTexture);
                continue;
            }
            m.clearParam("NoiseMap");
        }
    }

    public static boolean getGritty() {
        return gritty;
    }

    public static void dump() {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(System.out));
        MaterialIndex.dump(out);
        out.flush();
    }

    public static void dump(PrintWriter out) {
        for (int i = 0; i < MaterialIndex.getInstance().materials.size(); ++i) {
            Material m = MaterialIndex.getInstance().materials.get(i);
            if (m == null) continue;
            MaterialIndex.dump(m, i, out);
        }
    }

    public static void dump(Material m, int index, PrintWriter out) {
        MaterialDef def = m.getMaterialDef();
        String name = m.getAssetName();
        if (name == null) {
            name = String.valueOf(index);
        }
        out.println("Material " + name + " : " + def.getAssetName() + " {");
        for (MatParam p : m.getParams()) {
            out.println("    " + p.getName() + " : " + p.getValueAsString());
        }
        out.println("}");
    }

    public static MaterialIndex getInstance() {
        return instance;
    }

    public static Material getMaterial(int index) {
        return MaterialIndex.getInstance().materials.get(index);
    }

    public static void setAmbient(ColorRGBA c) {
        ambient.set(c);
    }

    public static ColorRGBA getAmbient() {
        return ambient;
    }

    public static void setDiffuse(ColorRGBA c) {
        diffuse.set(c);
    }

    public static ColorRGBA getDiffuse() {
        return diffuse;
    }

    public static void setSpecular(ColorRGBA c) {
        specular.set(c);
    }

    public static ColorRGBA getSpecular() {
        return specular;
    }

    public static void setFogColor(ColorRGBA c) {
        fogColor.set(c);
    }

    public static ColorRGBA getFogColor() {
        return fogColor;
    }

    public static void setTimeParms(Vector4f v) {
        timeParms.set(v);
    }

    public static void setWaterWaves(float cos, float sin) {
        if (waterMaterial1 != null) {
            waterMaterial1.setFloat("WaveSin", sin);
            waterMaterial1.setFloat("WaveCos", cos);
        }
        if (waterMaterial2 != null) {
            waterMaterial2.setFloat("WaveSin", sin);
            waterMaterial2.setFloat("WaveCos", cos);
        }
    }

    protected MaterialIndex() {
    }

    protected void setLookupNormals(int index, boolean f) {
        this.materials.get(index).setBoolean("NormalLookup", f);
    }

    protected void createBaseMaterials(AssetManager assets) {
        this.assets = assets;
        this.addMaterial("Textures/" + size + "brown-dirt2.jpg", "Textures/brown-dirt-norm.jpg", 128.0f);
        this.setLookupNormals(0, true);
        this.addMaterial("Textures/" + size + "brown-dirt-side2.jpg", "Textures/brown-dirt-side-norms.jpg", "Textures/" + size + "brown-dirt-side-bump.jpg", 128.0f, false, TextureRepeat.X);
        this.setLookupNormals(1, true);
        this.addMaterial("Textures/" + size + "grass.jpg", "Textures/grass-norm.jpg", 16.0f);
        this.setLookupNormals(2, true);
        this.addMaterial("Textures/" + size + "sand.jpg", "Textures/grass-norm.jpg", 2.0f);
        this.setLookupNormals(3, true);
        this.addMaterial("Textures/" + size + "ROCK6-lighter.jpg", "Textures/ROCK6-norm.jpg", 10.0f);
        this.setLookupNormals(4, true);
        this.addMaterial("Textures/" + size + "pebbles.jpg", "Textures/pebbles-norm.jpg", "Textures/pebbles-bumps.jpg", 50.0f);
        this.setLookupNormals(5, true);
        this.addMaterial("Textures/" + size + "rock-wall.png", "Textures/rock-wall-normal.jpg", "Textures/rock-wall-bumps.jpg", 50.0f);
        this.setLookupNormals(6, true);
        this.addWaterMaterial("Textures/" + size + "water.png", null, 1.0f, true, true, false);
        this.setLookupNormals(7, true);
        this.addMaterial("Textures/" + size + "bark128.jpg", "Textures/bark128-normal.png", "Textures/bark128-bump.png", 64.0f);
        this.setLookupNormals(8, true);
        this.addMaterial("Textures/" + size + "leaves3.png", null, 16.0f, true);
        this.setLookupNormals(9, true);
        this.addMaterial("Textures/" + size + "waddle-daub-plain.png", "Textures/waddle-daub-plain-normal.png", "Textures/waddle-daub-plain-bumps.png", 55.0f, false, TextureRepeat.XY);
        this.setLookupNormals(10, true);
        this.addMaterial("Textures/" + size + "wood-planks-lr.png", "Textures/wood-planks-lr-normal.png", "Textures/wood-planks-lr-bump.png", 15.0f, false, TextureRepeat.XY);
        this.setLookupNormals(11, true);
        this.addLightMaterial("Textures/" + size + "fire7.jpg");
        this.addMaterial("Textures/" + size + "bark128-top.png", "Textures/bark128-top-normal.png", "Textures/bark128-top-bump.png", 60.0f);
        this.setLookupNormals(13, true);
        this.addMaterial("Textures/" + size + "ROCK-wall-top-side.png", "Textures/ROCK-wall-top-side-normal.png", "Textures/rock-wall-side-bumps.jpg", 50.0f, false, TextureRepeat.X);
        this.setLookupNormals(14, true);
        this.addMaterial("Textures/" + size + "rock-wall-top.png", "Textures/rock-wall-top-normal.png", 50.0f);
        this.setLookupNormals(15, true);
        this.addMaterial("Textures/" + size + "rock-wall-rock-top.png", "Textures/rock-wall-rock-top-normal.png", 50.0f);
        this.setLookupNormals(16, true);
        this.addMaterial("Textures/" + size + "brown-dirt-top.png", "Textures/brown-dirt-norm.jpg", 100.0f);
        this.setLookupNormals(17, true);
        this.addMaterial("Textures/" + size + "glass.png", null, 1.0f, true);
        this.setLookupNormals(18, true);
        this.addMaterial("Textures/" + size + "minerals.png", "Textures/minerals-normal.png", 10.0f);
        this.setLookupNormals(19, true);
        this.addMaterial("Textures/" + size + "black-marble.jpg", null, 1.0f);
        this.setLookupNormals(20, true);
        this.addMaterial("Textures/" + size + "wood-planks.png", "Textures/wood-planks-normal.png", "Textures/wood-planks-bump.png", 15.0f, false, TextureRepeat.XY);
        this.setLookupNormals(21, true);
        this.addGrassMaterial("Textures/" + size + "blades-atlas.png", "Textures/grass.jpg", "Textures/blades-bases-atlas.png", 100.0f);
        this.addMaterial("Textures/" + size + "bark90-128.jpg", "Textures/bark90-128-normal.png", "Textures/bark90-128-bump.png", 64.0f);
        this.setLookupNormals(23, true);
        this.addWaterMaterial("Textures/" + size + "water.png", null, 1.0f, true, true, true);
        this.setLookupNormals(24, true);
        this.addLeafMaterial("Textures/" + size + "leaf-atlas.png", null, null, 16.0f, true, null, true);
        this.addLeafMaterial("Textures/" + size + "leaf-atlas2.png", null, null, 16.0f, true, null, true);
        this.addMaterial("Textures/" + size + "white-marble.jpg", null, 1.0f);
        this.setLookupNormals(27, true);
        this.addMaterial("Textures/" + size + "wood-planks.png", null, null, 15.0f, false, TextureRepeat.XY);
        this.addLeafMaterial("Textures/" + size + "hay.png", null, null, 15.0f, true, null, true);
        this.addLeafMaterial("Textures/" + size + "hay-framed.png", null, null, 15.0f, true, null, true);
        this.addFlameMaterial("Textures/flame.png");
        this.addLeafMaterial("Textures/pine-branch.png", null, null, 16.0f, true, null, true);
        this.addFloraMaterial("Textures/" + size + "wildflowers.png");
        this.addMaterial("Textures/" + size + "bark-chopped-128.png", "Textures/bark-chopped-128-normal.png", "Textures/bark-chopped-128-bump.png", 60.0f, false, TextureRepeat.X);
        this.setLookupNormals(34, true);
        this.addMaterial("Textures/shingles.png", "Textures/shingles-normal.png", "Textures/shingles-bump.png", 15.0f, false, TextureRepeat.XY);
        this.setLookupNormals(35, true);
        this.addMaterial("Textures/shingles-lr.png", "Textures/shingles-normal-lr.png", "Textures/shingles-bump-lr.png", 15.0f, false, TextureRepeat.XY);
        this.setLookupNormals(36, true);
        this.addMaterial("Textures/mortared-rock.jpg", "Textures/mortared-rock-norm.jpg", "Textures/mortared-rock-bumps.jpg", 15.0f, false, TextureRepeat.XY);
        this.setLookupNormals(37, true);
        this.setNextIndex(100);
        this.addMaterial("Textures/" + size + "brown-dirt2.jpg", "Textures/brown-dirt-norm.jpg", 128.0f);
        this.addMaterial("Textures/" + size + "brown-dirt-side2.jpg", "Textures/brown-dirt-side-norms.jpg", "Textures/" + size + "brown-dirt-side-bump.jpg", 128.0f, false, TextureRepeat.X);
        this.addMaterial("Textures/" + size + "grass.jpg", "Textures/grass-norm.jpg", 16.0f);
        this.addMaterial("Textures/" + size + "sand.jpg", "Textures/grass-norm.jpg", 2.0f);
        this.addMaterial("Textures/" + size + "ROCK6-lighter.jpg", "Textures/ROCK6-norm.jpg", 10.0f);
        this.addMaterial("Textures/" + size + "pebbles.jpg", "Textures/pebbles-norm.jpg", "Textures/pebbles-bumps.jpg", 50.0f);
        this.addMaterial("Textures/" + size + "rock-wall.png", "Textures/ROCK8-norm.jpg", 50.0f);
        this.addWaterMaterial("Textures/" + size + "water.png", null, 1.0f, true, true, false);
        this.addMaterial("Textures/" + size + "bark128.jpg", "Textures/bark128-normal.png", "Textures/bark128-bump.png", 64.0f);
        this.addMaterial("Textures/" + size + "leaves3.png", null, 16.0f, true);
        this.addMaterial("Textures/" + size + "waddle-daub-plain.png", "Textures/waddle-daub-plain-normal.png", "Textures/waddle-daub-plain-bumps.png", 55.0f, false, TextureRepeat.XY);
        this.addMaterial("Textures/" + size + "wood-planks-lr.png", "Textures/wood-planks-lr-normal.png", "Textures/wood-planks-lr-bump.png", 15.0f, false, TextureRepeat.XY);
        this.addLightMaterial("Textures/" + size + "fire7.jpg");
        this.addMaterial("Textures/" + size + "bark128-top.png", "Textures/bark128-top-normal.png", "Textures/bark128-top-bump.png", 60.0f);
        this.addMaterial("Textures/" + size + "ROCK-wall-top-side.png", "Textures/ROCK-wall-top-side-normal.png", null, 50.0f, false, TextureRepeat.X);
        this.addMaterial("Textures/" + size + "rock-wall-top.png", "Textures/rock-wall-top-normal.png", 50.0f);
        this.addMaterial("Textures/" + size + "rock-wall-rock-top.png", "Textures/rock-wall-rock-top-normal.png", 50.0f);
        this.addMaterial("Textures/" + size + "brown-dirt-top.png", "Textures/brown-dirt-norm.jpg", 100.0f);
        this.addMaterial("Textures/" + size + "glass.png", null, 1.0f, true);
        this.addMaterial("Textures/" + size + "minerals.png", "Textures/minerals-normal.png", 10.0f);
        this.addMaterial("Textures/" + size + "black-marble.jpg", null, 1.0f);
        this.addMaterial("Textures/" + size + "wood-planks.png", "Textures/wood-planks-normal.png", "Textures/wood-planks-bump.png", 15.0f, false, TextureRepeat.XY);
        this.addGrassMaterial("Textures/" + size + "blades-atlas.png", "Textures/grass.jpg", "Textures/blades-bases-atlas.png", 100.0f);
        this.addMaterial("Textures/" + size + "bark90-128.jpg", "Textures/bark90-128-normal.png", "Textures/bark90-128-bump.png", 64.0f);
        this.addWaterMaterial("Textures/" + size + "water.png", null, 1.0f, true, true, true);
        this.addLeafMaterial("Textures/" + size + "leaf-atlas.png", null, null, 16.0f, true, null, true);
        this.addLeafMaterial("Textures/" + size + "leaf-atlas2.png", null, null, 16.0f, true, null, true);
        this.addMaterial("Textures/" + size + "white-marble.jpg", null, 1.0f);
        this.addMaterial("Textures/" + size + "wood-planks.png", null, null, 15.0f, false, TextureRepeat.XY);
        this.setNextIndex(134);
        this.addMaterial("Textures/" + size + "bark-chopped-128.png", "Textures/bark-chopped-128-normal.png", "Textures/bark-chopped-128-bump.png", 60.0f, false, TextureRepeat.X);
        this.addMaterial("Textures/shingles.png", "Textures/shingles-normal.png", "Textures/shingles-bump.png", 15.0f, false, TextureRepeat.XY);
        this.addMaterial("Textures/shingles-lr.png", "Textures/shingles-normal-lr.png", "Textures/shingles-bump-lr.png", 15.0f, false, TextureRepeat.XY);
        this.addMaterial("Textures/mortared-rock.jpg", "Textures/mortared-rock-norm.jpg", "Textures/mortared-rock-bumps.jpg", 15.0f, false, TextureRepeat.XY);
        this.setNextIndex(500);
        this.addMaterial("Textures/" + size + "grass.jpg", "Textures/grass-norm.jpg", 16.0f);
        this.materials.get(500).getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
    }

    protected Material createRopeMaterial(AssetManager assets) {
        Material mat = new Material(assets, "MatDefs/Rope.j3md");
        Texture t = this.loadTexture("Textures/rope.png", TextureRepeat.XY, true);
        if (t == null) {
            throw new RuntimeException("No texture found for: Textures/waddle-daub-plain.png");
        }
        mat.setTexture("DiffuseMap", t);
        t = this.loadTexture("Textures/rope-normal.jpg", TextureRepeat.XY, true);
        mat.setTexture("NormalMap", t);
        t = this.loadTexture("Textures/rope-bumps.jpg", TextureRepeat.XY, true);
        mat.setTexture("ParallaxMap", t);
        mat.setColor("Diffuse", diffuse);
        mat.setColor("Ambient", ambient);
        mat.setColor("Specular", specular);
        mat.setColor("FogColor", fogColor);
        mat.setVector4("TimeParms", timeParms);
        mat.setFloat("Shininess", 1.0f);
        mat.setBoolean("UseMaterialColors", true);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        float thickness = 0.1f;
        mat.setFloat("Thickness", thickness);
        return mat;
    }

    protected Texture loadTexture(String path, TextureRepeat texRepeat, boolean generateMips) {
        TextureKey key = new TextureKey(path);
        key.setGenerateMips(generateMips);
        Texture t = this.assets.loadTexture(key);
        if (t == null) {
            throw new RuntimeException("Error loading texture:" + path);
        }
        if (texRepeat != null) {
            switch (texRepeat) {
                case NONE: {
                    t.setWrap(Texture.WrapMode.Clamp);
                    break;
                }
                case X: {
                    t.setWrap(Texture.WrapAxis.S, Texture.WrapMode.Repeat);
                    break;
                }
                case Y: {
                    t.setWrap(Texture.WrapAxis.T, Texture.WrapMode.Repeat);
                    break;
                }
                case XY: {
                    t.setWrap(Texture.WrapMode.Repeat);
                }
            }
        }
        return t;
    }

    public void setNextIndex(int index) {
        while (this.materials.size() < index) {
            this.materials.add(null);
        }
    }

    public int addMaterial(String diffuseTex, String normalsTex, String bumpsTex, float shininess, boolean alpha, TextureRepeat texRepeat) {
        return this.addMaterial(diffuseTex, normalsTex, bumpsTex, shininess, alpha, texRepeat, true);
    }

    public int addMaterial(String diffuseTex, String normalsTex, String bumpsTex, float shininess, boolean alpha, TextureRepeat texRepeat, boolean generateMips) {
        Material mat = new Material(this.assets, baseLightingDef);
        mat.setTexture("DiffuseMap", this.loadTexture(diffuseTex, texRepeat, generateMips));
        if (normalsTex != null && !flat) {
            mat.setTexture("NormalMap", this.loadTexture(normalsTex, texRepeat, generateMips));
        }
        if (bumpsTex != null && !flat) {
            mat.setTexture("ParallaxMap", this.loadTexture(bumpsTex, texRepeat, generateMips));
        }
        if (gritty) {
            mat.setTexture("NoiseMap", this.loadTexture(softNoiseTex, TextureRepeat.XY, true));
        }
        mat.setColor("Diffuse", diffuse);
        mat.setColor("Ambient", ambient);
        mat.setColor("Specular", specular);
        mat.setColor("FogColor", fogColor);
        mat.setVector4("TimeParms", timeParms);
        mat.setFloat("Shininess", shininess);
        mat.setBoolean("UseMaterialColors", true);
        mat.setBoolean("VertexLighting", vertexLighting);
        mat.setBoolean("LowQuality", lowQuality);
        if (alpha) {
            mat.setBoolean("UseAlpha", true);
            mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        }
        int result = this.materials.size();
        this.materials.add(mat);
        return result;
    }

    public int addLeafMaterial(String diffuseTex, String normalsTex, String bumpsTex, float shininess, boolean alpha, TextureRepeat texRepeat, boolean generateMips) {
        Material mat = new Material(this.assets, baseLeafDef);
        mat.setTexture("DiffuseMap", this.loadTexture(diffuseTex, texRepeat, generateMips));
        if (normalsTex != null && !flat) {
            mat.setTexture("NormalMap", this.loadTexture(normalsTex, texRepeat, generateMips));
        }
        if (bumpsTex != null && !flat) {
            mat.setTexture("ParallaxMap", this.loadTexture(bumpsTex, texRepeat, generateMips));
        }
        mat.setColor("Diffuse", diffuse);
        mat.setColor("Ambient", ambient);
        mat.setColor("Specular", specular);
        mat.setColor("FogColor", fogColor);
        mat.setFloat("Shininess", shininess);
        mat.setBoolean("UseMaterialColors", true);
        mat.setBoolean("VertexLighting", vertexLighting);
        mat.setBoolean("LowQuality", lowQuality);
        if (alpha) {
            mat.setBoolean("UseAlpha", true);
            mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        }
        int result = this.materials.size();
        this.materials.add(mat);
        return result;
    }

    protected int addMaterial(String diffuseTex, String normalsTex, float shininess) {
        return this.addMaterial(diffuseTex, normalsTex, null, shininess, false, TextureRepeat.XY);
    }

    protected int addMaterial(String diffuseTex, String normalsTex, String bumpsTex, float shininess) {
        return this.addMaterial(diffuseTex, normalsTex, bumpsTex, shininess, false, TextureRepeat.XY);
    }

    protected int addMaterial(String diffuseTex, String normalsTex, float shininess, boolean alpha) {
        return this.addMaterial(diffuseTex, normalsTex, null, shininess, alpha, TextureRepeat.XY);
    }

    protected int addFlameMaterial(String diffuseTex) {
        Material mat = new Material(this.assets, "MatDefs/Flame.j3md");
        mat.setTexture("Texture", this.loadTexture(diffuseTex, TextureRepeat.NONE, true));
        mat.setBoolean("PointSprite", true);
        mat.setFloat("Quadratic", 6.0f);
        mat.setFloat("Alpha", 1.0f);
        mat.setTexture("NoiseMap", this.loadTexture(noiseTex, TextureRepeat.XY, true));
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.AlphaAdditive);
        int result = this.materials.size();
        this.materials.add(mat);
        return result;
    }

    protected int addFloraMaterial(String diffuseTex) {
        Material mat = new Material(this.assets, "MatDefs/Flora.j3md");
        mat.setTexture("Texture", this.loadTexture(diffuseTex, TextureRepeat.NONE, true));
        mat.setBoolean("PointSprite", true);
        mat.setFloat("Quadratic", 6.0f);
        mat.setFloat("Alpha", 1.0f);
        mat.setTexture("NoiseMap", this.loadTexture(noiseTex, TextureRepeat.XY, true));
        mat.setColor("Ambient", ambient);
        mat.setColor("Diffuse", diffuse);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        int result = this.materials.size();
        this.materials.add(mat);
        return result;
    }

    protected int addGrassMaterial(String diffuseTex, String groundTex, String groundMask, float shininess) {
        Material mat = new Material(this.assets, baseGrassDef);
        Texture texture = this.loadTexture(diffuseTex, TextureRepeat.NONE, true);
        mat.setTexture("DiffuseMap", texture);
        mat.setTexture("GroundMap", this.loadTexture(groundTex, TextureRepeat.XY, true));
        mat.setTexture("GroundMask", this.loadTexture(groundMask, TextureRepeat.XY, true));
        mat.setTexture("NoiseMap", this.loadTexture(noiseTex, TextureRepeat.XY, true));
        mat.setColor("Diffuse", diffuse);
        mat.setColor("Ambient", ambient);
        mat.setColor("FogColor", fogColor);
        mat.setColor("Specular", specular);
        mat.setFloat("Shininess", shininess);
        mat.setBoolean("UseMaterialColors", true);
        mat.setFloat("AlphaDiscardThreshold", 0.3f);
        mat.setBoolean("UseAlpha", true);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        mat.getAdditionalRenderState().setAlphaTest(true);
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        mat.setBoolean("VertexLighting", vertexLighting);
        mat.setBoolean("LowQuality", lowQuality);
        int result = this.materials.size();
        this.materials.add(mat);
        return result;
    }

    protected int addWaterMaterial(String diffuseTex, String normalsTex, float shininess, boolean alpha, boolean twoSided, boolean offset) {
        Material mat = new Material(this.assets, baseWaterDef);
        Texture texture = this.loadTexture(diffuseTex, TextureRepeat.XY, true);
        mat.setTexture("DiffuseMap", texture);
        if (normalsTex != null && !flat) {
            mat.setTexture("NormalMap", this.loadTexture(normalsTex, TextureRepeat.XY, true));
        }
        mat.setColor("Diffuse", diffuse);
        mat.setColor("Ambient", ambient);
        mat.setColor("FogColor", fogColor);
        mat.setColor("Specular", specular);
        mat.setFloat("Shininess", shininess);
        mat.setBoolean("UseMaterialColors", true);
        mat.setBoolean("VertexLighting", vertexLighting);
        mat.setBoolean("LowQuality", lowQuality);
        if (alpha) {
            mat.setBoolean("UseAlpha", true);
            mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        }
        if (twoSided) {
            mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        }
        if (offset) {
            mat.getAdditionalRenderState().setPolyOffset(0.1f, 0.1f);
        }
        if (waterMaterial1 == null) {
            waterMaterial1 = mat;
        } else if (waterMaterial2 == null) {
            waterMaterial2 = mat;
        }
        int result = this.materials.size();
        this.materials.add(mat);
        return result;
    }

    protected int addLightMaterial(String diffuseTex) {
        Material mat = new Material(this.assets, baseFlatDef);
        mat.setTexture("ColorMap", this.loadTexture(diffuseTex, TextureRepeat.XY, true));
        int result = this.materials.size();
        this.materials.add(mat);
        return result;
    }

    static {
        ambient = ColorRGBA.DarkGray.clone();
        diffuse = ColorRGBA.White.clone();
        specular = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
        fogColor = new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f);
        timeParms = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);
        instance = new MaterialIndex();
        flat = false;
        size = "";
        vertexLighting = false;
        lowQuality = false;
        gritty = false;
    }

    private static enum TextureRepeat {
        NONE,
        X,
        Y,
        XY;

    }
}

