/*
 * Decompiled with CFR 0.152.
 */
package mythruna;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mythruna.BoundaryShape;
import mythruna.Direction;
import org.progeeks.util.ObjectUtils;

public class ShapeIndex {
    public static final BoundaryShape NULL_SHAPE = new NullShape();
    private static Map<BoundaryShape, Integer> shapeMap = new HashMap<BoundaryShape, Integer>();
    private static List<BoundaryShape> shapes = new ArrayList<BoundaryShape>();
    public static final BoundaryShape UNIT_SQUARE = ShapeIndex.getRect(0.0f, 0.0f, 1.0f, 1.0f);

    public static BoundaryShape getRect(float xMin, float yMin, float xMax, float yMax) {
        if (xMin < 0.0f || yMin < 0.0f) {
            throw new IllegalArgumentException("range out of bounds");
        }
        if (xMax > 1.0f || yMax > 1.0f) {
            throw new IllegalArgumentException("range out of bounds");
        }
        Rect key = new Rect(xMin, yMin, xMax, yMax);
        Integer result = shapeMap.get(key);
        if (result == null) {
            result = shapes.size();
            shapes.add(key);
            shapeMap.put(key, result);
        }
        return shapes.get(result);
    }

    public static BoundaryShape getTriangle(float xMin, float yMin, float xMax, float yMax, float xNormal, float yNormal) {
        Triangle key = new Triangle(xMin, yMin, xMax, yMax, xNormal, yNormal);
        Integer result = shapeMap.get(key);
        if (result == null) {
            result = shapes.size();
            shapes.add(key);
            shapeMap.put(key, result);
        }
        return shapes.get(result);
    }

    public static BoundaryShape getCircle(float xCenter, float yCenter, float radius) {
        Circle key = new Circle(xCenter, yCenter, radius);
        Integer result = shapeMap.get(key);
        if (result == null) {
            result = shapes.size();
            shapes.add(key);
            shapeMap.put(key, result);
        }
        return shapes.get(result);
    }

    protected static float epsilon(float f) {
        long i = Math.round(f * 10000.0f);
        f = (float)i / 10000.0f;
        return f;
    }

    protected static Vector3f projectPos(Vector2f v, int dir) {
        Vector3f result = new Vector3f();
        switch (dir) {
            case 0: {
                result.x = v.x - 0.5f;
                result.y = -0.5f;
                result.z = v.y - 0.5f;
                break;
            }
            case 1: {
                result.x = v.x - 0.5f;
                result.y = 0.5f;
                result.z = v.y - 0.5f;
                break;
            }
            case 2: {
                result.x = 0.5f;
                result.y = v.x - 0.5f;
                result.z = v.y - 0.5f;
                break;
            }
            case 3: {
                result.x = -0.5f;
                result.y = v.x - 0.5f;
                result.z = v.y - 0.5f;
                break;
            }
            case 4: {
                result.x = v.x - 0.5f;
                result.y = v.y - 0.5f;
                result.z = 0.5f;
                break;
            }
            case 5: {
                result.x = v.x - 0.5f;
                result.y = v.y - 0.5f;
                result.z = -0.5f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction:" + dir);
            }
        }
        return result;
    }

    protected static Vector2f unprojectPos(Vector3f v, int dir) {
        Vector2f result = new Vector2f();
        switch (dir) {
            case 0: {
                result.x = ShapeIndex.epsilon(0.5f + v.x);
                result.y = ShapeIndex.epsilon(0.5f + v.z);
                break;
            }
            case 1: {
                result.x = ShapeIndex.epsilon(0.5f + v.x);
                result.y = ShapeIndex.epsilon(0.5f + v.z);
                break;
            }
            case 2: {
                result.x = ShapeIndex.epsilon(0.5f + v.y);
                result.y = ShapeIndex.epsilon(0.5f + v.z);
                break;
            }
            case 3: {
                result.x = ShapeIndex.epsilon(0.5f + v.y);
                result.y = ShapeIndex.epsilon(0.5f + v.z);
                break;
            }
            case 4: {
                result.x = ShapeIndex.epsilon(0.5f + v.x);
                result.y = ShapeIndex.epsilon(0.5f + v.y);
                break;
            }
            case 5: {
                result.x = ShapeIndex.epsilon(0.5f + v.x);
                result.y = ShapeIndex.epsilon(0.5f + v.y);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction:" + dir);
            }
        }
        return result;
    }

    protected static Vector3f projectDir(Vector2f v, int dir) {
        Vector3f result = new Vector3f();
        switch (dir) {
            case 0: {
                result.x = v.x;
                result.z = v.y;
                break;
            }
            case 1: {
                result.x = v.x;
                result.z = v.y;
                break;
            }
            case 2: {
                result.y = v.x;
                result.z = v.y;
                break;
            }
            case 3: {
                result.y = v.x;
                result.z = v.y;
                break;
            }
            case 4: {
                result.x = v.x;
                result.y = v.y;
                break;
            }
            case 5: {
                result.x = v.x;
                result.y = v.y;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction:" + dir);
            }
        }
        return result;
    }

    protected static Vector2f unprojectDir(Vector3f v, int dir) {
        Vector2f result = new Vector2f();
        switch (dir) {
            case 0: {
                result.x = ShapeIndex.epsilon(v.x);
                result.y = ShapeIndex.epsilon(v.z);
                break;
            }
            case 1: {
                result.x = ShapeIndex.epsilon(v.x);
                result.y = ShapeIndex.epsilon(v.z);
                break;
            }
            case 2: {
                result.x = ShapeIndex.epsilon(v.y);
                result.y = ShapeIndex.epsilon(v.z);
                break;
            }
            case 3: {
                result.x = ShapeIndex.epsilon(v.y);
                result.y = ShapeIndex.epsilon(v.z);
                break;
            }
            case 4: {
                result.x = ShapeIndex.epsilon(v.x);
                result.y = ShapeIndex.epsilon(v.y);
                break;
            }
            case 5: {
                result.x = ShapeIndex.epsilon(v.x);
                result.y = ShapeIndex.epsilon(v.y);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown direction:" + dir);
            }
        }
        return result;
    }

    private static class Circle
    implements BoundaryShape {
        Vector2f center;
        float radius;
        float area;

        public Circle(float xCenter, float yCenter, float radius) {
            this.center = new Vector2f(xCenter, yCenter);
            this.radius = radius;
            this.area = (float)(Math.PI * (double)radius * (double)radius);
        }

        @Override
        public BoundaryShape rotate(int dir, int dirDelta) {
            Vector3f pCenter = ShapeIndex.projectPos(this.center, dir);
            Quaternion rot = new Quaternion().fromAngles(0.0f, 0.0f, (float)Math.PI / 180 * (float)dirDelta * 90.0f);
            pCenter = rot.mult(pCenter);
            int newDir = Direction.rotate(dir, dirDelta);
            Vector2f v1 = ShapeIndex.unprojectPos(pCenter, newDir);
            BoundaryShape result = ShapeIndex.getCircle(v1.x, v1.y, this.radius);
            return result;
        }

        @Override
        public boolean isMatchingFace(BoundaryShape shape) {
            return shape == this;
        }

        @Override
        public float getArea() {
            return this.area;
        }

        public int hashCode() {
            return this.getClass().hashCode() ^ this.center.hashCode() ^ Float.floatToIntBits(this.radius);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Circle other = (Circle)o;
            if (!ObjectUtils.areEqual((Object)other.center, (Object)this.center)) {
                return false;
            }
            return Float.compare(other.radius, this.radius) == 0;
        }

        public String toString() {
            return "Circle[" + this.center + ", " + this.radius + "]";
        }
    }

    private static class Triangle
    implements BoundaryShape {
        Vector2f min;
        Vector2f max;
        Vector2f normal;
        float area;

        public Triangle(float xMin, float yMin, float xMax, float yMax, float xNormal, float yNormal) {
            this.min = new Vector2f(ShapeIndex.epsilon(xMin), ShapeIndex.epsilon(yMin));
            this.max = new Vector2f(ShapeIndex.epsilon(xMax), ShapeIndex.epsilon(yMax));
            this.normal = new Vector2f(ShapeIndex.epsilon(xNormal), ShapeIndex.epsilon(yNormal));
            this.area = (xMax - xMin) * (yMax - yMin) * 0.5f;
        }

        @Override
        public BoundaryShape rotate(int dir, int dirDelta) {
            Vector3f pMin = ShapeIndex.projectPos(this.min, dir);
            Vector3f pMax = ShapeIndex.projectPos(this.max, dir);
            Vector3f pNorm = ShapeIndex.projectDir(this.normal, dir);
            Quaternion rot = new Quaternion().fromAngles(0.0f, 0.0f, (float)Math.PI / 180 * (float)dirDelta * 90.0f);
            pMin = rot.mult(pMin);
            pMax = rot.mult(pMax);
            pNorm = rot.mult(pNorm);
            int newDir = Direction.rotate(dir, dirDelta);
            Vector2f v1 = ShapeIndex.unprojectPos(pMin, newDir);
            Vector2f v2 = ShapeIndex.unprojectPos(pMax, newDir);
            Vector2f n = ShapeIndex.unprojectDir(pNorm, newDir);
            BoundaryShape result = ShapeIndex.getTriangle(Math.min(v1.x, v2.x), Math.min(v1.y, v2.y), Math.max(v1.x, v2.x), Math.max(v1.y, v2.y), n.x, n.y);
            return result;
        }

        @Override
        public boolean isMatchingFace(BoundaryShape shape) {
            return shape == this;
        }

        @Override
        public float getArea() {
            return this.area;
        }

        public int hashCode() {
            return this.getClass().hashCode() ^ this.min.hashCode() ^ this.max.hashCode() * this.normal.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Triangle other = (Triangle)o;
            if (!ObjectUtils.areEqual((Object)other.min, (Object)this.min)) {
                return false;
            }
            if (!ObjectUtils.areEqual((Object)other.max, (Object)this.max)) {
                return false;
            }
            return ObjectUtils.areEqual((Object)other.normal, (Object)this.normal);
        }

        public String toString() {
            return "Triangle[" + this.min + ", " + this.max + ", norm:" + this.normal + "]";
        }
    }

    private static class Rect
    implements BoundaryShape {
        Vector2f min;
        Vector2f max;
        float area;

        public Rect(float xMin, float yMin, float xMax, float yMax) {
            this.min = new Vector2f(xMin, yMin);
            this.max = new Vector2f(xMax, yMax);
            this.area = (xMax - xMin) * (yMax - yMin);
        }

        @Override
        public float getArea() {
            return this.area;
        }

        @Override
        public BoundaryShape rotate(int dir, int dirDelta) {
            Vector3f pMin = ShapeIndex.projectPos(this.min, dir);
            Vector3f pMax = ShapeIndex.projectPos(this.max, dir);
            Quaternion rot = new Quaternion().fromAngles(0.0f, 0.0f, (float)Math.PI / 180 * (float)dirDelta * 90.0f);
            pMin = rot.mult(pMin);
            pMax = rot.mult(pMax);
            int newDir = Direction.rotate(dir, dirDelta);
            Vector2f v1 = ShapeIndex.unprojectPos(pMin, newDir);
            Vector2f v2 = ShapeIndex.unprojectPos(pMax, newDir);
            return ShapeIndex.getRect(Math.min(v1.x, v2.x), Math.min(v1.y, v2.y), Math.max(v1.x, v2.x), Math.max(v1.y, v2.y));
        }

        @Override
        public boolean isMatchingFace(BoundaryShape shape) {
            return shape == this;
        }

        public int hashCode() {
            return this.getClass().hashCode() ^ this.min.hashCode() ^ this.max.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Rect other = (Rect)o;
            if (!ObjectUtils.areEqual((Object)other.min, (Object)this.min)) {
                return false;
            }
            return ObjectUtils.areEqual((Object)other.max, (Object)this.max);
        }

        public String toString() {
            return "Rect[" + this.min + ", " + this.max + "]";
        }
    }

    private static class NullShape
    implements BoundaryShape {
        private NullShape() {
        }

        @Override
        public boolean isMatchingFace(BoundaryShape shape) {
            return false;
        }

        @Override
        public BoundaryShape rotate(int dir, int dirDelta) {
            return this;
        }

        @Override
        public float getArea() {
            return 0.0f;
        }

        public String toString() {
            return "NULL_SHAPE";
        }
    }
}

