/*
 * Decompiled with CFR 0.152.
 */
package mythruna.db;

import java.util.Random;
import mythruna.BlockType;
import mythruna.BlockTypeIndex;
import mythruna.db.TreeFactory;
import mythruna.db.tree.MapleTreeFactory;
import mythruna.db.tree.PineTreeFactory;
import mythruna.db.tree.ScrubTreeFactory;
import mythruna.db.tree.SimpleTreeFactory;

public class LeafUtils {
    public static final int EMPTY_CELLS = 0;
    public static final int SOLID_CELLS = 1;
    private static Random random = new Random(0L);
    public static final int COORDINATE_MASK = 0xFFFFFFF;
    public static final int COORDINATE_BITS = 28;
    public static final int ELEVATION_MASK = 255;
    public static final int ELEVATION_BITS = 8;
    private static final TreeFactory SIMPLE = new SimpleTreeFactory();
    private static final TreeFactory MAPLE = new MapleTreeFactory();
    private static final TreeFactory SCRUB = new ScrubTreeFactory();
    private static final TreeFactory PINE = new PineTreeFactory();
    private static final TreeFactory SMALL_PINE = new PineTreeFactory(0, 3, 4, 3);
    private static final TreeFactory SCRUB_PINE = new PineTreeFactory(4, 3, 3, 6);
    private static TreeFactory[] treeFactories = new TreeFactory[]{SIMPLE, SIMPLE, SIMPLE, SIMPLE, SIMPLE, SIMPLE, SIMPLE, SIMPLE, MAPLE, MAPLE, MAPLE, MAPLE, SCRUB, SCRUB, SMALL_PINE, SMALL_PINE, SCRUB_PINE};
    private static TreeFactory[] rockyFactories = new TreeFactory[]{SIMPLE, SIMPLE, SCRUB, SCRUB, SCRUB, SCRUB_PINE, SCRUB_PINE, SCRUB_PINE, PINE, PINE, PINE, PINE, PINE, PINE, PINE, PINE, PINE};
    private static TreeFactory[] highFactories = new TreeFactory[]{SIMPLE, SIMPLE, SIMPLE, SIMPLE, SCRUB_PINE, PINE, PINE, PINE, PINE, PINE, MAPLE, MAPLE, SCRUB, SCRUB, PINE, PINE, PINE};

    public static int[][] extractTypes(int[][][] cells) {
        int[][] types = new int[32][32];
        for (int i = 0; i < 32; ++i) {
            block1: for (int j = 0; j < 32; ++j) {
                for (int k = 31; k >= 0; --k) {
                    int t = cells[i][j][k];
                    if (t == 0 || t == 10 || t == 82) continue;
                    types[i][j] = t;
                    continue block1;
                }
            }
        }
        return types;
    }

    public static void generateColumnTypes(int[][][] cells, int[][] map, int[][] mapTypes, long seed, int xBase, int yBase, int seaLevel) {
        int j;
        int i;
        int[][] local = new int[32][32];
        for (int i2 = 0; i2 < 32; ++i2) {
            for (int j2 = 0; j2 < 32; ++j2) {
                local[i2][j2] = map[xBase + i2][yBase + j2];
            }
        }
        int[][] types = new int[32][32];
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 32; ++j) {
                types[i][j] = mapTypes[xBase + i][yBase + j];
            }
        }
        random.setSeed(seed);
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 32; ++j) {
                int k;
                int hOrig = local[i][j];
                if (hOrig < 0) {
                    hOrig = 0;
                }
                int deepestDirt = hOrig - 10 + (int)(2.0 - random.nextDouble() * 4.0);
                int h = hOrig;
                int baseValue = types[i][j];
                int topValue = types[i][j];
                int plugValue = 0;
                if (topValue == 82) {
                    plugValue = 82;
                    topValue = 2;
                    baseValue = 1;
                }
                if (baseValue == 2) {
                    baseValue = 1;
                }
                if (baseValue == 3) {
                    deepestDirt += 4;
                }
                BlockType baseType = BlockTypeIndex.types[baseValue];
                BlockType topType = BlockTypeIndex.types[topValue];
                for (k = 0; k < h; ++k) {
                    int v = baseValue;
                    if (k < deepestDirt) {
                        v = 4;
                    } else if (k == h - 1) {
                        v = topValue;
                    }
                    cells[i][j][k] = v;
                }
                if (plugValue != 0) {
                    types[i][j] = 82;
                }
                for (k = h; k < seaLevel; ++k) {
                    cells[i][j][k] = k == seaLevel - 1 ? 8 : 7;
                }
            }
        }
    }
}

