/*
 * Decompiled with CFR 0.152.
 */
package mythruna.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mythruna.BlockType;
import mythruna.BlockTypeIndex;
import mythruna.Coordinates;
import mythruna.Direction;
import mythruna.db.LeafData;
import mythruna.db.LeafInfo;
import mythruna.db.LightType;
import mythruna.db.WorldDatabase;

public class LightPropagation {
    private WorldDatabase world;
    private Map<String, LeafData> cache = new HashMap<String, LeafData>();
    private Map<LeafData, LeafLight> leafLights = new HashMap<LeafData, LeafLight>();
    private LinkedHashSet<LeafLight> pendingLeafs = new LinkedHashSet();
    private Map<LeafData, LeafShadow> leafShadows = new HashMap<LeafData, LeafShadow>();
    private LinkedHashSet<LeafShadow> pendingShadows = new LinkedHashSet();
    private List<DarkCell> dark;
    private Set<LeafData> changed = new HashSet<LeafData>();

    public LightPropagation(WorldDatabase world) {
        this.world = world;
    }

    protected void propagateLights() {
        while (this.pendingLeafs.size() > 0) {
            Iterator it = this.pendingLeafs.iterator();
            LeafLight ll = (LeafLight)it.next();
            it.remove();
            ll.doPropagation();
            ll.commit();
        }
    }

    protected List<RelightCell> propagateShadows() {
        LinkedList<RelightCell> relight = new LinkedList<RelightCell>();
        while (this.pendingShadows.size() > 0) {
            Iterator it = this.pendingShadows.iterator();
            LeafShadow ll = (LeafShadow)it.next();
            it.remove();
            ll.doPropagation();
            ll.commit();
            relight.addAll(ll.getRelight());
        }
        return relight;
    }

    public void addRelights(List<RelightCell> relight, LightType light) {
        for (RelightCell c : relight) {
            LeafLight ll = this.getLeafLight(c.x, c.y, c.z, light);
            ll.externalEnterLight(c.x, c.y, c.z, -1, c.value);
        }
    }

    public Set<LeafData> changeLighting(LeafData leaf, int x, int y, int z, int old, int type) {
        if (old == type) {
            return Collections.emptySet();
        }
        long start = System.nanoTime();
        int sunlight = leaf.getWorldSunlight(x, y, z);
        int localLight = leaf.getWorldLocalLight(x, y, z);
        int i = x - leaf.getX();
        int j = y - leaf.getY();
        int k = z - leaf.getZ();
        BlockType oldType = BlockTypeIndex.types[old];
        if (LightType.TORCHLIGHT.isBlockType(old)) {
            this.dark = new ArrayList<DarkCell>();
            LeafShadow shade = this.getLeafShadow(leaf, LightType.TORCHLIGHT);
            leaf.setWorldType(x, y, z, 0);
            shade.enterLightRaw(i, j, k, -1, LightType.TORCHLIGHT.getMaximumValue(old));
            List<RelightCell> relight = this.propagateShadows();
            LeafLight leafLight = this.getLeafLight(leaf, LightType.TORCHLIGHT, false);
            for (DarkCell cell : this.dark) {
                leafLight.reflood(cell.x, cell.y, cell.z);
            }
            this.addRelights(relight, LightType.TORCHLIGHT);
            this.dark = null;
            this.propagateLights();
            this.leafLights.clear();
            this.leafShadows.clear();
        } else if (old != 0) {
            leaf.setWorldType(x, y, z, 0);
            LeafLight leafLight = this.getLeafLight(leaf, LightType.SUNLIGHT, false);
            leafLight.reflood(x, y, z);
            this.propagateLights();
            this.leafLights.clear();
            leafLight = this.getLeafLight(leaf, LightType.TORCHLIGHT, false);
            leafLight.reflood(x, y, z);
            this.propagateLights();
            this.leafLights.clear();
            this.leafShadows.clear();
        }
        BlockType newType = BlockTypeIndex.types[type];
        if (LightType.TORCHLIGHT.isBlockType(type)) {
            LeafLight leafLight = this.getLeafLight(leaf, LightType.TORCHLIGHT, false);
            leafLight.enterLightRaw(i, j, k, -1, LightType.TORCHLIGHT.getMaximumValue(type));
            this.propagateLights();
        } else if (type != 0) {
            this.dark = new ArrayList<DarkCell>();
            LeafShadow shadeSun = this.getLeafShadow(leaf, LightType.SUNLIGHT);
            shadeSun.shade(x, y, z);
            List<RelightCell> relight = this.propagateShadows();
            LeafLight leafLight = this.getLeafLight(leaf, LightType.SUNLIGHT, false);
            for (DarkCell cell : this.dark) {
                leafLight.reflood(cell.x, cell.y, cell.z);
            }
            this.addRelights(relight, LightType.TORCHLIGHT);
            leaf.setWorldType(x, y, z, type);
            this.propagateLights();
            this.leafLights.clear();
            this.leafShadows.clear();
            leaf.setWorldType(x, y, z, old);
            this.dark = new ArrayList<DarkCell>();
            LeafShadow shadeTorches = this.getLeafShadow(leaf, LightType.TORCHLIGHT);
            shadeTorches.shade(x, y, z);
            relight = this.propagateShadows();
            shadeTorches.setDark(x, y, z);
            leafLight = this.getLeafLight(leaf, LightType.TORCHLIGHT, false);
            for (DarkCell cell : this.dark) {
                leafLight.reflood(cell.x, cell.y, cell.z);
            }
            this.addRelights(relight, LightType.TORCHLIGHT);
            leaf.setWorldType(x, y, z, type);
            this.propagateLights();
            this.dark = null;
        }
        long end = System.nanoTime();
        this.leafLights.clear();
        this.leafShadows.clear();
        return this.changed;
    }

    public Set<LeafData> refreshLights(LeafData leaf) {
        long start = System.nanoTime();
        if (leaf == null || !leaf.hasCells()) {
            return null;
        }
        this.getLeafLight(leaf, LightType.SUNLIGHT, true);
        this.propagateLights();
        long end = System.nanoTime();
        this.leafLights.clear();
        LeafLight leafLight = this.getLeafLight(leaf, LightType.TORCHLIGHT, true);
        this.initializeLocalLights(leafLight);
        start = System.nanoTime();
        this.propagateLights();
        end = System.nanoTime();
        leaf.getInfo().lit = true;
        return this.changed;
    }

    public Set<LeafData> refreshLights(LeafData[] leafs) {
        long start = System.nanoTime();
        for (int i = leafs.length - 1; i >= 0; --i) {
            LeafLight ll = this.getLeafLight(leafs[i], LightType.SUNLIGHT, true);
            this.propagateLights();
            LeafInfo info = leafs[i].getInfo();
            this.cache.put(this.toKey(info.x, info.y, info.z), leafs[i]);
            leafs[i].getInfo().lit = true;
        }
        long end = System.nanoTime();
        start = System.nanoTime();
        this.leafLights.clear();
        for (int i = leafs.length - 1; i >= 0; --i) {
            LeafLight ll = this.getLeafLight(leafs[i], LightType.TORCHLIGHT, true);
            this.initializeLocalLights(ll);
            this.propagateLights();
        }
        end = System.nanoTime();
        return this.changed;
    }

    protected String toKey(int x, int y, int z) {
        int i = Coordinates.worldToLeaf(x);
        int j = Coordinates.worldToLeaf(y);
        int k = Coordinates.worldToLeaf(z);
        return i + "x" + j + "x" + k;
    }

    protected LeafData getCached(int x, int y, int z) {
        String key = this.toKey(x, y, z);
        return this.cache.get(key);
    }

    protected LeafLight getLeafLight(int x, int y, int z, LightType light) {
        LeafData leaf = this.getCached(x, y, z);
        if (leaf == null) {
            leaf = this.world.getLeaf(x, y, z, false);
        }
        if (leaf == null || !leaf.hasCells()) {
            return null;
        }
        if (!leaf.contains(x, y, z)) {
            System.out.println("!!!!!! What's going on here:" + leaf + "  but we asked for one that could hold:" + x + ", " + y + ", " + z);
        }
        return this.getLeafLight(leaf, light, false);
    }

    protected void initializeColumnLights(LeafData[] leafs, LightType light) {
    }

    protected LeafLight getLeafLight(LeafData leaf, LightType light, boolean clearLights) {
        if (!leaf.hasCells()) {
            return null;
        }
        LeafLight result = this.leafLights.get(leaf);
        if (result == null) {
            result = new LeafLight(leaf);
            result.setLightType(light);
            this.leafLights.put(leaf, result);
            if (clearLights) {
                result.clearLights();
                this.initializeTop(result, this.world, clearLights);
                this.initializeSide(result, this.world, 0, clearLights);
                this.initializeSide(result, this.world, 1, clearLights);
                this.initializeSide(result, this.world, 2, clearLights);
                this.initializeSide(result, this.world, 3, clearLights);
                this.initializeBottom(result, this.world, clearLights);
            }
        }
        this.pendingLeafs.add(result);
        return result;
    }

    protected LeafShadow getLeafShadow(int x, int y, int z, LightType light) {
        LeafData leaf = this.world.getLeaf(x, y, z, false);
        if (leaf == null || !leaf.hasCells()) {
            return null;
        }
        if (!leaf.contains(x, y, z)) {
            System.out.println("!!!!!! What's going on here:" + leaf + "  but we asked for one that could hold:" + x + ", " + y + ", " + z);
        }
        return this.getLeafShadow(leaf, light);
    }

    protected LeafShadow getLeafShadow(LeafData leaf, LightType light) {
        LeafShadow result = this.leafShadows.get(leaf);
        if (result == null) {
            result = new LeafShadow(leaf);
            result.setLightType(light);
            this.leafShadows.put(leaf, result);
        }
        this.pendingShadows.add(result);
        return result;
    }

    protected void initializeLocalLights(LeafLight ll) {
        LightType light = ll.light;
        if (light == LightType.SUNLIGHT) {
            return;
        }
        LeafData leaf = ll.getLeaf();
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                for (int k = 0; k < 32; ++k) {
                    int v = leaf.getTypeUnchecked(i, j, k);
                    if (!light.isBlockType(v)) continue;
                    ll.enterLightRaw(i, j, k, -1, light.getMaximumValue(v));
                }
            }
        }
    }

    protected void initializeTop(LeafLight ll, WorldDatabase world, boolean clearLights) {
        LeafData above = this.findNeighbor(ll.getLeaf().getInfo(), 4, true);
        this.initializeTop(ll, above, clearLights);
    }

    protected void initializeTop(LeafLight ll, LeafData above, boolean clearLights) {
        if (above == null || above.isEmpty()) {
            if (ll.light == LightType.SUNLIGHT && clearLights) {
                int k = 31;
                for (int i = 0; i < 32; ++i) {
                    for (int j = 0; j < 32; ++j) {
                        ll.enterLightRaw(i, j, k, 5, ll.light.getMaximumValue(0));
                    }
                }
            }
        } else if (above.isLit()) {
            int k = 31;
            for (int i = 0; i < 32; ++i) {
                for (int j = 0; j < 32; ++j) {
                    int aboveType;
                    int value = above.getLightUnchecked(ll.lightType, i, j, 0);
                    if (value <= 0 || !ll.canExit(5, aboveType = above.getTypeUnchecked(i, j, 0))) continue;
                    value = ll.light.getNextLightValue(value, 5, aboveType);
                    ll.enterLightRaw(i, j, k, 5, value);
                }
            }
        } else {
            throw new RuntimeException("Not sure how this can happen.  LeafData:" + above);
        }
    }

    protected void initializeSide(LeafLight ll, WorldDatabase world, int dir, boolean clearLights) {
        block8: {
            LeafData neighbor;
            block7: {
                neighbor = this.findNeighbor(ll.getLeaf().getInfo(), dir, false);
                if (neighbor == null || !neighbor.hasCells() || !neighbor.isLit()) {
                    return;
                }
                if (dir != 0 && dir != 1) break block7;
                int j = 31;
                int jNeighbor = 0;
                if (dir == 0) {
                    j = 0;
                    jNeighbor = 31;
                }
                for (int i = 0; i < 32; ++i) {
                    for (int k = 0; k < 32; ++k) {
                        int type;
                        int value = neighbor.getLightUnchecked(ll.lightType, i, jNeighbor, k);
                        if (value <= 0 || !ll.canExit(Direction.INVERSE[dir], type = neighbor.getTypeUnchecked(i, jNeighbor, k))) continue;
                        value = ll.light.getNextLightValue(value, dir, type);
                        ll.enterLightRaw(i, j, k, Direction.INVERSE[dir], value);
                    }
                }
                break block8;
            }
            if (dir != 2 && dir != 3) break block8;
            int i = 31;
            int iNeighbor = 0;
            if (dir == 3) {
                i = 0;
                iNeighbor = 31;
            }
            for (int j = 0; j < 32; ++j) {
                for (int k = 0; k < 32; ++k) {
                    int type;
                    int value = neighbor.getLightUnchecked(ll.lightType, iNeighbor, j, k);
                    if (value <= 0 || !ll.canExit(Direction.INVERSE[dir], type = neighbor.getTypeUnchecked(iNeighbor, j, k))) continue;
                    value = ll.light.getNextLightValue(value, dir, type);
                    ll.enterLightRaw(i, j, k, Direction.INVERSE[dir], value);
                }
            }
        }
    }

    protected void initializeBottom(LeafLight ll, WorldDatabase world, boolean clearLights) {
        LeafData neighbor = this.findNeighbor(ll.getLeaf().getInfo(), 5, false);
        if (neighbor == null || !neighbor.isLit()) {
            return;
        }
        int k = 31;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                int type;
                int value = neighbor.getLightUnchecked(ll.lightType, i, j, k);
                if (ll.light == LightType.SUNLIGHT && value == ll.light.getMaximumValue(0)) {
                    --value;
                }
                if (value <= 0 || !ll.canExit(4, type = neighbor.getTypeUnchecked(i, j, k))) continue;
                value = ll.light.getNextLightValue(value, 4, type);
                ll.enterLightRaw(i, j, 0, 4, value);
            }
        }
    }

    private LeafData findNeighbor(LeafInfo info, int direction, boolean load) {
        int x = info.x;
        int y = info.y;
        int z = info.z;
        LeafData result = this.getCached(x += Direction.DIRS[direction][0] * 32, y += Direction.DIRS[direction][1] * 32, z += Direction.DIRS[direction][2] * 32);
        if (result != null) {
            return result;
        }
        return this.world.getLeaf(x, y, z, load);
    }

    protected static class DarkCell {
        int x;
        int y;
        int z;

        public DarkCell(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    protected static class RelightCell {
        int x;
        int y;
        int z;
        int value;

        public RelightCell(int x, int y, int z, int value) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.value = value;
        }
    }

    protected static class ChangedCell {
        int i;
        int j;
        int k;
        int dir;
        int value;

        public ChangedCell(int i, int j, int k, int dir, int value) {
            this.i = i;
            this.j = j;
            this.k = k;
            this.dir = dir;
            this.value = value;
        }
    }

    protected class LeafShadow {
        private LeafData leaf;
        private LinkedList<ChangedCell> pending = new LinkedList();
        private LinkedList<RelightCell> relight = new LinkedList();
        private LightType light = LightType.SUNLIGHT;
        private int lightType = this.light.getLightIndex();
        private int changeCount = 0;

        public LeafShadow(LeafData leaf) {
            this.leaf = leaf;
        }

        public LinkedList<RelightCell> getRelight() {
            return this.relight;
        }

        public LeafData getLeaf() {
            return this.leaf;
        }

        public void setLightType(LightType type) {
            this.light = type;
            this.lightType = this.light.getLightIndex();
        }

        public final boolean canEnter(int direction, int type) {
            if (type == 0 || direction == -1) {
                return true;
            }
            BlockType blockType = BlockTypeIndex.types[type];
            if (blockType.isTransparent()) {
                return true;
            }
            return !blockType.isSolid(Direction.INVERSE[direction]);
        }

        public final boolean canExit(int direction, int type) {
            if (type == 0 || direction == -1) {
                return true;
            }
            BlockType blockType = BlockTypeIndex.types[type];
            if (blockType.isTransparent()) {
                return true;
            }
            return !blockType.isSolid(direction);
        }

        public void setDark(int x, int y, int z) {
            int i = x - this.leaf.getX();
            int j = y - this.leaf.getY();
            int k = z - this.leaf.getZ();
            this.leaf.setLightUnchecked(this.lightType, i, j, k, 0);
            ++this.changeCount;
            LightPropagation.this.dark.add(new DarkCell(this.leaf.getX() + i, this.leaf.getY() + j, this.leaf.getZ() + k));
        }

        public void shade(int x, int y, int z) {
            int i = x - this.leaf.getX();
            int j = y - this.leaf.getY();
            int k = z - this.leaf.getZ();
            for (int d = 0; d < 6; ++d) {
                int a = Direction.DIRS[d][0];
                int b = Direction.DIRS[d][1];
                int c = Direction.DIRS[d][2];
                int l = LightPropagation.this.world.getLight(this.lightType, x + a, y + b, z + c);
                int v = LightPropagation.this.world.getCellType(x + a, y + b, z + c);
                int nextVal = this.light.getNextLightValue(l, Direction.INVERSE[d], v);
                this.enterLight(i + a, j + b, k + c, Direction.INVERSE[d], nextVal);
            }
        }

        public boolean enterLightRaw(int i, int j, int k, int direction, int value) {
            if (value != this.leaf.getLightUnchecked(this.lightType, i, j, k)) {
                return false;
            }
            int v = this.leaf.getTypeUnchecked(i, j, k);
            if (this.canEnter(direction, v)) {
                if (this.light.isBlockType(v)) {
                    this.relight.add(new RelightCell(this.leaf.getX() + i, this.leaf.getY() + j, this.leaf.getZ() + k, this.light.getMaximumValue(v)));
                }
                this.leaf.setLightUnchecked(this.lightType, i, j, k, 0);
                ++this.changeCount;
                LightPropagation.this.dark.add(new DarkCell(this.leaf.getX() + i, this.leaf.getY() + j, this.leaf.getZ() + k));
                this.pending.add(new ChangedCell(i, j, k, direction, value));
                return true;
            }
            return false;
        }

        public void enterLight(int i, int j, int k, int direction, int value) {
            if ((i += Direction.DIRS[direction][0]) < 0 || (j += Direction.DIRS[direction][1]) < 0 || (k += Direction.DIRS[direction][2]) < 0 || i >= 32 || j >= 32 || k >= 32) {
                int z;
                int y;
                int x = i + this.leaf.getX();
                LeafShadow neighbor = LightPropagation.this.getLeafShadow(x, y = j + this.leaf.getY(), z = k + this.leaf.getZ(), this.light);
                if (neighbor == null) {
                    return;
                }
                neighbor.externalEnterLight(x, y, z, direction, value);
                return;
            }
            this.enterLightRaw(i, j, k, direction, value);
        }

        public void externalEnterLight(int x, int y, int z, int direction, int value) {
            int i = x - this.leaf.getX();
            int j = y - this.leaf.getY();
            int k = z - this.leaf.getZ();
            if (i < 0 || j < 0 || k < 0 || i >= 32 || j >= 32 || k >= 32) {
                throw new RuntimeException("External light entered at bad location:" + i + ", " + j + ", " + k + "  in leaf:" + this.leaf);
            }
            this.enterLightRaw(i, j, k, direction, value);
        }

        public void doPropagation() {
            while (this.pending.size() > 0) {
                ChangedCell cc = this.pending.removeFirst();
                int existing = this.leaf.getLightUnchecked(this.lightType, cc.i, cc.j, cc.k);
                if (existing > cc.value) continue;
                int v = this.leaf.getTypeUnchecked(cc.i, cc.j, cc.k);
                for (int d = 0; d < 6; ++d) {
                    int nextVal;
                    if (Direction.INVERSE[d] == cc.dir || (nextVal = this.light.getNextLightValue(cc.value, d, v)) <= 0 || !this.canExit(d, v)) continue;
                    this.enterLight(cc.i, cc.j, cc.k, d, nextVal);
                }
            }
        }

        public void commit() {
            if (this.changeCount > 0) {
                this.leaf.markChanged();
                LightPropagation.this.changed.add(this.leaf);
            }
        }

        public String toString() {
            return "LeafLight[" + this.leaf + "]";
        }
    }

    protected class LeafLight {
        private LeafData leaf;
        private LinkedList<ChangedCell> pending = new LinkedList();
        private LightType light = LightType.SUNLIGHT;
        private int lightType = this.light.getLightIndex();
        private int changeCount = 0;

        public LeafLight(LeafData leaf) {
            this.leaf = leaf;
        }

        public LeafData getLeaf() {
            return this.leaf;
        }

        public void setLightType(LightType type) {
            this.light = type;
            this.lightType = this.light.getLightIndex();
        }

        public void clearLights() {
            for (int i = 0; i < 32; ++i) {
                for (int j = 0; j < 32; ++j) {
                    for (int k = 0; k < 32; ++k) {
                        this.leaf.setLightUnchecked(this.lightType, i, j, k, 0);
                    }
                }
            }
        }

        public final boolean canEnter(int direction, int type) {
            if (type == 0 || direction == -1) {
                return true;
            }
            BlockType blockType = BlockTypeIndex.types[type];
            if (blockType.isTransparent()) {
                return true;
            }
            return !blockType.isSolid(Direction.INVERSE[direction]);
        }

        public final boolean canExit(int direction, int type) {
            if (type == 0 || direction == -1) {
                return true;
            }
            BlockType blockType = BlockTypeIndex.types[type];
            if (blockType.isTransparent()) {
                return true;
            }
            return !blockType.isSolid(direction);
        }

        public void reflood(int x, int y, int z) {
            for (int d = 0; d < 6; ++d) {
                this.reinitialize(x + Direction.DIRS[d][0], y + Direction.DIRS[d][1], z + Direction.DIRS[d][2]);
            }
        }

        public void reinitialize(int x, int y, int z) {
            int i = x - this.leaf.getX();
            int j = y - this.leaf.getY();
            int k = z - this.leaf.getZ();
            if (i < 0 || j < 0 || k < 0 || i >= 32 || j >= 32 || k >= 32) {
                LeafLight neighbor = LightPropagation.this.getLeafLight(x, y, z, this.light);
                if (neighbor == null) {
                    return;
                }
                neighbor.reinitialize(x, y, z);
                return;
            }
            int existing = this.leaf.getLightUnchecked(this.lightType, i, j, k);
            if (existing == 15 && this.light == LightType.SUNLIGHT) {
                this.pending.add(new ChangedCell(i, j, k, 5, existing));
            } else {
                this.pending.add(new ChangedCell(i, j, k, -1, existing));
            }
        }

        public boolean enterLightRaw(int i, int j, int k, int direction, int value) {
            if (value <= this.leaf.getLightUnchecked(this.lightType, i, j, k)) {
                return false;
            }
            int v = this.leaf.getTypeUnchecked(i, j, k);
            if (this.canEnter(direction, v)) {
                this.leaf.setLightUnchecked(this.lightType, i, j, k, value);
                ++this.changeCount;
                this.pending.add(new ChangedCell(i, j, k, direction, value));
                return true;
            }
            return false;
        }

        public void enterLight(int i, int j, int k, int direction, int value) {
            if ((i += Direction.DIRS[direction][0]) < 0 || (j += Direction.DIRS[direction][1]) < 0 || (k += Direction.DIRS[direction][2]) < 0 || i >= 32 || j >= 32 || k >= 32) {
                int z;
                int y;
                int x = i + this.leaf.getX();
                LeafLight neighbor = LightPropagation.this.getLeafLight(x, y = j + this.leaf.getY(), z = k + this.leaf.getZ(), this.light);
                if (neighbor == null) {
                    return;
                }
                neighbor.externalEnterLight(x, y, z, direction, value);
                return;
            }
            this.enterLightRaw(i, j, k, direction, value);
        }

        public void externalEnterLight(int x, int y, int z, int direction, int value) {
            int i = x - this.leaf.getX();
            int j = y - this.leaf.getY();
            int k = z - this.leaf.getZ();
            if (i < 0 || j < 0 || k < 0 || i >= 32 || j >= 32 || k >= 32) {
                throw new RuntimeException("External light entered at bad location:" + i + ", " + j + ", " + k + "  in leaf:" + this.leaf);
            }
            this.enterLightRaw(i, j, k, direction, value);
        }

        public void doPropagation() {
            while (this.pending.size() > 0) {
                ChangedCell cc = this.pending.removeFirst();
                int existing = this.leaf.getLightUnchecked(this.lightType, cc.i, cc.j, cc.k);
                if (existing > cc.value) continue;
                int v = this.leaf.getTypeUnchecked(cc.i, cc.j, cc.k);
                for (int d = 0; d < 6; ++d) {
                    int nextVal;
                    if (Direction.INVERSE[d] == cc.dir || (nextVal = this.light.getNextLightValue(cc.value, d, v)) <= 0 || !this.canExit(d, v)) continue;
                    this.enterLight(cc.i, cc.j, cc.k, d, nextVal);
                }
            }
        }

        public void commit() {
            if (this.changeCount > 0) {
                this.leaf.markChanged();
                LightPropagation.this.changed.add(this.leaf);
            }
        }

        public String toString() {
            return "LeafLight[" + this.leaf + "]";
        }
    }
}

