/*
 * Decompiled with CFR 0.152.
 */
package mythruna.db;

import mythruna.BlockType;
import mythruna.BlockTypeIndex;
import mythruna.Direction;

public interface LightType {
    public static final LightType SUNLIGHT = new Sunlight();
    public static final LightType TORCHLIGHT = new Torchlight();
    public static final int LIGHT_SUN = 0;
    public static final int LIGHT_LOCAL = 1;

    public boolean isBlockType(int var1);

    public int getLightIndex();

    public int getMaximumValue(int var1);

    public int getNextLightValue(int var1, int var2, int var3);

    public static class Torchlight
    implements LightType {
        @Override
        public final boolean isBlockType(int type) {
            return type == 29 || type == 211 || type == 212 || type == 213 || type == 214;
        }

        @Override
        public final int getLightIndex() {
            return 1;
        }

        @Override
        public final int getMaximumValue(int type) {
            switch (type) {
                case 29: {
                    return 10;
                }
                case 211: {
                    return 7;
                }
                case 212: {
                    return 8;
                }
                case 213: {
                    return 9;
                }
                case 214: {
                    return 4;
                }
            }
            return 10;
        }

        @Override
        public int getNextLightValue(int currentLight, int direction, int blockType) {
            BlockType type;
            int nextVal = currentLight - 1;
            if (blockType != 0 && (type = BlockTypeIndex.types[blockType]).isSolid(direction)) {
                int l = Math.round(type.getTransparency(Direction.DIR_AXIS[direction]) * 15.0f);
                nextVal = Math.min(l, nextVal);
            }
            return nextVal;
        }
    }

    public static class Sunlight
    implements LightType {
        @Override
        public final boolean isBlockType(int type) {
            return false;
        }

        @Override
        public final int getLightIndex() {
            return 0;
        }

        @Override
        public final int getMaximumValue(int type) {
            return 15;
        }

        @Override
        public int getNextLightValue(int currentLight, int direction, int blockType) {
            BlockType type;
            int nextVal = currentLight;
            if (currentLight == 15) {
                if (direction != 5) {
                    nextVal -= 4;
                }
            } else {
                nextVal = direction == 4 ? (currentLight > 10 ? (nextVal -= 4) : (nextVal -= 3)) : --nextVal;
            }
            if (blockType != 0 && (type = BlockTypeIndex.types[blockType]).isSolid(direction)) {
                int l = Math.round(type.getTransparency(Direction.DIR_AXIS[direction]) * 15.0f);
                nextVal = Math.min(l, nextVal);
            }
            return nextVal;
        }
    }
}

