/*
 * Decompiled with CFR 0.152.
 */
package mythruna.db.cave;

import com.jme3.math.LineSegment;
import com.jme3.math.Vector3f;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mythruna.Coordinates;
import mythruna.db.GeneratorColumnFactory;
import mythruna.db.cave.Influencer;
import mythruna.db.cave.LineInfluencer;
import mythruna.db.cave.PointInfluencer;
import mythruna.db.cave.WallInfluencer;

public class CaveGenerator
implements Serializable {
    static final long serialVersionUID = 42L;
    private static final int MARGIN = 12;
    private static final int WIDTH = 1000;
    private static final int HEIGHT = 1000;
    private static final int seaLevel = 57;
    private Random random = new Random();
    private transient List<Influencer> list;
    private Influencer[] caves;
    private float xBase;
    private float yBase;
    private float cavernous;
    private transient GeneratorColumnFactory generator;
    private Map<Long, List<Influencer>> influenceMap = new HashMap<Long, List<Influencer>>();
    private Map<Influencer, List<Long>> idMap = new HashMap<Influencer, List<Long>>();

    public CaveGenerator(long seed, float xBase, float yBase, GeneratorColumnFactory generator) {
        int i;
        long start = System.nanoTime();
        this.generator = generator;
        System.out.println("New cave generator:" + xBase + ", " + yBase + "  seed:" + seed);
        this.xBase = xBase;
        this.yBase = yBase;
        this.random.setSeed(seed);
        int count = this.random.nextInt(4) + 3;
        System.out.println("Total number of cave systems:" + count + "   out of:" + 6);
        this.cavernous = (float)this.random.nextDouble() * 1.0f + 2.0f;
        System.out.println("----------------------------Cavernous:" + this.cavernous);
        this.list = new ArrayList<Influencer>();
        for (int i2 = 0; i2 < count; ++i2) {
            float x = (float)this.random.nextDouble() * 1000.0f + 12.0f;
            float y = (float)this.random.nextDouble() * 1000.0f + 12.0f;
            int elev = generator.calculateElevation((int)(x + xBase), (int)(y + yBase));
            float z = (float)this.random.nextDouble() * (float)(elev + 12);
            System.out.println("Fractal Z:" + elev + "  random z:" + z);
            this.addCaves(new Vector3f(x + xBase, y + yBase, z), null, 12.0, this.list, 0);
        }
        int caveCount = this.list.size();
        ArrayList<Influencer> tempCaves = new ArrayList<Influencer>(this.list);
        int retryCount = 50;
        count = this.random.nextInt(5) + 2;
        for (i = 0; i < count; ++i) {
            float z;
            float y;
            float x;
            double chance = this.random.nextDouble();
            if (chance < 0.4) {
                int index = this.random.nextInt(caveCount);
                Vector3f pos = ((Influencer)tempCaves.get(index)).getCenter();
                System.out.println("Reusing cave position:" + pos + "  from index:" + index);
                x = pos.x;
                y = pos.y;
                int elev = generator.calculateElevation((int)x, (int)y);
                System.out.println("Elevation at:" + x + ", " + y + " = " + elev);
                if (elev < 57 && retryCount-- > 0) {
                    System.out.println("Under water... try again.");
                    --i;
                    continue;
                }
                tempCaves.remove(index);
                --caveCount;
                z = pos.z + (float)(this.random.nextDouble() * 12.0 * 2.0 - 12.0);
            } else {
                x = xBase + (float)this.random.nextDouble() * 1000.0f + 12.0f;
                y = yBase + (float)this.random.nextDouble() * 1000.0f + 12.0f;
                int elev = generator.calculateElevation((int)x, (int)y);
                System.out.println("Elevation at:" + x + ", " + y + " = " + elev);
                if (elev < 57 && retryCount-- > 0) {
                    System.out.println("Under water... try again.");
                    --i;
                    continue;
                }
                z = (float)this.random.nextDouble() * (float)(elev - 16) + 16.0f;
            }
            double chance2 = this.random.nextDouble();
            boolean breachSurface = chance2 < 0.5;
            System.out.println("Force to surface:" + breachSurface);
            this.addGorge(new Vector3f(x, y, z), breachSurface, null, 40.0, this.list, 0);
        }
        retryCount += 20;
        if (this.list.size() < 500) {
            count = this.random.nextInt(3) + 3;
            System.out.println("Total number of secondary cave systems:" + count + "   out of:" + 5);
            for (i = 0; i < count; ++i) {
                float x = (float)this.random.nextDouble() * 1000.0f + 12.0f + xBase;
                float y = (float)this.random.nextDouble() * 1000.0f + 12.0f + yBase;
                int elev = generator.calculateElevation((int)x, (int)y);
                System.out.println("Elevation at:" + x + ", " + y + " = " + elev);
                if (elev < 57 && retryCount-- > 0) {
                    System.out.println("Under water... try again.");
                    --i;
                    continue;
                }
                float z = (float)this.random.nextDouble() * (float)(elev + 12);
                System.out.println("Fractal Z:" + elev + "  random z:" + z);
                this.addCaves(new Vector3f(x, y, z), null, 12.0, this.list, 0);
            }
        }
        long end = System.nanoTime();
        System.out.println("Created CaveGenerators in:" + (double)(end - start) / 1000000.0 + " ms");
    }

    public boolean containsWorldCoordinate(float x, float y) {
        if (x < this.xBase || y < this.yBase) {
            return false;
        }
        return !(x - this.xBase >= 1024.0f) && !(y - this.yBase >= 1024.0f);
    }

    public PointInfluencer addPoint(float x, float y, float z, float radius, float strength) {
        return this.addInfluencer(new PointInfluencer(x, y, z, radius, strength));
    }

    public PointInfluencer addPoint(float x, float y, float radius, float strength) {
        int elev = this.generator.calculateElevation((int)(x + this.xBase), (int)(y + this.yBase));
        return this.addPoint(x, y, elev, radius, strength);
    }

    public PointInfluencer addPoint(float x, float y) {
        return this.addPoint(x, y, 5.0f, 5.0f);
    }

    public PointInfluencer addPoint(float x, float y, float z) {
        return this.addPoint(x, y, z, 5.0f, 5.0f);
    }

    public LineInfluencer addLine(float x1, float y1, float z1, float x2, float y2, float z2) {
        return this.addInfluencer(new LineInfluencer(new Vector3f(x1, y1, z1), new Vector3f(x2, y2, z2), 5.0f, 5.0f));
    }

    public WallInfluencer addWall(float x1, float y1, float z1, float x2, float y2, float z2) {
        return this.addInfluencer(new WallInfluencer(new Vector3f(x1, y1, z1), new Vector3f(x2, y2, z2), 5.0f, 5.0f, 5.0f));
    }

    public <T extends Influencer> T addInfluencer(T in) {
        if (this.list == null) {
            throw new RuntimeException("Cave system has already been compiled.");
        }
        this.list.add(in);
        return in;
    }

    public void compile() {
        long start = System.nanoTime();
        this.spatiallyIndex(this.list);
        this.propagateWater(this.list);
        this.caves = this.list.toArray(new Influencer[this.list.size()]);
        this.list = null;
        System.out.println("total number of influencers:" + this.caves.length);
        long end = System.nanoTime();
        System.out.println("Compiled CaveGenerators in:" + (double)(end - start) / 1000000.0 + " ms");
    }

    public void setGenerator(GeneratorColumnFactory generator) {
        this.generator = generator;
    }

    protected void printReport(String type, PrintWriter out) {
        out.println("CaveGenerator[" + this.xBase + ", " + this.yBase + "] Influence entries:" + this.influenceMap.size() + "  id entries:" + this.idMap.size());
        int infListSize = 0;
        int walls = 0;
        int lines = 0;
        int points = 0;
        for (List<Influencer> l : this.influenceMap.values()) {
            infListSize += l.size();
            for (Influencer i : l) {
                if (i instanceof WallInfluencer) {
                    ++walls;
                    continue;
                }
                if (i instanceof LineInfluencer) {
                    ++lines;
                    continue;
                }
                if (!(i instanceof PointInfluencer)) continue;
                ++points;
            }
        }
        int idListSize = 0;
        for (List<Long> l : this.idMap.values()) {
            idListSize += l.size();
        }
        out.println("   total:" + infListSize + " walls:" + walls + " lines:" + lines + " points:" + points + "  IDs:" + idListSize);
    }

    protected void propagateWater(List<Influencer> list) {
        ArrayList<Influencer> wet = new ArrayList<Influencer>();
        for (Influencer in : list) {
            if (!in.isWet()) continue;
            wet.add(in);
        }
        for (int i = 0; i < wet.size(); ++i) {
            Influencer w = (Influencer)wet.get(i);
            this.propagateWater(w, list, wet);
        }
    }

    protected void propagateWater(Influencer w, List<Influencer> all, List<Influencer> wet) {
        HashSet<Influencer> affected = new HashSet<Influencer>();
        for (Long id : this.getIds(w)) {
            affected.addAll(this.getInfluences(id));
        }
        for (Influencer a : affected) {
            if (a.isWet() || !this.intersects(w, a)) continue;
            a.setWet(true);
            wet.add(a);
        }
    }

    protected boolean intersects(Influencer a, Influencer b) {
        if (a instanceof PointInfluencer) {
            if (b instanceof PointInfluencer) {
                return this.intersectsPointPoint((PointInfluencer)a, (PointInfluencer)b);
            }
            if (b instanceof LineInfluencer) {
                return this.intersectsPointLine((PointInfluencer)a, (LineInfluencer)b);
            }
            if (b instanceof WallInfluencer) {
                return this.intersectsPointWall((PointInfluencer)a, (WallInfluencer)b);
            }
        } else if (a instanceof LineInfluencer) {
            if (b instanceof PointInfluencer) {
                return this.intersectsPointLine((PointInfluencer)b, (LineInfluencer)a);
            }
            if (b instanceof LineInfluencer) {
                return this.intersectsLineLine((LineInfluencer)a, (LineInfluencer)b);
            }
            if (b instanceof WallInfluencer) {
                return this.intersectsLineWall((LineInfluencer)a, (WallInfluencer)b);
            }
        } else if (a instanceof WallInfluencer) {
            if (b instanceof PointInfluencer) {
                return this.intersectsPointWall((PointInfluencer)b, (WallInfluencer)a);
            }
            if (b instanceof LineInfluencer) {
                return this.intersectsLineWall((LineInfluencer)b, (WallInfluencer)a);
            }
            if (b instanceof WallInfluencer) {
                return this.intersectsWallWall((WallInfluencer)a, (WallInfluencer)b);
            }
        }
        return true;
    }

    protected boolean intersectsPointPoint(PointInfluencer a, PointInfluencer b) {
        float z = a.getCenter().z;
        if (z - a.getRadius() > 57.0f) {
            return false;
        }
        z = b.getCenter().z;
        if (z - b.getRadius() > 57.0f) {
            return false;
        }
        float range = a.getRadius() + b.getRadius();
        range *= range;
        Vector3f dir = b.getCenter().subtract(a.getCenter());
        return dir.lengthSquared() <= range;
    }

    protected boolean intersectsPointLine(PointInfluencer a, LineInfluencer b) {
        float z = a.getCenter().z;
        if (z - a.getRadius() > 57.0f) {
            return false;
        }
        float range = a.getRadius() + b.getRadius();
        range *= range;
        float distSq = b.getDistanceSq(a.getCenter());
        return distSq <= range;
    }

    protected boolean intersectsLineLine(LineInfluencer a, LineInfluencer b) {
        int count;
        if (!a.intersects(b)) {
            return false;
        }
        float range = a.getRadius() + b.getRadius();
        range *= range;
        LineInfluencer wet = a.isWet() ? a : b;
        LineInfluencer dry = wet == a ? b : a;
        Vector3f start = dry.getStart();
        Vector3f end = dry.getEnd();
        int xStart = (int)start.x;
        int yStart = (int)start.y;
        int zStart = (int)start.z;
        float xDelta = (int)end.x - xStart;
        float yDelta = (int)end.y - yStart;
        float zDelta = (int)end.z - zStart;
        if (Math.abs(xDelta) > Math.abs(yDelta)) {
            count = (int)Math.abs(xDelta);
            xDelta /= (float)count;
            yDelta /= (float)count;
            zDelta /= (float)count;
        } else {
            count = (int)Math.abs(yDelta);
            xDelta /= (float)count;
            yDelta /= (float)count;
            zDelta /= (float)count;
        }
        Vector3f test = new Vector3f();
        for (int i = 0; i < count; ++i) {
            test.x = (float)xStart + xDelta * (float)i;
            test.y = (float)yStart + yDelta * (float)i;
            test.z = (float)zStart + zDelta * (float)i;
            float ds = wet.getDistanceSq(test);
            float waterRelative = test.z - dry.getRadius() - 57.0f;
            if (!(ds <= range) || !(waterRelative < 0.0f)) continue;
            return true;
        }
        return false;
    }

    protected boolean intersectsPointWall(PointInfluencer a, WallInfluencer b) {
        float z = a.getCenter().z;
        if (z - a.getRadius() > 57.0f) {
            return false;
        }
        float range = a.getRadius() + b.getRadius();
        range *= range;
        float distSq = b.getDistanceSq(a.getCenter());
        return distSq <= range;
    }

    protected boolean intersectsLineWall(LineInfluencer a, WallInfluencer b) {
        int count;
        LineSegment bLine;
        if (a.getMax().z < b.getMin().z) {
            return false;
        }
        if (a.getMin().z > b.getMax().z) {
            return false;
        }
        float range = a.getRadius() + b.getRadius();
        range *= range;
        LineSegment aLine = a.getLine2D();
        float distSq = aLine.distanceSquared(bLine = b.getLine2D());
        if (distSq > range) {
            return false;
        }
        Vector3f start = a.getStart();
        Vector3f end = a.getEnd();
        int xStart = (int)start.x;
        int yStart = (int)start.y;
        int zStart = (int)start.z;
        float xDelta = (int)end.x - xStart;
        float yDelta = (int)end.y - yStart;
        float zDelta = (int)end.z - zStart;
        if (Math.abs(xDelta) > Math.abs(yDelta)) {
            count = (int)Math.abs(xDelta);
            xDelta /= (float)count;
            yDelta /= (float)count;
            zDelta /= (float)count;
        } else {
            count = (int)Math.abs(yDelta);
            xDelta /= (float)count;
            yDelta /= (float)count;
            zDelta /= (float)count;
        }
        Vector3f test = new Vector3f();
        for (int i = 0; i < count; ++i) {
            test.x = (float)xStart + xDelta * (float)i;
            test.y = (float)yStart + yDelta * (float)i;
            test.z = (float)zStart + zDelta * (float)i;
            float ds = b.getDistanceSq(test);
            float waterRelative = test.z - a.getRadius() - 57.0f;
            if (!(ds <= range) || !(waterRelative < 0.0f)) continue;
            return true;
        }
        return false;
    }

    protected boolean intersectsWallWall(WallInfluencer a, WallInfluencer b) {
        LineSegment bLine;
        if (a.getMax().z < b.getMin().z) {
            return false;
        }
        if (a.getMin().z > b.getMax().z) {
            return false;
        }
        float range = a.getRadius() + b.getRadius();
        range *= range;
        LineSegment aLine = a.getLine2D();
        float distSq = aLine.distanceSquared(bLine = b.getLine2D());
        return !(distSq > range);
    }

    public List<Influencer> getInfluences(int xLeaf, int yLeaf) {
        long id = Coordinates.leafToColumnId(xLeaf, yLeaf);
        return this.getInfluences(id);
    }

    protected List<Influencer> getInfluences(long id) {
        List<Influencer> list = this.influenceMap.get(id);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    protected List<Influencer> getList(int xLeaf, int yLeaf) {
        long id = Coordinates.leafToColumnId(xLeaf, yLeaf);
        List<Influencer> list = this.influenceMap.get(id);
        if (list == null) {
            list = new ArrayList<Influencer>();
            this.influenceMap.put(id, list);
        }
        return list;
    }

    protected List<Long> getIds(Influencer in) {
        List<Long> ids = this.idMap.get(in);
        if (ids == null) {
            ids = new ArrayList<Long>();
            this.idMap.put(in, ids);
        }
        return ids;
    }

    protected void spatiallyIndex(Influencer in) {
        Vector3f min = in.getMin();
        int xMin = Coordinates.worldToLeaf(min.x);
        int yMin = Coordinates.worldToLeaf(min.y);
        Vector3f max = in.getMax();
        int xMax = Coordinates.worldToLeaf(max.x);
        int yMax = Coordinates.worldToLeaf(max.y);
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                this.getList(x, y).add(in);
                long id = Coordinates.leafToColumnId(x, y);
                this.getIds(in).add(id);
            }
        }
    }

    protected void spatiallyIndex(List<Influencer> list) {
        for (Influencer i : list) {
            this.spatiallyIndex(i);
        }
    }

    protected boolean isWet(float x, float y, float z, float height, float radius) {
        int elev = this.generator.calculateElevation((int)x, (int)y);
        return elev <= 57 && z + height + radius >= (float)elev && z - radius <= 57.0f;
    }

    protected boolean isWet(Vector3f start, Vector3f end, float height, float radius) {
        int count;
        int xStart = (int)start.x;
        int yStart = (int)start.y;
        int zStart = (int)start.z;
        float xDelta = (int)end.x - xStart;
        float yDelta = (int)end.y - yStart;
        float zDelta = (int)end.z - zStart;
        if (Math.abs(xDelta) > Math.abs(yDelta)) {
            count = (int)Math.abs(xDelta);
            xDelta /= (float)count;
            yDelta /= (float)count;
            zDelta /= (float)count;
        } else {
            count = (int)Math.abs(yDelta);
            xDelta /= (float)count;
            yDelta /= (float)count;
            zDelta /= (float)count;
        }
        for (int i = 0; i < count; ++i) {
            float x = (float)xStart + xDelta * (float)i;
            float y = (float)yStart + yDelta * (float)i;
            float z = (float)zStart + zDelta * (float)i;
            if (!this.isWet(x, y, z, height, radius)) continue;
            return true;
        }
        return false;
    }

    protected void addGorge(Vector3f center, boolean breachSurface, Vector3f last, double lastSize, List<Influencer> list, int depth) {
        float continue2;
        double s;
        double r;
        double chance;
        if (depth > 9) {
            return;
        }
        System.out.println("addGorge(" + center + ", " + (breachSurface ? "ForceSurface" : "RandomElevation") + ") depth:" + depth);
        float height = (float)(this.random.nextDouble() * 24.0) + 16.0f;
        float xDir = (float)this.range(-1.0, 1.0);
        float yDir = (float)this.range(-1.0, 1.0);
        float zDir = (float)this.range(-1.0, 1.0);
        float max = (float)lastSize;
        if (lastSize < 4.0 && (chance = this.random.nextDouble()) < 0.5) {
            max = (float)lastSize * this.cavernous;
        }
        if ((r = this.random.nextDouble() * 2.0 + 2.0) < 2.0) {
            r = 2.0;
        }
        if ((s = r + (this.random.nextDouble() * 10.0 - 5.0)) < r) {
            s = r;
        }
        if (breachSurface) {
            int elev = this.generator.calculateElevation((int)center.x, (int)center.y);
            if (center.z + height < (float)elev) {
                center.z = (float)((double)((float)elev - height) + r);
            } else if (center.z > (float)elev) {
                center.z = elev;
            }
        }
        float lengthFactor1 = max * 0.6f;
        float lengthFactor2 = max * 0.3f;
        float l1 = -((float)(this.random.nextDouble() * (double)lengthFactor1 + (double)lengthFactor2));
        float l2 = (float)(this.random.nextDouble() * (double)lengthFactor1 + (double)lengthFactor2);
        Vector3f start = new Vector3f(center.x + xDir * l1, center.y + yDir * l1, center.z + zDir * l1);
        if ((double)start.z < r) {
            start.z = (float)r;
        }
        Vector3f end = new Vector3f(center.x + xDir * l2, center.y + yDir * l2, center.z + zDir * l2);
        if ((double)end.z < r) {
            end.z = (float)r;
        }
        boolean isWet = this.isWet(start, end, height, (float)r);
        WallInfluencer wall = new WallInfluencer(start, end, height, (float)r, (float)s);
        wall.setWet(isWet);
        list.add(wall);
        float continue1 = (float)this.random.nextDouble() * Math.abs(l1);
        if (continue1 > 2.0f) {
            this.addGorge(start, breachSurface, center, continue1, list, depth + 1);
        }
        if ((continue2 = (float)this.random.nextDouble() * l2) > 2.0f) {
            this.addGorge(end, breachSurface, center, continue1, list, depth + 1);
        }
    }

    protected void addCaves(Vector3f start, Vector3f last, double lastSize, List<Influencer> list, int depth) {
        double s;
        double r;
        double chance;
        if (depth > 9) {
            return;
        }
        System.out.println("addCaves(" + start + ") depth:" + depth);
        double max = lastSize;
        if (lastSize < 5.0 && (chance = this.random.nextDouble()) < 0.5) {
            max = lastSize * (double)this.cavernous;
        }
        if ((r = this.random.nextDouble() * (max - 2.0) + 2.0) < 2.0) {
            r = 2.0;
        }
        if ((s = r + (this.random.nextDouble() * 10.0 - 5.0)) < r) {
            s = r;
        }
        PointInfluencer point = new PointInfluencer(start, (float)r, (float)s);
        list.add(point);
        int elev = this.generator.calculateElevation((int)start.x, (int)start.y);
        boolean isWet = false;
        if (elev <= 57 && (double)start.z + r >= (double)elev && (double)start.z - r <= 57.0) {
            isWet = true;
            point.setWet(true);
        }
        double maxRadius = r;
        int count = 0;
        if (r < 4.0) {
            double chance2 = this.random.nextDouble();
            count = chance2 < 0.5 ? 0 : (chance2 < 0.75 ? 1 : 2);
        } else if (r < 10.0) {
            count = this.random.nextInt(4);
        } else {
            count = this.random.nextInt(8);
            maxRadius = 6.0;
        }
        if (depth < 2 && count == 0) {
            count = 4;
        }
        for (int i = 0; i < count; ++i) {
            double rSub = this.random.nextDouble() * (maxRadius - 2.0) + 2.0;
            double sSub = rSub + (this.random.nextDouble() * 10.0 - 5.0);
            if (sSub < rSub) {
                sSub = rSub;
            }
            double length = this.random.nextDouble() * 40.0;
            Vector3f end = this.randomPosition(start, r + rSub, length, (int)rSub);
            if (end.x - this.xBase < 12.0f || end.x - this.xBase > 1012.0f || end.y - this.yBase < 12.0f || end.y - this.yBase > 1012.0f) continue;
            LineInfluencer line = new LineInfluencer(start, end, (float)rSub, (float)sSub);
            line.setWet(isWet);
            list.add(line);
            this.addCaves(end, start, rSub, list, depth + 1);
        }
    }

    protected double range(double min, double max) {
        double factor = max - min;
        double x = this.random.nextDouble() * factor + min;
        return x;
    }

    protected double nextDelta(double minDistance, double maxDistance) {
        double factor = maxDistance - minDistance;
        double x = this.random.nextDouble() * factor * 2.0 - factor;
        x = x < 0.0 ? (x -= minDistance) : (x += minDistance);
        return x;
    }

    protected Vector3f randomPosition(Vector3f start, double minDistance, double maxDistance, int size) {
        double x = (double)start.x + this.nextDelta(minDistance, maxDistance);
        if (x < (double)(this.xBase + (float)size)) {
            x = size;
        } else if (x > (double)(this.xBase + 1000.0f + 12.0f + (float)size)) {
            x = this.xBase + 1000.0f + 12.0f + (float)size;
        }
        double y = (double)start.y + this.nextDelta(minDistance, maxDistance);
        if (y < (double)(this.yBase + (float)size)) {
            y = size;
        } else if (y > (double)(this.yBase + 1000.0f + 12.0f + (float)size)) {
            y = this.yBase + 1000.0f + 12.0f + (float)size;
        }
        double z = (double)start.z + this.nextDelta(0.0, 20.0);
        if (z < (double)size) {
            z = size;
        }
        return new Vector3f((float)x, (float)y, (float)z);
    }

    public Influencer[] getCaves() {
        return this.caves;
    }
}

