/*
 * Decompiled with CFR 0.152.
 */
package mythruna.db.tree;

import java.util.Random;
import mythruna.BlockType;
import mythruna.BlockTypeIndex;
import mythruna.Direction;
import mythruna.db.GenerationFilter;
import mythruna.db.GeneratorColumnFactory;
import mythruna.db.TreeFactory;
import mythruna.db.tree.MapleTreeFactory;
import mythruna.db.tree.PineTreeFactory;
import mythruna.db.tree.ScrubTreeFactory;
import mythruna.db.tree.SimpleTreeFactory;

public class TreeFilter
implements GenerationFilter {
    private static Random random = new Random(0L);
    private static Random random2 = new Random(0L);
    private static final TreeFactory SIMPLE = new SimpleTreeFactory();
    private static final TreeFactory MAPLE = new MapleTreeFactory();
    private static final TreeFactory SCRUB = new ScrubTreeFactory();
    private static final TreeFactory PINE = new PineTreeFactory();
    private static final TreeFactory SMALL_PINE = new PineTreeFactory(0, 3, 4, 3);
    private static final TreeFactory SCRUB_PINE = new PineTreeFactory(4, 3, 3, 6);
    private static TreeFactory[] treeFactories = new TreeFactory[]{SIMPLE, SIMPLE, SIMPLE, SIMPLE, SIMPLE, SIMPLE, SIMPLE, SIMPLE, MAPLE, MAPLE, MAPLE, MAPLE, SCRUB, SCRUB, SMALL_PINE, SMALL_PINE, SCRUB_PINE};
    private static TreeFactory[] rockyFactories = new TreeFactory[]{SIMPLE, SIMPLE, SCRUB, SCRUB, SCRUB, SCRUB_PINE, SCRUB_PINE, SCRUB_PINE, PINE, PINE, PINE, PINE, PINE, PINE, PINE, PINE, PINE};
    private static TreeFactory[] highFactories = new TreeFactory[]{SIMPLE, SIMPLE, SIMPLE, SIMPLE, SCRUB_PINE, PINE, PINE, PINE, PINE, PINE, MAPLE, MAPLE, SCRUB, SCRUB, PINE, PINE, PINE};

    @Override
    public void setSeed(long seed) {
    }

    @Override
    public void setGenerator(GeneratorColumnFactory generator) {
    }

    @Override
    public void filter(int xLeaf, int yLeaf, int[][][] cells, int[][] elevations, int[][] types, long seed, int xOffset, int yOffset, int seaLevel) {
        BlockType trunk = BlockTypeIndex.types[9];
        BlockType branches = BlockTypeIndex.types[10];
        random.setSeed(seed);
        random2.setSeed(seed);
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                boolean hasGrass;
                if (types[xOffset + i][yOffset + j] != 2 && types[xOffset + i][yOffset + j] != 82) continue;
                int h = elevations[xOffset + i][yOffset + j];
                boolean canHaveTree = true;
                if (i < 2 || j < 2 || i >= 30 || j >= 30) {
                    canHaveTree = false;
                }
                boolean bl = hasGrass = types[xOffset + i][yOffset + j] == 82;
                if (canHaveTree) {
                    TreeFactory tree;
                    boolean rocky = false;
                    for (int d = 0; d < 4; ++d) {
                        int ni = i + Direction.DIRS[d][0];
                        int nj = j + Direction.DIRS[d][1];
                        if (types[xOffset + ni][yOffset + nj] != 4) continue;
                        rocky = true;
                        break;
                    }
                    int chance = (int)(random.nextDouble() * 500.0);
                    if (rocky) {
                        TreeFactory tree2;
                        if (chance < rockyFactories.length && (tree2 = rockyFactories[chance]) != null) {
                            tree2.addTree(i, j, h, cells, random);
                            hasGrass = false;
                        }
                    } else if (h > 96) {
                        TreeFactory tree3;
                        if (chance < highFactories.length && (tree3 = highFactories[chance]) != null) {
                            tree3.addTree(i, j, h, cells, random);
                            hasGrass = false;
                        }
                    } else if (chance < treeFactories.length && (tree = treeFactories[chance]) != null) {
                        tree.addTree(i, j, h, cells, random);
                        hasGrass = false;
                    }
                }
                if (!hasGrass) continue;
                double rand = random2.nextDouble() * 100.0;
                if (rand < 2.0) {
                    cells[i][j][h] = 237;
                    continue;
                }
                if (rand < 30.0) {
                    cells[i][j][h] = 82;
                    continue;
                }
                if (rand < 40.0) {
                    cells[i][j][h] = 83;
                    continue;
                }
                if (rand < 50.0) {
                    cells[i][j][h] = 84;
                    continue;
                }
                if (rand < 52.0) {
                    cells[i][j][h] = 232;
                    continue;
                }
                if (rand < 53.0) {
                    cells[i][j][h] = 233;
                    continue;
                }
                if (rand < 54.0) {
                    cells[i][j][h] = 234;
                    continue;
                }
                if (rand < 55.0) {
                    cells[i][j][h] = 235;
                    continue;
                }
                if (!(rand < 56.0)) continue;
                cells[i][j][h] = 236;
            }
        }
    }
}

