/*
 * Decompiled with CFR 0.152.
 */
package mythruna.db.user;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import mythruna.PlayerData;
import mythruna.db.user.DefaultPlayer;
import mythruna.db.user.UserDatabase;
import org.progeeks.json.JsonParseException;
import org.progeeks.json.JsonParser;
import org.progeeks.json.JsonPrinter;
import org.progeeks.util.TemplateExpressionProcessor;

public class DefaultUserDatabase
implements UserDatabase {
    public static final int DB_VERSION = 1;
    public static final String SETTINGS_FILE = "userDb.settings.json";
    private File base;
    private Map settings;
    private Map<String, Integer> userIds = new ConcurrentHashMap<String, Integer>();
    private TemplateExpressionProcessor exp = TemplateExpressionProcessor.getDefaultProcessor();
    private JsonParser jsonParser = new JsonParser();
    private JsonPrinter jsonPrinter = new JsonPrinter();
    private AtomicInteger nextUserId = new AtomicInteger();

    public DefaultUserDatabase(File base) {
        this.base = base;
        if (!base.exists() && !base.mkdirs()) {
            throw new RuntimeException("Could not create directory:" + base);
        }
        this.loadSettings();
    }

    @Override
    public Set<String> getUserIds() {
        return Collections.unmodifiableSet(this.userIds.keySet());
    }

    protected File getFile(String name) {
        File f = new File(this.base, name);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object loadJson(String file) throws IOException {
        File f = this.getFile(file);
        if (!f.exists()) {
            return null;
        }
        FileReader in = new FileReader(f);
        try {
            Object object = this.jsonParser.parse((Reader)in);
            return object;
        }
        finally {
            in.close();
        }
    }

    protected void loadSettings() {
        try {
            this.settings = (Map)this.loadJson(SETTINGS_FILE);
            if (this.settings == null) {
                this.settings = new HashMap();
                this.settings.put("nextUserId", 0);
                this.settings.put("userIds", new HashMap());
                this.settings.put("version", 1);
            }
            this.nextUserId.set((Integer)this.settings.get("nextUserId"));
            this.userIds.putAll((Map)this.settings.get("userIds"));
            this.settings.put("userIds", this.userIds);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading settings", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeJson(String file, Object o) throws IOException {
        File f = this.getFile(file);
        FileWriter out = new FileWriter(f);
        try {
            this.jsonPrinter.write(o, (Writer)out);
        }
        finally {
            out.close();
        }
    }

    protected void saveSettings() {
        try {
            this.writeJson(SETTINGS_FILE, this.settings);
        }
        catch (IOException e) {
            throw new RuntimeException("Error saving settings", e);
        }
    }

    protected String toUserFile(int id) {
        return id + ".user.json";
    }

    protected void saveUser(Map user) {
        int id = (Integer)user.get("id");
        try {
            this.writeJson(this.toUserFile(id), user);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing user, id:" + id, e);
        }
    }

    @Override
    public PlayerData createUser(String userId, String password) {
        if (this.userIds.containsKey(userId)) {
            return null;
        }
        int id = this.nextUserId.getAndIncrement();
        this.settings.put("nextUserId", this.nextUserId.get());
        this.userIds.put(userId, id);
        DefaultPlayer player = new DefaultPlayer(this, new HashMap());
        player.set("id", id);
        player.set("dbVersion", 1);
        player.set("createTime", System.currentTimeMillis());
        player.set("userInfo.userId", userId);
        player.set("userInfo.password", password);
        player.save();
        this.saveSettings();
        return player;
    }

    protected PlayerData loadPlayer(int id) {
        try {
            Map values = (Map)this.loadJson(this.toUserFile(id));
            return new DefaultPlayer(this, values);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading user, id:" + id, e);
        }
    }

    @Override
    public PlayerData getUser(String userId) {
        if (!this.userIds.containsKey(userId)) {
            return null;
        }
        int id = this.userIds.get(userId);
        try {
            Map values = (Map)this.loadJson(this.toUserFile(id));
            return new DefaultPlayer(this, values);
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Error loading user, userId:" + userId + ", id:" + id, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading user, userId:" + userId + ", id:" + id, e);
        }
    }

    @Override
    public PlayerData findUser(String property, Object value) {
        String v = String.valueOf(value);
        for (Integer id : this.userIds.values()) {
            PlayerData p = this.loadPlayer(id);
            String t = String.valueOf(p.get(property));
            if (!v.equals(t)) continue;
            return p;
        }
        return null;
    }

    public static void main(String ... args) throws IOException {
        long start = System.nanoTime();
        DefaultUserDatabase test = new DefaultUserDatabase(new File("user.db.test"));
        long end = System.nanoTime();
        System.out.println("DB initialized in " + (end - start) / 1000000L + " ms.");
        PlayerData player = test.createUser(args[0], args[1]);
        if (player == null) {
            System.out.println("looking up existing player...");
            player = test.getUser(args[0]);
        }
        System.out.println("user:" + player);
    }
}

