/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mythruna.es.ChangeQueue;
import mythruna.es.ComponentFilter;
import mythruna.es.DefaultEntity;
import mythruna.es.Entity;
import mythruna.es.EntityChange;
import mythruna.es.EntityComponent;
import mythruna.es.EntityComponentListener;
import mythruna.es.EntityId;
import mythruna.es.EntityProcessor;
import mythruna.es.EntityProcessorRunnable;
import mythruna.es.EntitySet;
import mythruna.es.ObservableEntityData;
import mythruna.util.NamedThreadFactory;
import mythruna.util.ReportSystem;
import mythruna.util.Reporter;

public abstract class AbstractEntityData
implements ObservableEntityData {
    private List<EntitySet> entitySets = new CopyOnWriteArrayList<EntitySet>();
    private List<EntityComponentListener> entityListeners = new CopyOnWriteArrayList<EntityComponentListener>();
    private ExecutorService executor;

    protected AbstractEntityData() {
        DefaultEntity.ed = this;
        this.executor = Executors.newFixedThreadPool(4, new NamedThreadFactory("EntityProc", false));
        ReportSystem.registerCacheReporter(new MemReporter());
    }

    @Override
    public void addEntityComponentListener(EntityComponentListener l) {
        this.entityListeners.add(l);
    }

    @Override
    public void removeEntityComponentListener(EntityComponentListener l) {
        this.entityListeners.remove(l);
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    @Override
    public void execute(EntityProcessor proc) {
        this.executor.submit(new EntityProcessorRunnable(proc, this));
    }

    protected EntitySet createSet(ComponentFilter filter, Class ... types) {
        EntitySet set = new EntitySet(this, filter, types);
        this.entitySets.add(set);
        return set;
    }

    protected void replace(Entity e, EntityComponent oldValue, EntityComponent newValue) {
        this.setComponent(e.getId(), newValue);
    }

    @Override
    public void setComponents(EntityId entityId, EntityComponent ... components) {
        for (EntityComponent c : components) {
            this.setComponent(entityId, c);
        }
    }

    @Override
    public Entity getEntity(EntityId entityId, Class ... types) {
        EntityComponent[] values = new EntityComponent[types.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.getComponent(entityId, types[i]);
        }
        return new DefaultEntity(entityId, values, types);
    }

    protected abstract Set<EntityId> getEntityIds(Class var1, ComponentFilter var2);

    protected abstract Set<EntityId> getEntityIds(Class var1);

    @Override
    public EntitySet getEntities(Class ... types) {
        EntitySet results = this.createSet(null, types);
        Set<EntityId> first = this.getEntityIds(types[0]);
        if (first.isEmpty()) {
            return results;
        }
        HashSet<EntityId> and = new HashSet<EntityId>();
        and.addAll(first);
        for (int i = 1; i < types.length; ++i) {
            and.retainAll(this.getEntityIds(types[i]));
        }
        EntityComponent[] buffer = new EntityComponent[types.length];
        for (EntityId id : and) {
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = this.getComponent(id, types[i]);
            }
            DefaultEntity e = new DefaultEntity(id, (EntityComponent[])buffer.clone(), types);
            results.add(e);
        }
        return results;
    }

    protected ComponentFilter forType(ComponentFilter filter, Class type) {
        if (filter == null || filter.getComponentType() != type) {
            return null;
        }
        return filter;
    }

    protected abstract EntityId findSingleEntity(ComponentFilter var1);

    @Override
    public EntityId findEntity(ComponentFilter filter, Class ... types) {
        if (types == null || types.length == 0) {
            return this.findSingleEntity(filter);
        }
        Set<EntityId> first = this.getEntityIds(types[0], this.forType(filter, types[0]));
        if (first.isEmpty()) {
            return null;
        }
        HashSet<EntityId> and = new HashSet<EntityId>();
        and.addAll(first);
        for (int i = 1; i < types.length; ++i) {
            Set<EntityId> sub = this.getEntityIds(types[i], this.forType(filter, types[i]));
            if (sub.isEmpty()) {
                return null;
            }
            and.retainAll(sub);
        }
        if (and.isEmpty()) {
            return null;
        }
        return (EntityId)and.iterator().next();
    }

    @Override
    public Set<EntityId> findEntities(ComponentFilter filter, Class ... types) {
        Set<EntityId> first;
        if (types == null || types.length == 0) {
            types = new Class[]{filter.getComponentType()};
        }
        if ((first = this.getEntityIds(types[0], this.forType(filter, types[0]))).isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<EntityId> and = new HashSet<EntityId>();
        and.addAll(first);
        for (int i = 1; i < types.length; ++i) {
            Set<EntityId> sub = this.getEntityIds(types[i], this.forType(filter, types[i]));
            if (sub.isEmpty()) {
                return Collections.emptySet();
            }
            and.retainAll(sub);
        }
        return and;
    }

    @Override
    public EntitySet getEntities(ComponentFilter filter, Class ... types) {
        EntitySet results = this.createSet(filter, types);
        results.loadEntities(false);
        return results;
    }

    @Override
    public void releaseEntitySet(EntitySet entities) {
        this.entitySets.remove(entities);
    }

    @Override
    public ChangeQueue getChangeQueue(Class ... componentTypes) {
        ChangeQueue queue = new ChangeQueue(this, componentTypes);
        this.addEntityComponentListener(queue.getListener());
        return queue;
    }

    @Override
    public void releaseChangeQueue(ChangeQueue queue) {
        this.removeEntityComponentListener(queue.getListener());
    }

    protected void entityChange(EntityChange change) {
        for (EntityComponentListener l : this.entityListeners) {
            l.componentChange(change);
        }
        for (EntitySet set : this.entitySets) {
            set.entityChange(change);
        }
    }

    private class MemReporter
    implements Reporter {
        private MemReporter() {
        }

        @Override
        public void printReport(String type, PrintWriter out) {
            out.println("EntityData->EntitySets:" + AbstractEntityData.this.entitySets.size());
        }
    }
}

