/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import mythruna.es.sql.SqlSession;

public class EntityIdGenerator {
    private String tableName = "ENTITY_ID";
    private long entityId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityIdGenerator(SqlSession session) throws SQLException {
        DatabaseMetaData md = session.getConnection().getMetaData();
        ResultSet rs = md.getColumns(null, "PUBLIC", this.tableName, null);
        try {
            if (rs.next()) {
                this.loadId(session);
                return;
            }
        }
        finally {
            rs.close();
        }
        StringBuilder sb = new StringBuilder("CREATE");
        sb.append(" CACHED TABLE");
        sb.append(" " + this.tableName + "\n");
        sb.append("(\n");
        sb.append("  id TINYINT,\n");
        sb.append("  entityId BIGINT");
        sb.append("\n)");
        Statement st = session.getConnection().createStatement();
        st.executeUpdate(sb.toString());
        String sql = "INSERT INTO " + this.tableName + "(id,entityId) VALUES (0,0)";
        int i = st.executeUpdate(sql);
        if (i != 1) {
            throw new SQLException("Error initializing sequence table:" + sb);
        }
        st.close();
    }

    public static EntityIdGenerator create(SqlSession session) throws SQLException {
        return new EntityIdGenerator(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadId(SqlSession session) throws SQLException {
        Statement st = session.getConnection().createStatement();
        try {
            ResultSet rs = st.executeQuery("SELECT entityId from " + this.tableName + " where id=0");
            if (rs.next()) {
                this.entityId = rs.getLong(1);
            }
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long nextEntityId(SqlSession session) throws SQLException {
        long result = this.entityId++;
        Statement st = session.getConnection().createStatement();
        try {
            String sql = "UPDATE " + this.tableName + " SET entityId=" + this.entityId + " WHERE id=0";
            int update = st.executeUpdate(sql);
            if (update != 1) {
                throw new SQLException("EntityID sequence not updated.");
            }
            long l = result;
            return l;
        }
        finally {
            st.close();
        }
    }
}

