/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es.sql;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import mythruna.es.ComponentFilter;
import mythruna.es.EntityComponent;
import mythruna.es.EntityId;
import mythruna.es.sql.ComponentHandler;

public class MapComponentHandler<T extends EntityComponent>
implements ComponentHandler<T> {
    private Map<EntityId, T> components = new ConcurrentHashMap<EntityId, T>();

    @Override
    public void setComponent(EntityId entityId, T component) {
        this.components.put(entityId, component);
    }

    @Override
    public boolean removeComponent(EntityId entityId) {
        return this.components.remove(entityId) != null;
    }

    @Override
    public T getComponent(EntityId entityId) {
        return (T)((EntityComponent)this.components.get(entityId));
    }

    @Override
    public Set<EntityId> getEntities() {
        return this.components.keySet();
    }

    @Override
    public Set<EntityId> getEntities(ComponentFilter filter) {
        if (filter == null) {
            return this.components.keySet();
        }
        HashSet<EntityId> results = new HashSet<EntityId>();
        for (Map.Entry<EntityId, T> e : this.components.entrySet()) {
            if (!filter.evaluate((EntityComponent)e.getValue())) continue;
            results.add(e.getKey());
        }
        return results;
    }

    @Override
    public EntityId findEntity(ComponentFilter filter) {
        for (Map.Entry<EntityId, T> e : this.components.entrySet()) {
            if (filter != null && !filter.evaluate((EntityComponent)e.getValue())) continue;
            return e.getKey();
        }
        return null;
    }
}

