/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es.sql;

import java.sql.SQLException;
import mythruna.es.StringIndex;
import mythruna.es.sql.SqlEntityData;
import mythruna.es.sql.SqlSession;
import mythruna.es.sql.StringTable;
import mythruna.util.LruCache;

public class SqlStringIndex
implements StringIndex {
    private SqlEntityData parent;
    private StringTable stringTable;
    private int cacheSize;
    private LruCache<Integer, String> idToString;
    private LruCache<String, Integer> stringToId;

    public SqlStringIndex(SqlEntityData parent, int cacheSize) {
        this.parent = parent;
        this.cacheSize = cacheSize;
        this.idToString = new LruCache("idToString", 100);
        this.stringToId = new LruCache("stringToId", 100);
        try {
            this.stringTable = StringTable.create(parent.getSession());
            int test = this.getStringId("testing", true);
            System.out.println("Test string id:" + test);
            System.out.println("Reciprocal test lookup:" + this.getString(test));
        }
        catch (SQLException e) {
            throw new RuntimeException("Error creating string table", e);
        }
    }

    protected SqlSession getSession() throws SQLException {
        return this.parent.getSession();
    }

    protected int lookupId(String s) {
        try {
            return this.stringTable.getStringId(this.getSession(), s, false);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error getting string ID for:" + s, e);
        }
    }

    @Override
    public int getStringId(String s, boolean add) {
        Integer result = this.stringToId.get(s);
        if (result != null) {
            return result;
        }
        int i = this.lookupId(s);
        if (i < 0 && add) {
            SqlStringIndex sqlStringIndex = this;
            synchronized (sqlStringIndex) {
                result = this.stringToId.get(s);
                if (result != null) {
                    return result;
                }
                try {
                    i = this.stringTable.getStringId(this.getSession(), s, add);
                    if (i < 0) {
                        return -1;
                    }
                    this.stringToId.put(s, i);
                    this.idToString.put(i, s);
                    return i;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Error getting string ID for:" + s, e);
                }
            }
        }
        if (i < 0) {
            return -1;
        }
        this.stringToId.put(s, i);
        this.idToString.put(i, s);
        return i;
    }

    @Override
    public String getString(int id) {
        String result = this.idToString.get(id);
        if (result != null) {
            return result;
        }
        try {
            result = this.stringTable.getString(this.getSession(), id);
            if (result != null) {
                this.idToString.put(id, result);
                this.stringToId.put(result, id);
            }
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error getting string for ID:" + id, e);
        }
    }
}

