/*
 * Decompiled with CFR 0.152.
 */
package mythruna.geom;

import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import mythruna.BlockType;
import mythruna.BoundaryShape;
import mythruna.Direction;
import mythruna.ShapeIndex;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPart;
import mythruna.geom.GeomPartBuffer;

public class ConeFactory
implements GeomFactory {
    private static float[][] RADIALS = new float[][]{ConeFactory.cosAndSin(0.0f), ConeFactory.cosAndSin(0.7853982f), ConeFactory.cosAndSin(1.5707964f), ConeFactory.cosAndSin(2.3561945f), ConeFactory.cosAndSin((float)Math.PI), ConeFactory.cosAndSin(3.926991f), ConeFactory.cosAndSin(4.712389f), ConeFactory.cosAndSin(5.4977875f), ConeFactory.cosAndSin(0.0f)};
    private static float[][] HALF_RADIALS = new float[][]{ConeFactory.cosAndSin(0.3926991f), ConeFactory.cosAndSin(1.1780972f), ConeFactory.cosAndSin(1.9634955f), ConeFactory.cosAndSin(2.7488937f), ConeFactory.cosAndSin(3.5342917f), ConeFactory.cosAndSin(4.31969f), ConeFactory.cosAndSin(5.105088f), ConeFactory.cosAndSin(5.8904862f), ConeFactory.cosAndSin(6.6758847f)};
    private static float[] texCoord = new float[]{0.0f, 0.5f, 1.0f, 1.5f, 2.0f, 2.5f, 3.0f, 3.5f, 4.0f};
    private int coneMaterialType;
    private int flatMaterialType;
    private int direction;
    private int flatDirection;
    private float height;
    private float radius;
    private boolean generateTangents = true;
    private float textureScale = 1.0f;
    private TextureType mapping = TextureType.RADIAL;
    private BoundaryShape circle;
    private Vector3f slope;

    public ConeFactory(int coneMaterialType, int flatMaterialType, int direction, float height, float radius) {
        this(coneMaterialType, flatMaterialType, direction, height, radius, radius / 0.5f, true, TextureType.RADIAL);
    }

    public ConeFactory(int coneMaterialType, int flatMaterialType, int direction, float height, float radius, float textureScale, boolean generateTangents, TextureType mapping) {
        this.coneMaterialType = coneMaterialType;
        this.flatMaterialType = flatMaterialType;
        this.direction = direction;
        this.height = height;
        this.radius = radius;
        this.textureScale = textureScale;
        this.generateTangents = generateTangents;
        this.mapping = mapping;
        this.circle = ShapeIndex.getCircle(0.5f, 0.5f, radius);
        this.flatDirection = Direction.INVERSE[direction];
        this.slope = new Vector3f(radius, 0.15f, 0.0f).normalizeLocal();
    }

    public static float[] cosAndSin(float angle) {
        return new float[]{FastMath.cos((float)(-angle)), FastMath.sin((float)(-angle))};
    }

    @Override
    public boolean isSameShape(GeomFactory f) {
        if (f == this) {
            return true;
        }
        if (f == null || f.getClass() != this.getClass()) {
            return false;
        }
        ConeFactory other = (ConeFactory)f;
        if (other.direction != this.direction) {
            return false;
        }
        if (other.height != this.height) {
            return false;
        }
        return other.radius == this.radius;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getHeight() {
        return this.height;
    }

    public int getDirection() {
        return this.direction;
    }

    @Override
    public int createGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block, int dir) {
        if (dir != this.flatDirection) {
            return 0;
        }
        float xCenter = (float)x + 0.5f;
        float zCenter = (float)y + 0.5f;
        float ySurface = z;
        float normalDir = -1.0f;
        if (dir == 4) {
            ySurface = z + 1;
            normalDir = 1.0f;
        }
        GeomPart part = new GeomPart(this.flatMaterialType, dir);
        part.setSun(sun);
        part.setLight(light);
        if (this.mapping != TextureType.RADIAL) {
            float[] coords = new float[24];
            float[] normals = new float[24];
            float[] tangents = new float[24];
            for (int i = 0; i < 8; ++i) {
                int v = i * 3;
                float[] radial = RADIALS[i];
                coords[v] = xCenter + radial[0] * this.radius;
                coords[v + 1] = ySurface;
                coords[v + 2] = zCenter + radial[1] * this.radius;
                normals[v] = 0.0f;
                normals[v + 1] = normalDir;
                normals[v + 2] = 0.0f;
                tangents[v] = normalDir;
                tangents[v + 1] = 0.0f;
                tangents[v + 2] = 0.0f;
            }
            part.setCoords(coords);
            part.setNormals(normals);
            part.setTangents(tangents);
            if (this.mapping == TextureType.DECAL_STRETCHED) {
                part.setTexCoords(1.0f, 0.5f, 1.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.5f, 0.0f, 1.0f, 0.0f);
            } else {
                float[] tc = new float[16];
                int index = 0;
                for (int i = 0; i < 8; ++i) {
                    tc[index++] = 0.5f + RADIALS[i][0] * 0.5f;
                    tc[index++] = 0.5f + RADIALS[i][1] * 0.5f;
                }
                part.setTexCoords(tc);
            }
            if (dir == 4) {
                part.setIndexes(1, 2, 3, 0, 1, 3, 0, 3, 4, 0, 4, 7, 7, 4, 5, 7, 5, 6);
            } else {
                part.setIndexes(1, 3, 2, 0, 3, 1, 0, 4, 3, 0, 7, 4, 7, 5, 4, 7, 6, 5);
            }
            buffer.add(part);
            return 1;
        }
        float[] coords = new float[30];
        float[] normals = new float[30];
        float[] tangents = new float[30];
        for (int i = 0; i < 9; ++i) {
            int v = i * 3;
            float[] radial = RADIALS[i];
            coords[v] = xCenter + radial[0] * this.radius;
            coords[v + 1] = ySurface;
            coords[v + 2] = zCenter + radial[1] * this.radius;
            normals[v] = 0.0f;
            normals[v + 1] = normalDir;
            normals[v + 2] = 0.0f;
            tangents[v] = normalDir;
            tangents[v + 1] = 0.0f;
            tangents[v + 2] = 0.0f;
        }
        int v = 27;
        coords[v] = xCenter;
        coords[v + 1] = ySurface;
        coords[v + 2] = zCenter;
        normals[v] = 0.0f;
        normals[v + 1] = normalDir;
        normals[v + 2] = 0.0f;
        tangents[v] = normalDir;
        tangents[v + 1] = 0.0f;
        tangents[v + 2] = 0.0f;
        part.setCoords(coords);
        part.setNormals(normals);
        part.setTangents(tangents);
        part.setTexCoords(1.0f, 0.5f, 1.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f, 0.5f, 0.5f, 0.5f);
        if (dir == 4) {
            part.setIndexes(0, 1, 9, 1, 2, 9, 2, 3, 9, 3, 4, 9, 4, 5, 9, 5, 6, 9, 6, 7, 9, 7, 8, 9);
        } else {
            part.setIndexes(0, 9, 1, 1, 9, 2, 2, 9, 3, 3, 9, 4, 4, 9, 5, 5, 9, 6, 6, 9, 7, 7, 9, 8);
        }
        buffer.add(part);
        return 1;
    }

    @Override
    public int createInternalGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        return this.createInternalGeometry1(buffer, x, y, z, xWorld, yWorld, zWorld, sun, light, block);
    }

    public int createInternalGeometry1(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        float xCenter = (float)x + 0.5f;
        float zCenter = (float)y + 0.5f;
        float yBase = z;
        float yTop = (float)z + this.height;
        float[] coords = new float[RADIALS.length * 3 * 2];
        float[] normals = new float[RADIALS.length * 3 * 2];
        float[] tangents = new float[RADIALS.length * 3 * 2];
        float[] texCoords = new float[RADIALS.length * 2 * 2];
        short[] indexes = new short[(RADIALS.length - 1) * 3 * 2];
        float bottomRadius = this.radius;
        float topRadius = 0.0f;
        float normalDir = this.slope.y;
        float topTex = 1.0f;
        float bottomTex = 0.0f;
        if (this.flatDirection == 4) {
            bottomRadius = 0.0f;
            topRadius = this.radius;
            normalDir = this.slope.y * -1.0f;
            topTex = 0.0f;
            bottomTex = 1.0f;
            yBase = (float)(z + 1) - this.height;
            yTop = z + 1;
        }
        int vIndex = 0;
        int tIndex = 0;
        int iIndex = 0;
        for (int i = 0; i < RADIALS.length; ++i) {
            float[] radial = i < RADIALS.length ? RADIALS[i] : RADIALS[0];
            float s = texCoord[i];
            coords[vIndex] = xCenter + radial[0] * bottomRadius;
            coords[vIndex + 1] = yBase;
            coords[vIndex + 2] = zCenter + radial[1] * bottomRadius;
            normals[vIndex] = radial[0] * this.slope.x;
            normals[vIndex + 1] = normalDir;
            normals[vIndex + 2] = radial[1] * this.slope.x;
            tangents[vIndex] = radial[1];
            tangents[vIndex + 1] = 0.0f;
            tangents[vIndex + 2] = -radial[0];
            texCoords[tIndex] = s * this.textureScale;
            texCoords[tIndex + 1] = bottomTex;
            tIndex += 2;
            coords[vIndex += 3] = xCenter + radial[0] * topRadius;
            coords[vIndex + 1] = yTop;
            coords[vIndex + 2] = zCenter + radial[1] * topRadius;
            normals[vIndex] = radial[0] * this.slope.x;
            normals[vIndex + 1] = normalDir;
            normals[vIndex + 2] = radial[1] * this.slope.x;
            tangents[vIndex] = radial[1];
            tangents[vIndex + 1] = 0.0f;
            tangents[vIndex + 2] = -radial[0];
            texCoords[tIndex] = s * this.textureScale;
            texCoords[tIndex + 1] = topTex;
            vIndex += 3;
            tIndex += 2;
            if (i >= RADIALS.length - 1) continue;
            int baseVertex = i * 2;
            indexes[iIndex++] = (short)baseVertex;
            indexes[iIndex++] = (short)(baseVertex + 2);
            indexes[iIndex++] = (short)(baseVertex + 3);
            indexes[iIndex++] = (short)baseVertex;
            indexes[iIndex++] = (short)(baseVertex + 3);
            indexes[iIndex++] = (short)(baseVertex + 1);
        }
        GeomPart part = new GeomPart(this.coneMaterialType, 4);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(coords);
        part.setNormals(normals);
        part.setTangents(tangents);
        part.setTexCoords(texCoords);
        part.setIndexes(indexes);
        buffer.add(part);
        return 0;
    }

    public int createInternalGeometry2(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        float[] radial;
        int v;
        int i;
        float xCenter = (float)x + 0.5f;
        float zCenter = (float)y + 0.5f;
        float ySurface = z;
        float yPoint = z + 1;
        float normalDir = this.slope.y;
        if (this.flatDirection == 4) {
            yPoint = z;
            ySurface = z + 1;
            normalDir = this.slope.y * -1.0f;
        }
        GeomPart part = new GeomPart(this.flatMaterialType, this.direction);
        part.setSun(sun);
        part.setLight(light);
        float[] coords = new float[51];
        float[] normals = new float[51];
        float[] tangents = new float[51];
        for (i = 0; i < 9; ++i) {
            v = i * 3;
            radial = RADIALS[i];
            coords[v] = xCenter + radial[0] * this.radius;
            coords[v + 1] = ySurface;
            coords[v + 2] = zCenter + radial[1] * this.radius;
            normals[v] = this.slope.x * radial[0];
            normals[v + 1] = normalDir;
            normals[v + 2] = this.slope.x * radial[1];
            tangents[v] = this.slope.x * -radial[1];
            tangents[v + 1] = 0.0f;
            tangents[v + 2] = this.slope.x * radial[0];
        }
        for (i = 0; i < 8; ++i) {
            v = (i + 9) * 3;
            radial = RADIALS[i];
            coords[v] = xCenter;
            coords[v + 1] = yPoint;
            coords[v + 2] = zCenter;
            normals[v] = this.slope.x * radial[0];
            normals[v + 1] = normalDir;
            normals[v + 2] = this.slope.x * radial[1];
            tangents[v] = this.slope.x * -radial[1];
            tangents[v + 1] = 0.0f;
            tangents[v + 2] = this.slope.x * radial[0];
        }
        part.setCoords(coords);
        part.setNormals(normals);
        part.setTangents(tangents);
        part.setTexCoords(1.0f, 0.5f, 1.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f);
        if (this.direction == 4) {
            part.setIndexes(0, 1, 9, 1, 2, 10, 2, 3, 11, 3, 4, 12, 4, 5, 13, 5, 6, 14, 6, 7, 15, 7, 8, 16);
        } else {
            part.setIndexes(0, 9, 1, 1, 10, 2, 2, 11, 3, 3, 12, 4, 4, 13, 5, 5, 14, 6, 6, 15, 7, 7, 16, 8);
        }
        buffer.add(part);
        return 1;
    }

    @Override
    public boolean isSolid(int direction) {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean isBoundary(int direction) {
        return direction == this.flatDirection;
    }

    @Override
    public BoundaryShape getBoundaryShape(int direction) {
        if (direction != this.flatDirection) {
            return ShapeIndex.NULL_SHAPE;
        }
        return this.circle;
    }

    @Override
    public final float getTransparency(int axis) {
        return 0.0f;
    }

    @Override
    public Vector3f getMin() {
        return Vector3f.ZERO;
    }

    @Override
    public Vector3f getMax() {
        return Vector3f.UNIT_XYZ;
    }

    @Override
    public double getMassPortion() {
        double area = (double)(this.radius * this.radius) * Math.PI;
        return area * (double)(this.getMax().z - this.getMin().z);
    }

    @Override
    public boolean isClipped() {
        return true;
    }

    public static enum TextureType {
        DECAL,
        DECAL_STRETCHED,
        RADIAL;

    }
}

