/*
 * Decompiled with CFR 0.152.
 */
package mythruna.geom;

import com.jme3.math.Vector3f;
import mythruna.BlockType;
import mythruna.BoundaryShape;
import mythruna.ShapeIndex;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPartBuffer;
import mythruna.geom.PartFactory;
import mythruna.phys.Collider;

public class DefaultGeomFactory
implements GeomFactory {
    public static final Vector3f UNIT_CUBE = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final BoundaryShape UNIT_SQUARE = ShapeIndex.getRect(0.0f, 0.0f, 1.0f, 1.0f);
    private PartFactory[] dirParts = new PartFactory[6];
    private PartFactory internalParts;
    private Vector3f min;
    private Vector3f max;
    private double volume;
    private Collider collider;
    private boolean clipped;
    private boolean allSolid = false;
    private boolean[] solid = new boolean[6];
    private float[] transparency = new float[]{0.0f, 0.0f, 0.0f};

    public DefaultGeomFactory(Collider collider, float[] transparency, Double volume, boolean clipped, PartFactory[] dirParts, PartFactory internalParts) {
        int i;
        this.collider = collider;
        this.dirParts = dirParts;
        this.internalParts = internalParts;
        this.clipped = clipped;
        this.min = new Vector3f(1.0f, 1.0f, 1.0f);
        this.max = new Vector3f(0.0f, 0.0f, 0.0f);
        int solidCount = 0;
        for (i = 0; i < dirParts.length; ++i) {
            if (dirParts[i] == null) continue;
            this.min.minLocal(dirParts[i].getMin());
            this.max.maxLocal(dirParts[i].getMax());
            BoundaryShape shape = dirParts[i].getBoundaryShape();
            if (!(shape.getArea() >= 1.0f)) continue;
            this.solid[i] = true;
            ++solidCount;
        }
        boolean bl = this.allSolid = solidCount == 6;
        if (internalParts != null) {
            this.min.minLocal(internalParts.getMin());
            this.max.maxLocal(internalParts.getMax());
        }
        if (transparency == null) {
            float xAxis = Math.max(this.getBoundaryShape(2).getArea(), this.getBoundaryShape(3).getArea());
            float yAxis = Math.max(this.getBoundaryShape(0).getArea(), this.getBoundaryShape(1).getArea());
            float zAxis = Math.max(this.getBoundaryShape(4).getArea(), this.getBoundaryShape(5).getArea());
            this.transparency[0] = 1.0f - xAxis;
            this.transparency[1] = 1.0f - yAxis;
            this.transparency[2] = 1.0f - zAxis;
        } else {
            for (i = 0; i < 3; ++i) {
                this.transparency[i] = transparency[i];
            }
        }
        if (volume != null) {
            this.volume = volume;
        } else {
            double x = this.getMax().x - this.getMin().x;
            double y = this.getMax().y - this.getMin().y;
            double z = this.getMax().z - this.getMin().z;
            this.volume = x * y * z;
        }
    }

    @Override
    public boolean isSameShape(GeomFactory f) {
        if (f == this) {
            return true;
        }
        if (f == null || f.getClass() != this.getClass()) {
            return false;
        }
        DefaultGeomFactory other = (DefaultGeomFactory)f;
        return other.collider.equals(this.collider);
    }

    @Override
    public int createGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block, int dir) {
        if (this.dirParts[dir] == null) {
            return 0;
        }
        return this.dirParts[dir].addParts(buffer, x, y, z, xWorld, yWorld, zWorld, sun, light, block, dir);
    }

    @Override
    public int createInternalGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        if (this.internalParts == null) {
            return 0;
        }
        return this.internalParts.addParts(buffer, x, y, z, xWorld, yWorld, zWorld, sun, light, block, -1);
    }

    public Collider getCollider() {
        return this.collider;
    }

    @Override
    public final float getTransparency(int axis) {
        return this.transparency[axis];
    }

    @Override
    public final boolean isSolid(int direction) {
        return this.solid[direction];
    }

    @Override
    public final boolean isSolid() {
        return this.allSolid;
    }

    @Override
    public final boolean isBoundary(int direction) {
        return this.dirParts[direction] != null;
    }

    @Override
    public final BoundaryShape getBoundaryShape(int direction) {
        if (this.dirParts[direction] == null) {
            return ShapeIndex.NULL_SHAPE;
        }
        return this.dirParts[direction].getBoundaryShape();
    }

    @Override
    public final Vector3f getMin() {
        return this.min;
    }

    @Override
    public final Vector3f getMax() {
        return this.max;
    }

    @Override
    public final double getMassPortion() {
        return this.volume;
    }

    @Override
    public final boolean isClipped() {
        return this.clipped;
    }
}

