/*
 * Decompiled with CFR 0.152.
 */
package mythruna.geom;

import com.jme3.math.Vector3f;
import mythruna.BlockType;
import mythruna.BoundaryShape;
import mythruna.ShapeIndex;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPart;
import mythruna.geom.GeomPartBuffer;

public class GrassFactory
implements GeomFactory {
    private Vector3f max = new Vector3f(1.0f, 1.0f, 0.5f);
    private float height;
    private int materialType;
    private float[] normals = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    private float[][] texOffsets = new float[][]{{0.0f, 0.235f}, {0.25f, 0.485f}, {0.5f, 0.735f}, {0.75f, 0.985f}};

    public GrassFactory(float height, int materialType) {
        this.height = height;
        this.max.z = height * 0.5f;
        this.materialType = materialType;
    }

    @Override
    public int createGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block, int dir) {
        return 0;
    }

    @Override
    public boolean isSameShape(GeomFactory f) {
        if (f == this) {
            return true;
        }
        return f != null && f.getClass() == this.getClass();
    }

    protected float perturb(GeomPartBuffer buffer) {
        return (float)(buffer.nextRandom() * 0.3) - 0.15f;
    }

    @Override
    public int createInternalGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        float width = 1.2f;
        float innerOffset = width * 11.0f / 15.0f - 0.5f;
        float outerOffset = width * 0.5f;
        int texIndex = (x % 4 + y % 3) % 4;
        float xCenter = (float)x + 0.5f;
        float zCenter = (float)y + 0.5f;
        float yBase = z;
        GeomPart part = new GeomPart(this.materialType, 4);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter - innerOffset + this.perturb(buffer), yBase, zCenter - outerOffset, xCenter + outerOffset, yBase, zCenter + innerOffset + this.perturb(buffer), xCenter + outerOffset, (float)z + this.height, zCenter + innerOffset + this.perturb(buffer), xCenter - innerOffset + this.perturb(buffer), (float)z + this.height, zCenter - outerOffset);
        part.setNormals(this.normals);
        part.setTexCoords(0.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][1], 0.0f, this.texOffsets[texIndex][1]);
        part.setIndexes(0, 1, 2, 0, 2, 3);
        buffer.add(part);
        texIndex = (texIndex + 1) % 4;
        part = new GeomPart(this.materialType, 4);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter + innerOffset + this.perturb(buffer), yBase, zCenter - outerOffset, xCenter - outerOffset, yBase, zCenter + innerOffset + this.perturb(buffer), xCenter - outerOffset, (float)z + this.height, zCenter + innerOffset + this.perturb(buffer), xCenter + innerOffset + this.perturb(buffer), (float)z + this.height, zCenter - outerOffset);
        part.setNormals(this.normals);
        part.setTexCoords(0.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][1], 0.0f, this.texOffsets[texIndex][1]);
        part.setIndexes(0, 1, 2, 0, 2, 3);
        buffer.add(part);
        texIndex = (texIndex + 1) % 4;
        part = new GeomPart(this.materialType, 4);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter - outerOffset, yBase, zCenter - innerOffset + this.perturb(buffer), xCenter + innerOffset + this.perturb(buffer), yBase, zCenter + outerOffset, xCenter + innerOffset + this.perturb(buffer), (float)z + this.height, zCenter + outerOffset, xCenter - outerOffset, (float)z + this.height, zCenter - innerOffset + this.perturb(buffer));
        part.setNormals(this.normals);
        part.setTexCoords(0.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][1], 0.0f, this.texOffsets[texIndex][1]);
        part.setIndexes(0, 1, 2, 0, 2, 3);
        buffer.add(part);
        texIndex = (texIndex + 1) % 4;
        part = new GeomPart(this.materialType, 4);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter + outerOffset, yBase, zCenter - innerOffset + this.perturb(buffer), xCenter - innerOffset + this.perturb(buffer), yBase, zCenter + outerOffset, xCenter - innerOffset + this.perturb(buffer), (float)z + this.height, zCenter + outerOffset, xCenter + outerOffset, (float)z + this.height, zCenter - innerOffset + this.perturb(buffer));
        part.setNormals(this.normals);
        part.setTexCoords(0.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][0], 1.0f, this.texOffsets[texIndex][1], 0.0f, this.texOffsets[texIndex][1]);
        part.setIndexes(0, 1, 2, 0, 2, 3);
        buffer.add(part);
        return 4;
    }

    @Override
    public boolean isSolid(int direction) {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean isBoundary(int direction) {
        return false;
    }

    @Override
    public final float getTransparency(int axis) {
        return 1.0f;
    }

    @Override
    public BoundaryShape getBoundaryShape(int direction) {
        return ShapeIndex.NULL_SHAPE;
    }

    @Override
    public Vector3f getMin() {
        return Vector3f.ZERO;
    }

    @Override
    public Vector3f getMax() {
        return this.max;
    }

    @Override
    public double getMassPortion() {
        return 0.01;
    }

    @Override
    public boolean isClipped() {
        return false;
    }
}

