/*
 * Decompiled with CFR 0.152.
 */
package mythruna.geom;

import com.jme3.math.Vector3f;
import mythruna.BlockType;
import mythruna.BoundaryShape;
import mythruna.ShapeIndex;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPartBuffer;
import mythruna.geom.GeomUtils;

public class PartialCubeFactory
implements GeomFactory {
    private Vector3f min;
    private Vector3f max;
    private int[] types = new int[6];
    private boolean[] solid = new boolean[6];
    private boolean[] boundary = new boolean[6];
    private float[] transparency = new float[]{0.0f, 0.0f, 0.0f};
    private BoundaryShape[] shapes = new BoundaryShape[6];
    private boolean clip;
    private boolean includeNormals = false;

    public PartialCubeFactory(Vector3f min, Vector3f max, boolean clip, boolean includeNormals, float[] light, int sideType, int topType, int bottomType, int ... matTypes) {
        int i;
        this.min = min;
        this.max = max;
        this.clip = clip;
        this.includeNormals = includeNormals;
        for (i = 0; i < this.types.length; ++i) {
            this.types[i] = sideType;
        }
        this.types[4] = topType;
        this.types[5] = bottomType;
        for (i = 0; i < matTypes.length; ++i) {
            this.types[i] = matTypes[i];
        }
        if (light != null) {
            this.transparency = light;
        }
        this.boundary[4] = max.z == 1.0f;
        this.boundary[5] = min.z == 0.0f;
        this.boundary[0] = min.y == 0.0f;
        this.boundary[1] = max.y == 1.0f;
        this.boundary[2] = max.x == 1.0f;
        this.boundary[3] = min.x == 0.0f;
        float x = max.x - min.x;
        float y = max.y - min.y;
        float z = max.z - min.z;
        if (this.transparency[0] == 0.0f) {
            this.transparency[0] = 1.0f - z * y;
        }
        if (this.transparency[1] == 0.0f) {
            this.transparency[1] = 1.0f - z * x;
        }
        if (this.transparency[2] == 0.0f) {
            this.transparency[2] = 1.0f - x * y;
        }
        if (max.z == 1.0f && min.x == 0.0f && max.x == 1.0f && min.y == 0.0f && max.y == 1.0f) {
            this.solid[4] = true;
        }
        if (min.z == 0.0f && min.x == 0.0f && max.x == 1.0f && min.y == 0.0f && max.y == 1.0f) {
            this.solid[5] = true;
        }
        if (min.y == 0.0f && min.x == 0.0f && max.x == 1.0f && min.z == 0.0f && max.z == 1.0f) {
            this.solid[0] = true;
        }
        if (max.y == 1.0f && min.x == 0.0f && max.x == 1.0f && min.z == 0.0f && max.z == 1.0f) {
            this.solid[1] = true;
        }
        if (max.x == 1.0f && min.y == 0.0f && max.y == 1.0f && min.z == 0.0f && max.z == 1.0f) {
            this.solid[2] = true;
        }
        if (min.x == 0.0f && min.y == 0.0f && max.y == 1.0f && min.z == 0.0f && max.z == 1.0f) {
            this.solid[3] = true;
        }
        this.shapes[4] = this.boundary[4] ? ShapeIndex.getRect(min.x, min.y, max.x, max.y) : ShapeIndex.NULL_SHAPE;
        this.shapes[5] = this.boundary[5] ? ShapeIndex.getRect(min.x, min.y, max.x, max.y) : ShapeIndex.NULL_SHAPE;
        this.shapes[0] = this.boundary[0] ? ShapeIndex.getRect(min.x, min.z, max.x, max.z) : ShapeIndex.NULL_SHAPE;
        this.shapes[1] = this.boundary[1] ? ShapeIndex.getRect(min.x, min.z, max.x, max.z) : ShapeIndex.NULL_SHAPE;
        this.shapes[2] = this.boundary[2] ? ShapeIndex.getRect(min.y, min.z, max.y, max.z) : ShapeIndex.NULL_SHAPE;
        this.shapes[3] = this.boundary[3] ? ShapeIndex.getRect(min.y, min.z, max.y, max.z) : ShapeIndex.NULL_SHAPE;
    }

    @Override
    public boolean isSameShape(GeomFactory f) {
        if (f == this) {
            return true;
        }
        if (f == null || f.getClass() != this.getClass()) {
            return false;
        }
        PartialCubeFactory other = (PartialCubeFactory)f;
        if (!this.min.equals((Object)other.min)) {
            return false;
        }
        return this.max.equals((Object)other.max);
    }

    @Override
    public int createGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block, int dir) {
        int type = this.types[dir];
        int count = 0;
        if (this.boundary[dir]) {
            buffer.add(GeomUtils.createQuad(x, y, z, this.min, this.max, this.includeNormals, dir, type, sun, light));
            ++count;
        }
        return count;
    }

    @Override
    public int createInternalGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        int count = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.boundary[i]) continue;
            buffer.add(GeomUtils.createQuad(x, y, z, this.min, this.max, this.includeNormals, i, this.types[i], sun, light));
            ++count;
        }
        return count;
    }

    @Override
    public boolean isClipped() {
        return this.clip;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean isSolid(int direction) {
        if (direction < 0) {
            return false;
        }
        return this.solid[direction];
    }

    @Override
    public boolean isBoundary(int direction) {
        if (direction < 0) {
            return false;
        }
        return this.boundary[direction];
    }

    @Override
    public BoundaryShape getBoundaryShape(int direction) {
        return this.shapes[direction];
    }

    @Override
    public final float getTransparency(int axis) {
        return this.transparency[axis];
    }

    @Override
    public Vector3f getMin() {
        return this.min;
    }

    @Override
    public Vector3f getMax() {
        return this.max;
    }

    @Override
    public double getMassPortion() {
        double x = this.getMax().x - this.getMin().x;
        double y = this.getMax().y - this.getMin().y;
        double z = this.getMax().z - this.getMin().z;
        return x * y * z;
    }
}

