/*
 * Decompiled with CFR 0.152.
 */
package mythruna.geom;

import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import mythruna.BlockType;
import mythruna.BoundaryShape;
import mythruna.ShapeIndex;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPart;
import mythruna.geom.GeomPartBuffer;

public class TreeLeafFactory
implements GeomFactory {
    private static float COS_45 = FastMath.cos((float)0.7853982f);
    private static float SIN_45 = FastMath.sin((float)0.7853982f);
    private static Vector3f min = new Vector3f(0.25f, 0.25f, 0.25f);
    private static Vector3f max = new Vector3f(0.75f, 0.75f, 0.75f);
    private int materialType;
    private static final int ATLAS_SIZE = 16;
    private float[][] yTexOffsets = new float[][]{{0.0f, 0.249f}, {0.25f, 0.49f}, {0.5f, 0.749f}, {0.75f, 0.99f}, {0.249f, 0.0f}, {0.49f, 0.25f}, {0.749f, 0.5f}, {0.99f, 0.75f}, {0.0f, 0.249f}, {0.25f, 0.49f}, {0.5f, 0.749f}, {0.75f, 0.99f}, {0.249f, 0.0f}, {0.49f, 0.25f}, {0.749f, 0.5f}, {0.99f, 0.75f}};
    private float[][] xTexOffsets = new float[][]{{0.0f, 0.25f}, {0.0f, 0.25f}, {0.0f, 0.25f}, {0.0f, 0.25f}, {0.0f, 0.25f}, {0.0f, 0.25f}, {0.0f, 0.25f}, {0.0f, 0.25f}, {0.25f, 0.0f}, {0.25f, 0.0f}, {0.25f, 0.0f}, {0.25f, 0.0f}, {0.25f, 0.0f}, {0.25f, 0.0f}, {0.25f, 0.0f}, {0.25f, 0.0f}};
    private float[] normals = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};

    public TreeLeafFactory(int materialType) {
        this.materialType = materialType;
    }

    @Override
    public boolean isSameShape(GeomFactory f) {
        if (f == this) {
            return true;
        }
        return f != null && f.getClass() == this.getClass();
    }

    @Override
    public int createGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block, int dir) {
        return 0;
    }

    protected float perturb(GeomPartBuffer buffer) {
        return (float)(buffer.nextRandom() * 0.3) - 0.15f;
    }

    @Override
    public int createInternalGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        return this.createInternalGeometryPlain(buffer, x, y, z, xWorld, yWorld, zWorld, sun, light, block);
    }

    public int createInternalGeometryPlain(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        float height = 1.8f;
        float width = 0.9f;
        float xCenter = (float)x + 0.5f;
        float zCenter = (float)y + 0.5f;
        float yBase = (float)z - 0.4f;
        float offset = 0.05f;
        float nest = 0.1f;
        float angle = 0.5105088f;
        float cos = FastMath.cos((float)angle);
        float sin = FastMath.sin((float)angle);
        Vector3f norm = new Vector3f(cos, cos, sin);
        norm.normalize();
        Vector3f norm2 = new Vector3f(cos, 0.0f, sin);
        norm2.normalize();
        int texIndex = (int)(buffer.nextRandom() * 16.0);
        GeomPart part = new GeomPart(this.materialType, -1);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter + width - offset - nest, yBase, zCenter + width + offset + nest, xCenter - width - offset + nest, yBase, zCenter - width + offset - nest, xCenter - width + nest, yBase + height, zCenter - width - nest, xCenter + width - nest, yBase + height, zCenter + width + nest);
        part.setNormals(norm2.x, -norm2.y, norm2.z, -norm2.z, -norm2.y, -norm2.x, -norm.z, norm.y, -norm.x, norm.x, norm.y, norm.z);
        part.setTexCoords(this.xTexOffsets[texIndex][0], this.yTexOffsets[texIndex][0], this.xTexOffsets[texIndex][1], this.yTexOffsets[texIndex][0], this.xTexOffsets[texIndex][1], this.yTexOffsets[texIndex][1], this.xTexOffsets[texIndex][0], this.yTexOffsets[texIndex][1]);
        part.setIndexes(0, 1, 2, 0, 2, 3);
        buffer.add(part);
        texIndex = (texIndex + 1) % 16;
        part = new GeomPart(this.materialType, -1);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter - width + offset + nest, yBase, zCenter - width - offset - nest, xCenter + width + offset - nest, yBase, zCenter + width - offset + nest, xCenter + width - nest, yBase + height, zCenter + width + nest, xCenter - width + nest, yBase + height, zCenter - width - nest);
        part.setNormals(-norm2.x, -norm2.y, -norm2.z, norm2.z, -norm2.y, norm2.x, norm.z, norm.y, norm.x, -norm.x, norm.y, -norm.z);
        part.setTexCoords(this.xTexOffsets[texIndex][0], this.yTexOffsets[texIndex][0], this.xTexOffsets[texIndex][1], this.yTexOffsets[texIndex][0], this.xTexOffsets[texIndex][1], this.yTexOffsets[texIndex][1], this.xTexOffsets[texIndex][0], this.yTexOffsets[texIndex][1]);
        part.setIndexes(0, 1, 2, 0, 2, 3);
        buffer.add(part);
        texIndex = (texIndex + 1) % 16;
        part = new GeomPart(this.materialType, -1);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter + width + offset + nest, yBase, zCenter - width + offset + nest, xCenter - width + offset - nest, yBase, zCenter + width + offset - nest, xCenter - width - nest, yBase + height, zCenter + width - nest, xCenter + width + nest, yBase + height, zCenter - width + nest);
        part.setNormals(norm2.z, -norm2.y, -norm2.x, -norm2.x, -norm2.y, norm2.z, -norm.x, norm.y, norm.z, norm.z, norm.y, -norm.x);
        part.setTexCoords(this.xTexOffsets[texIndex][0], this.yTexOffsets[texIndex][0], this.xTexOffsets[texIndex][1], this.yTexOffsets[texIndex][0], this.xTexOffsets[texIndex][1], this.yTexOffsets[texIndex][1], this.xTexOffsets[texIndex][0], this.yTexOffsets[texIndex][1]);
        part.setIndexes(0, 1, 2, 0, 2, 3);
        buffer.add(part);
        texIndex = (texIndex + 1) % 16;
        part = new GeomPart(this.materialType, -1);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter - width - offset - nest, yBase, zCenter + width - offset - nest, xCenter + width - offset + nest, yBase, zCenter - width - offset + nest, xCenter + width + nest, yBase + height, zCenter - width + nest, xCenter - width - nest, yBase + height, zCenter + width - nest);
        part.setNormals(-norm2.z, -norm2.y, norm2.x, norm2.x, -norm2.y, -norm2.z, norm.x, norm.y, -norm.z, -norm.z, norm.y, norm.x);
        part.setTexCoords(this.xTexOffsets[texIndex][0], this.yTexOffsets[texIndex][0], this.xTexOffsets[texIndex][1], this.yTexOffsets[texIndex][0], this.xTexOffsets[texIndex][1], this.yTexOffsets[texIndex][1], this.xTexOffsets[texIndex][0], this.yTexOffsets[texIndex][1]);
        part.setIndexes(0, 1, 2, 0, 2, 3);
        buffer.add(part);
        texIndex = (texIndex + 1) % 16;
        part = new GeomPart(this.materialType, -1);
        part.setSun(sun);
        part.setLight(light);
        float topWidth = 0.5f;
        float yTop = (float)z + 0.5f;
        part.setCoords(xCenter - topWidth, yTop, zCenter + topWidth, xCenter + topWidth, yTop, zCenter + topWidth, xCenter + topWidth, yTop, zCenter - topWidth, xCenter - topWidth, yTop, zCenter - topWidth);
        part.setNormals(-norm.z, norm.y, norm.x, norm.x, norm.y, norm.z, norm.z, norm.y, -norm.x, -norm.x, norm.y, -norm.z);
        part.setTexCoords(this.xTexOffsets[texIndex][0], this.yTexOffsets[texIndex][0], this.xTexOffsets[texIndex][1], this.yTexOffsets[texIndex][0], this.xTexOffsets[texIndex][1], this.yTexOffsets[texIndex][1], this.xTexOffsets[texIndex][0], this.yTexOffsets[texIndex][1]);
        part.setIndexes(0, 1, 2, 0, 2, 3);
        buffer.add(part);
        return 0;
    }

    public int createInternalGeometryModifiedGrass(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        float height = 1.2f;
        float width = 1.2f;
        float innerOffset = width * 11.0f / 15.0f - 0.5f;
        float outerOffset = width * 0.5f;
        int texIndex = (x % 4 + y % 3) % 4;
        float xCenter = (float)x + 0.5f;
        float zCenter = (float)y + 0.5f;
        float yBase = z;
        Vector3f norm = new Vector3f(1.0f, 1.0f, 1.0f);
        norm.normalize();
        GeomPart part = new GeomPart(this.materialType, 4);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter - innerOffset + this.perturb(buffer), yBase, zCenter - outerOffset, xCenter + outerOffset, yBase, zCenter + innerOffset + this.perturb(buffer), xCenter + outerOffset, (float)z + height, zCenter + innerOffset + this.perturb(buffer), xCenter - innerOffset + this.perturb(buffer), (float)z + height, zCenter - outerOffset);
        part.setNormals(this.normals);
        part.setTexCoords(0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
        part.setIndexes(0, 1, 2, 0, 2, 3);
        buffer.add(part);
        texIndex = (texIndex + 1) % 4;
        part = new GeomPart(this.materialType, 4);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter + innerOffset + this.perturb(buffer), yBase, zCenter - outerOffset, xCenter - outerOffset, yBase, zCenter + innerOffset + this.perturb(buffer), xCenter - outerOffset, (float)z + height, zCenter + innerOffset + this.perturb(buffer), xCenter + innerOffset + this.perturb(buffer), (float)z + height, zCenter - outerOffset);
        part.setNormals(this.normals);
        part.setTexCoords(0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
        part.setIndexes(0, 1, 2, 0, 2, 3);
        buffer.add(part);
        texIndex = (texIndex + 1) % 4;
        part = new GeomPart(this.materialType, 4);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter - outerOffset, yBase, zCenter - innerOffset + this.perturb(buffer), xCenter + innerOffset + this.perturb(buffer), yBase, zCenter + outerOffset, xCenter + innerOffset + this.perturb(buffer), (float)z + height, zCenter + outerOffset, xCenter - outerOffset, (float)z + height, zCenter - innerOffset + this.perturb(buffer));
        part.setNormals(this.normals);
        part.setTexCoords(0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
        part.setIndexes(0, 1, 2, 0, 2, 3);
        buffer.add(part);
        texIndex = (texIndex + 1) % 4;
        part = new GeomPart(this.materialType, 4);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter + outerOffset, yBase, zCenter - innerOffset + this.perturb(buffer), xCenter - innerOffset + this.perturb(buffer), yBase, zCenter + outerOffset, xCenter - innerOffset + this.perturb(buffer), (float)z + height, zCenter + outerOffset, xCenter + outerOffset, (float)z + height, zCenter - innerOffset + this.perturb(buffer));
        part.setNormals(this.normals);
        part.setTexCoords(0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
        part.setIndexes(0, 1, 2, 0, 2, 3);
        buffer.add(part);
        return 4;
    }

    public int createInternalGeometryFunky(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        int count = 0;
        float xCenter = (float)x + 0.5f;
        float zCenter = (float)y + 0.5f;
        float yBase = z;
        float yTop = (float)z + 1.0f;
        float outer = 0.5f;
        float inner = 0.1f;
        float outerOffset = 0.1f;
        float innerOffset = 0.1f;
        float lowerOffset = -0.2f;
        Vector3f norm = new Vector3f(1.0f, 1.0f, 1.0f);
        norm.normalize();
        GeomPart part = new GeomPart(this.materialType, 4);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter - outer - outerOffset, yTop, zCenter - outer + outerOffset, xCenter + inner + innerOffset, yTop, zCenter + inner - innerOffset, xCenter - outer + outerOffset, yBase - lowerOffset, zCenter - outer - outerOffset);
        part.setNormals(-norm.x, norm.y, -norm.z, norm.x, norm.y, -norm.z, -SIN_45, 0.0f, -COS_45);
        part.setTexCoords(0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f);
        part.setIndexes(0, 1, 2);
        buffer.add(part);
        ++count;
        part = new GeomPart(this.materialType, 4);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter - outer + outerOffset, yTop, zCenter - outer - outerOffset, xCenter + inner - innerOffset, yTop, zCenter + inner + innerOffset, xCenter - outer - outerOffset, yBase - lowerOffset, zCenter - outer + outerOffset);
        part.setNormals(-norm.x, norm.y, -norm.z, -norm.x, norm.y, norm.z, -SIN_45, 0.0f, -COS_45);
        part.setTexCoords(0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f);
        part.setIndexes(0, 2, 1);
        buffer.add(part);
        ++count;
        part = new GeomPart(this.materialType, 4);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter + outer - outerOffset, yTop, zCenter + outer + outerOffset, xCenter - inner + innerOffset, yTop, zCenter - inner - innerOffset, xCenter + outer + outerOffset, yBase - lowerOffset, zCenter + outer - outerOffset);
        part.setNormals(norm.x, norm.y, norm.z, norm.x, norm.y, -norm.z, SIN_45, 0.0f, COS_45);
        part.setTexCoords(0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f);
        part.setIndexes(0, 2, 1);
        buffer.add(part);
        ++count;
        part = new GeomPart(this.materialType, 4);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter + outer + outerOffset, yTop, zCenter + outer - outerOffset, xCenter - inner - innerOffset, yTop, zCenter - inner + innerOffset, xCenter + outer - outerOffset, yBase - lowerOffset, zCenter + outer + outerOffset);
        part.setNormals(norm.x, norm.y, norm.z, -norm.x, norm.y, norm.z, SIN_45, 0.0f, COS_45);
        part.setTexCoords(0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f);
        part.setIndexes(0, 1, 2);
        buffer.add(part);
        return ++count;
    }

    @Override
    public boolean isSolid(int direction) {
        return true;
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    @Override
    public boolean isBoundary(int direction) {
        return false;
    }

    @Override
    public BoundaryShape getBoundaryShape(int direction) {
        return ShapeIndex.NULL_SHAPE;
    }

    @Override
    public final float getTransparency(int axis) {
        return 0.75f;
    }

    @Override
    public Vector3f getMin() {
        return min;
    }

    @Override
    public Vector3f getMax() {
        return max;
    }

    @Override
    public double getMassPortion() {
        double x = this.getMax().x - this.getMin().x;
        double y = this.getMax().y - this.getMin().y;
        double z = this.getMax().z - this.getMin().z;
        return x * y * z * 0.125;
    }

    @Override
    public boolean isClipped() {
        return true;
    }
}

