/*
 * Decompiled with CFR 0.152.
 */
package mythruna.item;

import mythruna.es.AndFilter;
import mythruna.es.ComponentFilter;
import mythruna.es.EntityComponent;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.FieldFilter;
import mythruna.item.IntVariable;
import mythruna.item.Variable;

public class LocalVariables {
    private final EntityData ed;
    private EntityId holder;

    public LocalVariables(EntityData ed, EntityId holder) {
        this.ed = ed;
        this.holder = holder;
    }

    protected <T extends EntityComponent> ComponentFilter<T> filter(Class<T> type, int nameId) {
        FieldFilter<T> filter1 = FieldFilter.create(type, "holder", this.holder);
        FieldFilter<T> filter2 = FieldFilter.create(type, "nameId", nameId);
        AndFilter<T> filter = AndFilter.create(type, filter1, filter2);
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setVariable(Variable newValue) {
        ComponentFilter<?> filter = this.filter(newValue.getClass(), newValue.getNameId());
        EntityId varId = this.ed.findEntity(filter, new Class[0]);
        if (varId == null) {
            EntityData entityData = this.ed;
            synchronized (entityData) {
                varId = this.ed.findEntity(filter, new Class[0]);
                if (varId == null) {
                    varId = this.ed.createEntity();
                    this.ed.setComponent(varId, newValue);
                    return;
                }
            }
        }
        this.ed.setComponent(varId, newValue);
    }

    public void setInt(String name, int value) {
        int id = this.ed.getStrings().getStringId(name, true);
        if (id < 0) {
            throw new RuntimeException("Error creating ID for:" + name);
        }
        IntVariable newValue = new IntVariable(this.holder, id, value);
        this.setVariable(newValue);
    }

    public int getInt(String name) {
        int id = this.ed.getStrings().getStringId(name, false);
        if (id < 0) {
            return 0;
        }
        ComponentFilter<IntVariable> filter = this.filter(IntVariable.class, id);
        EntityId varId = this.ed.findEntity(filter, IntVariable.class);
        if (varId == null) {
            return 0;
        }
        IntVariable val = this.ed.getComponent(varId, IntVariable.class);
        if (val == null) {
            return 0;
        }
        return val.getValue();
    }
}

