/*
 * Decompiled with CFR 0.152.
 */
package mythruna.phys;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mythruna.mathd.Vec3d;
import mythruna.phys.Contact;
import mythruna.phys.ContactResolver;
import mythruna.phys.RigidBody;

public class TandemContactResolver
implements ContactResolver {
    private static Accumulator nullAccumulator = new Accumulator();

    @Override
    public void resolveContacts(List<Contact> contacts, double t) {
        HashMap<RigidBody, Accumulator> accumulators = new HashMap<RigidBody, Accumulator>();
        this.resolvePenetration(contacts, t, accumulators);
        this.resolveVelocity(contacts, t, accumulators);
    }

    protected void resolvePenetration(List<Contact> contacts, double t, Map<RigidBody, Accumulator> accumulators) {
        Vec3d linear1 = new Vec3d();
        Vec3d angular1 = new Vec3d();
        Vec3d linear2 = new Vec3d();
        Vec3d angular2 = new Vec3d();
        for (Contact c : contacts) {
            c.matchAwakeState();
            double localTemperature = c.localTemperature;
            if (RigidBody.isCold(localTemperature)) continue;
            if (c.body1 != null) {
                c.body1.incrementContactCount();
            }
            if (c.body2 != null) {
                c.body2.incrementContactCount();
            }
            c.calculateInternals(t * localTemperature);
            c.calculatePositionChange(linear1, linear2, angular1, angular2, c.penetration);
            this.getAccumulator(c.body1, accumulators).accumulate(linear1, angular1);
            this.getAccumulator(c.body2, accumulators).accumulate(linear2, angular2);
        }
        Vec3d lin = new Vec3d();
        Vec3d ang = new Vec3d();
        for (Map.Entry<RigidBody, Accumulator> e : accumulators.entrySet()) {
            RigidBody b = e.getKey();
            Accumulator acc = e.getValue();
            Vec3d l = acc.getLinear(lin);
            Vec3d a = acc.getAngular(ang);
            acc.clear();
            b.getCollisionMesh().position.addLocal(l);
            b.getCollisionMesh().orientation.addScaledVectorLocal(a, 1.0);
            b.calculateDerivedData();
        }
    }

    protected void resolveVelocity(List<Contact> contacts, double t, Map<RigidBody, Accumulator> accumulators) {
        Vec3d vDelta1 = new Vec3d();
        Vec3d rotDelta1 = new Vec3d();
        Vec3d vDelta2 = new Vec3d();
        Vec3d rotDelta2 = new Vec3d();
        for (Contact c : contacts) {
            if (RigidBody.isCold(c.localTemperature)) continue;
            c.calculateVelocityChange(vDelta1, vDelta2, rotDelta1, rotDelta2);
            this.getAccumulator(c.body1, accumulators).accumulate(vDelta1, rotDelta1);
            this.getAccumulator(c.body2, accumulators).accumulate(vDelta2, rotDelta2);
        }
        Vec3d lin = new Vec3d();
        Vec3d ang = new Vec3d();
        for (Map.Entry<RigidBody, Accumulator> e : accumulators.entrySet()) {
            RigidBody b = e.getKey();
            Accumulator acc = e.getValue();
            Vec3d l = acc.getLinear(lin);
            Vec3d a = acc.getAngular(ang);
            acc.clear();
            b.addVelocity(l);
            b.addRotation(a);
        }
    }

    private final Accumulator getAccumulator(RigidBody body, Map<RigidBody, Accumulator> accumulators) {
        if (body == null) {
            return nullAccumulator;
        }
        Accumulator result = accumulators.get(body);
        if (result == null) {
            result = new Accumulator();
            accumulators.put(body, result);
        }
        return result;
    }

    static class Accumulator {
        Vec3d linMin = new Vec3d();
        Vec3d linMax = new Vec3d();
        Vec3d angMin = new Vec3d();
        Vec3d angMax = new Vec3d();

        Accumulator() {
        }

        public void accumulate(Vec3d lin, Vec3d ang) {
            this.linMin.minLocal(lin);
            this.linMax.maxLocal(lin);
            this.angMin.minLocal(ang);
            this.angMax.maxLocal(ang);
        }

        public final Vec3d getLinear(Vec3d store) {
            store.x = this.linMin.x + this.linMax.x;
            store.y = this.linMin.y + this.linMax.y;
            store.z = this.linMin.z + this.linMax.z;
            return store;
        }

        public final Vec3d getAngular(Vec3d store) {
            store.x = this.angMin.x + this.angMax.x;
            store.y = this.angMin.y + this.angMax.y;
            store.z = this.angMin.z + this.angMax.z;
            return store;
        }

        public final void clear() {
            this.linMin.set(0.0, 0.0, 0.0);
            this.linMax.set(0.0, 0.0, 0.0);
            this.angMin.set(0.0, 0.0, 0.0);
            this.angMax.set(0.0, 0.0, 0.0);
        }
    }
}

