/*
 * Decompiled with CFR 0.152.
 */
package mythruna.phys;

import mythruna.BlockType;
import mythruna.BlockTypeIndex;
import mythruna.Direction;
import mythruna.Vector3i;
import mythruna.World;
import mythruna.db.LeafData;
import mythruna.db.LeafInfo;

public class WorldLeaf {
    private World world;
    private LeafData leaf;
    private long version;
    private int[][][] cells;
    private byte[][][] masks;
    private Vector3i baseLoc;

    public WorldLeaf(World world, LeafData leaf) {
        this.world = world;
        LeafInfo info = leaf.getInfo();
        this.baseLoc = new Vector3i(info.x, info.y, info.z);
        this.update(leaf);
    }

    public void update(LeafData leaf) {
        this.leaf = leaf;
        this.update();
    }

    public final int getType(int x, int y, int z) {
        return LeafData.toType(this.cells[x][y][z]);
    }

    public final int getMask(int x, int y, int z) {
        return this.masks[x][y][z];
    }

    public final int getWorldType(int x, int y, int z) {
        return LeafData.toType(this.cells[x -= this.baseLoc.x][y -= this.baseLoc.y][z -= this.baseLoc.z]);
    }

    public final byte getWorldMask(int x, int y, int z) {
        return this.masks[x -= this.baseLoc.x][y -= this.baseLoc.y][z -= this.baseLoc.z];
    }

    private final int get(int x, int y, int z) {
        return this.world.getType(this.baseLoc.x + x, this.baseLoc.y + y, this.baseLoc.z + z, (LeafData)null);
    }

    protected void update() {
        this.version = this.leaf.getInfo().version;
        this.cells = this.leaf.getCells();
        int size = 32;
        this.masks = new byte[size][size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                for (int k = 0; k < size; ++k) {
                    BlockType type;
                    int t = LeafData.toType(this.cells[i][j][k]);
                    if (t == 0 || (type = BlockTypeIndex.types[t]) == null || !type.getGeomFactory().isClipped()) continue;
                    int mask = 0;
                    int bit = 1;
                    int d = 0;
                    while (d < 6) {
                        int xa = i + Direction.DIRS[d][0];
                        int ya = j + Direction.DIRS[d][1];
                        int za = k + Direction.DIRS[d][2];
                        int a = xa < 0 || ya < 0 || za < 0 ? this.get(xa, ya, za) : (xa >= size || ya >= size || za >= size ? this.get(xa, ya, za) : LeafData.toType(this.cells[xa][ya][za]));
                        if (a == 0) {
                            mask |= bit;
                        } else {
                            BlockType adjType = BlockTypeIndex.types[a];
                            if (adjType == null || !adjType.getGeomFactory().isClipped()) {
                                mask |= bit;
                            } else if (type.getGroup() != adjType.getGroup()) {
                                mask |= bit;
                            } else {
                                int back = Direction.INVERSE[d];
                                if (!type.getBoundary(d).isMatchingFace(adjType.getBoundary(back))) {
                                    mask |= bit;
                                }
                            }
                        }
                        ++d;
                        bit <<= 1;
                    }
                    this.masks[i][j][k] = (byte)mask;
                }
            }
        }
    }
}

