/*
 * Decompiled with CFR 0.152.
 */
package mythruna.phys.collision;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import mythruna.Direction;
import mythruna.mathd.Quatd;
import mythruna.mathd.Vec3d;
import mythruna.phys.Collider;
import mythruna.phys.Contact;

public class CubeCollider
implements Collider {
    private Vec3d center = new Vec3d(0.5, 0.5, 0.5);
    private Vec3d extents = new Vec3d(0.5, 0.5, 0.5);
    private boolean symetric = false;
    private String name;

    public CubeCollider() {
    }

    public CubeCollider(String name) {
        this.name = name;
    }

    public CubeCollider(Vec3d min, Vec3d max) {
        this(min, max, null);
    }

    public CubeCollider(Vec3d min, Vec3d max, String name) {
        this.name = name;
        this.center.set(min);
        this.center.addLocal(max);
        this.center.multLocal(0.5);
        this.extents.set(max);
        this.extents.subtractLocal(min);
        this.extents.multLocal(0.5);
        if (this.center.x == 0.0 && this.center.z == 0.0) {
            this.symetric = true;
        }
    }

    public CubeCollider(Vector3f min, Vector3f max) {
        this(min, max, null);
    }

    public CubeCollider(Vector3f min, Vector3f max, String name) {
        this.name = name;
        this.center.set(min.x, min.z, min.y);
        this.center.addLocal(max.x, max.z, max.y);
        this.center.multLocal(0.5);
        this.extents.set(max.x, max.z, max.y);
        this.extents.subtractLocal(min.x, min.z, min.y);
        this.extents.multLocal(0.5);
        if (this.center.x == 0.0 && this.center.y == 0.0) {
            this.symetric = true;
        }
    }

    protected CubeCollider(CubeCollider toClone) {
        this.center = toClone.center.clone();
        this.extents = toClone.extents.clone();
        this.symetric = toClone.symetric;
        this.name = toClone.name;
    }

    protected static float epsilon(float f) {
        long i = Math.round(f * 10000.0f);
        f = (float)i / 10000.0f;
        return f;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = "box";
        }
        return this.name;
    }

    protected double epsilon(double d) {
        long i = Math.round(d * 10000.0);
        d = (double)i / 10000.0;
        return d;
    }

    @Override
    public Collider rotate(int dirDelta) {
        if (this.symetric) {
            return new CubeCollider(this);
        }
        Vec3d min = this.center.subtract(this.extents);
        Vec3d max = this.center.add(this.extents);
        min.subtractLocal(0.5, 0.5, 0.5);
        max.subtractLocal(0.5, 0.5, 0.5);
        Quaternion quat = new Quaternion().fromAngles(0.0f, (float)(-Math.PI) / 180 * (float)dirDelta * 90.0f, 0.0f);
        Quatd q = new Quatd(quat.getX(), quat.getY(), quat.getZ(), quat.getW());
        Vec3d v1 = q.mult(min);
        Vec3d v2 = q.mult(max);
        min.x = this.epsilon(0.5 + Math.min(v1.x, v2.x));
        min.y = this.epsilon(0.5 + Math.min(v1.y, v2.y));
        min.z = this.epsilon(0.5 + Math.min(v1.z, v2.z));
        max.x = this.epsilon(0.5 + Math.max(v1.x, v2.x));
        max.y = this.epsilon(0.5 + Math.max(v1.y, v2.y));
        max.z = this.epsilon(0.5 + Math.max(v1.z, v2.z));
        CubeCollider result = new CubeCollider(min, max, this.name);
        return result;
    }

    private static final double clamp(double v, double min, double max) {
        return v < min ? min : (v > max ? max : v);
    }

    private static final double clamp(double v, double extent) {
        return CubeCollider.clamp(v, -extent, extent);
    }

    @Override
    public Contact getContact(Vec3d cellPos, Vec3d pos, double radius, int dirMask, int srcInvMask) {
        double p;
        double x = pos.x - (cellPos.x + this.center.x);
        double y = pos.y - (cellPos.y + this.center.y);
        double z = pos.z - (cellPos.z + this.center.z);
        if (x <= -(this.extents.x + radius)) {
            return null;
        }
        if (y <= -(this.extents.y + radius)) {
            return null;
        }
        if (z <= -(this.extents.z + radius)) {
            return null;
        }
        if (x >= this.extents.x + radius) {
            return null;
        }
        if (y >= this.extents.y + radius) {
            return null;
        }
        if (z >= this.extents.z + radius) {
            return null;
        }
        Vec3d cp = new Vec3d();
        Vec3d normal = new Vec3d();
        double pen = 10.0;
        int hitMask = 0;
        if (Direction.hasEast(srcInvMask) && (p = this.extents.x + radius - x) > 0.0 && p < pen) {
            pen = p;
            normal.set(1.0, 0.0, 0.0);
            cp.set(0.5, CubeCollider.clamp(y, this.extents.y), CubeCollider.clamp(z, this.extents.z));
            hitMask = 4;
        }
        if (Direction.hasWest(srcInvMask) && (p = x + (this.extents.x + radius)) > 0.0 && p < pen) {
            pen = p;
            normal.set(-1.0, 0.0, 0.0);
            cp.set(-0.5, CubeCollider.clamp(y, this.extents.y), CubeCollider.clamp(z, this.extents.z));
            hitMask = 8;
        }
        if (Direction.hasSouth(srcInvMask) && (p = this.extents.z + radius - z) > 0.0 && p < pen) {
            pen = p;
            normal.set(0.0, 0.0, 1.0);
            cp.set(CubeCollider.clamp(x, this.extents.x), CubeCollider.clamp(y, this.extents.y), 0.5);
            hitMask = 2;
        }
        if (Direction.hasNorth(srcInvMask) && (p = z + (this.extents.z + radius)) > 0.0 && p < pen) {
            pen = p;
            normal.set(0.0, 0.0, -1.0);
            cp.set(CubeCollider.clamp(x, this.extents.x), CubeCollider.clamp(y, this.extents.y), -0.5);
            hitMask = 1;
        }
        if (Direction.hasUp(srcInvMask) && (p = this.extents.y + radius - y) > 0.0 && p < pen) {
            pen = p;
            normal.set(0.0, 1.0, 0.0);
            cp.set(CubeCollider.clamp(x, this.extents.x), 0.5, CubeCollider.clamp(z, this.extents.z));
            hitMask = 16;
        }
        if (Direction.hasDown(srcInvMask) && (p = y + (this.extents.y + radius)) > 0.0 && p < pen) {
            pen = p;
            normal.set(0.0, -1.0, 0.0);
            cp.set(CubeCollider.clamp(x, this.extents.x), -0.5, CubeCollider.clamp(z, this.extents.z));
            hitMask = 32;
        }
        if ((hitMask & dirMask) == 0) {
            return null;
        }
        Contact result = new Contact();
        result.contactPoint = cp.addLocal(cellPos).addLocal(this.center);
        result.contactNormal = normal;
        result.penetration = pen;
        return result;
    }

    public static final double checkCubeContact(double x, double y, double z, double radius, Vec3d cp, Vec3d cn, double maxPen, int dirMask, int srcInvMask, int[] resultMask) {
        double p;
        double pen = maxPen;
        int hitMask = 0;
        if (Direction.hasEast(srcInvMask) && (p = 1.0 + radius - x) > 0.0 && p < pen) {
            pen = p;
            cn.set(1.0, 0.0, 0.0);
            cp.set(1.0, CubeCollider.clamp(y, 0.0, 1.0), CubeCollider.clamp(z, 0.0, 1.0));
            hitMask = 4;
        }
        if (Direction.hasWest(srcInvMask) && (p = x + radius) > 0.0 && p < pen) {
            pen = p;
            cn.set(-1.0, 0.0, 0.0);
            cp.set(0.0, CubeCollider.clamp(y, 0.0, 1.0), CubeCollider.clamp(z, 0.0, 1.0));
            hitMask = 8;
        }
        if (Direction.hasNorth(srcInvMask) && (p = z + radius) > 0.0 && p < pen) {
            pen = p;
            cn.set(0.0, 0.0, -1.0);
            cp.set(CubeCollider.clamp(x, 0.0, 1.0), CubeCollider.clamp(y, 0.0, 1.0), 0.0);
            hitMask = 1;
        }
        if (Direction.hasSouth(srcInvMask) && (p = 1.0 + radius - z) > 0.0 && p < pen) {
            pen = p;
            cn.set(0.0, 0.0, 1.0);
            cp.set(CubeCollider.clamp(x, 0.0, 1.0), CubeCollider.clamp(y, 0.0, 1.0), 1.0);
            hitMask = 2;
        }
        if (Direction.hasUp(srcInvMask) && (p = 1.0 + radius - y) > 0.0 && p < pen) {
            pen = p;
            cn.set(0.0, 1.0, 0.0);
            cp.set(CubeCollider.clamp(x, 0.0, 1.0), 1.0, CubeCollider.clamp(z, 0.0, 1.0));
            hitMask = 16;
        }
        if (Direction.hasDown(srcInvMask) && (p = y + radius) > 0.0 && p < pen) {
            pen = p;
            cn.set(0.0, -1.0, 0.0);
            cp.set(CubeCollider.clamp(x, 0.0, 1.0), 0.0, CubeCollider.clamp(z, 0.0, 1.0));
            hitMask = 32;
        }
        resultMask[0] = hitMask;
        return pen;
    }
}

