/*
 * Decompiled with CFR 0.152.
 */
package mythruna.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import mythruna.PlayerContext;
import mythruna.es.EntityId;
import mythruna.script.ActionParameter;
import mythruna.script.ActionReference;
import mythruna.script.ScriptedAction;

public class ActionManager {
    public static final String ENTITY_ACTIONS_GROUP = "entityActions";
    private ScriptEngine engine;
    private Bindings bindings;
    private Map<String, Map<String, ScriptedAction>> actions = new LinkedHashMap<String, Map<String, ScriptedAction>>();
    private int nextId = 0;
    private Map<ScriptedAction, ActionReference> refs = new HashMap<ScriptedAction, ActionReference>();
    private Map<Integer, ScriptedAction> actionLookup = new HashMap<Integer, ScriptedAction>();

    public ActionReference addAction(ScriptedAction a) {
        ScriptedAction original = this.getGroup(a.getGroup(), true).put(a.getName(), a);
        a.setOriginal(original);
        int id = this.nextId++;
        ActionReference ref = new ActionReference(id, a.getGroup(), a.getName(), a.getType(), -1L);
        this.refs.put(a, ref);
        this.actionLookup.put(id, a);
        return ref;
    }

    public void execute(String group, String name, PlayerContext env, ActionParameter arg) {
        ScriptedAction a = this.getAction(group, name);
        if (a == null) {
            throw new RuntimeException("Action not found for " + group + ":" + name);
        }
        a.runAction(env, null, arg);
    }

    public void execute(int id, PlayerContext env, ActionParameter arg) {
        ScriptedAction a = this.getAction(id);
        if (a == null) {
            throw new RuntimeException("Action not found for " + id);
        }
        a.runAction(env, null, arg);
    }

    public void execute(String entityAction, PlayerContext env, EntityId source, ActionParameter target) {
        ScriptedAction a = this.getAction(ENTITY_ACTIONS_GROUP, entityAction);
        if (a == null) {
            throw new RuntimeException("Entity action not found for " + entityAction);
        }
        a.runAction(env, source, target);
    }

    public void execute(int id, PlayerContext env, EntityId target, ActionParameter parm) {
        ScriptedAction a = this.getAction(id);
        if (a == null) {
            throw new RuntimeException("Entity action not found for " + id);
        }
        a.runAction(env, target, parm);
    }

    public ScriptedAction getAction(int id) {
        return this.actionLookup.get(id);
    }

    public ScriptedAction getAction(String group, String name) {
        Map<String, ScriptedAction> g = this.getGroup(group, false);
        if (g == null) {
            return null;
        }
        return g.get(name);
    }

    public ActionReference getRef(ScriptedAction a) {
        if (a == null) {
            return null;
        }
        return this.refs.get(a);
    }

    public ActionReference getRef(String group, String name) {
        ScriptedAction a = this.getAction(group, name);
        if (a == null) {
            return null;
        }
        return this.refs.get(a);
    }

    public Collection<ActionReference> getRefs(String group) {
        ArrayList<ActionReference> results = new ArrayList<ActionReference>();
        Map<String, ScriptedAction> g = this.getGroup(group, false);
        if (g == null) {
            return results;
        }
        for (ScriptedAction a : g.values()) {
            results.add(this.refs.get(a));
        }
        return results;
    }

    protected Map<String, ScriptedAction> getGroup(String group, boolean create) {
        Map<String, ScriptedAction> result = this.actions.get(group);
        if (result == null && create) {
            result = new LinkedHashMap<String, ScriptedAction>();
            this.actions.put(group, result);
        }
        return result;
    }

    public static void main(String ... args) {
    }
}

