/*
 * Decompiled with CFR 0.152.
 */
package mythruna.script;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.FieldFilter;
import mythruna.script.SymbolGroup;
import org.progeeks.util.log.Log;

public class SymbolGroups {
    static Log log = Log.getLog();
    private EntityData ed;
    private boolean readOnly;
    private Map<String, List<String>> tables = new ConcurrentHashMap<String, List<String>>();

    public SymbolGroups(EntityData ed, boolean readOnly) {
        this.ed = ed;
        this.readOnly = readOnly;
    }

    protected void storeGroup(String group, List<String> list) {
        System.out.println("StringTable.storeGroup(" + group + ", " + list + ")");
        String[] array = list.toArray(new String[list.size()]);
        SymbolGroup g = new SymbolGroup(group, array);
        EntityId id = this.ed.createEntity();
        this.ed.setComponent(id, g);
    }

    protected List<String> loadTable(String group) {
        List<String> result = this.tables.get(group);
        if (result == null && this.readOnly) {
            FieldFilter<SymbolGroup> filter = new FieldFilter<SymbolGroup>(SymbolGroup.class, "name", group);
            EntityId id = this.ed.findEntity(filter, new Class[0]);
            SymbolGroup g = this.ed.getComponent(id, SymbolGroup.class);
            result = new ArrayList<String>(Arrays.asList(g.getStrings()));
            this.tables.put(group, result);
        }
        return result;
    }

    protected List<String> getTable(String group, boolean create) {
        List<String> result = this.loadTable(group);
        if (result == null && create) {
            result = new ArrayList<String>();
            this.tables.put(group, result);
        } else if (result == null) {
            log.warn((Object)("String table miss for group:" + group));
        }
        return result;
    }

    public void compile() {
        if (this.readOnly) {
            throw new RuntimeException("String table is read-only and cannot be compiled.");
        }
        for (Map.Entry<String, List<String>> e : this.tables.entrySet()) {
            this.storeGroup(e.getKey(), e.getValue());
        }
    }

    public int addString(String symbolGroup, String value) {
        List<String> table = this.getTable(symbolGroup, true);
        int index = table.size();
        table.add(value);
        System.out.println("Added string:" + symbolGroup + " -> " + value + " = " + index);
        return index;
    }

    public int getId(String symbolGroup, String value) {
        List<String> table = this.getTable(symbolGroup, false);
        return table.indexOf(value);
    }

    public String getString(String symbolGroup, int id) {
        List<String> table = this.getTable(symbolGroup, false);
        if (id < 0 || id >= table.size()) {
            throw new IndexOutOfBoundsException("Group:" + symbolGroup + "  ID:" + id);
        }
        return table.get(id);
    }
}

