/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import com.jme3.math.Vector3f;
import com.jme3.network.ConnectionListener;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.Network;
import com.jme3.network.Server;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import mythruna.BlockTypeIndex;
import mythruna.DefaultPlayerPermissions;
import mythruna.DefaultWorld;
import mythruna.GameSystems;
import mythruna.GameTime;
import mythruna.PlayerContext;
import mythruna.PlayerData;
import mythruna.PlayerPermissions;
import mythruna.Vector3i;
import mythruna.World;
import mythruna.WorldInfo;
import mythruna.db.BlueprintData;
import mythruna.db.ColumnFactory;
import mythruna.db.ColumnWorldDatabase;
import mythruna.db.DefaultBlueprintDatabase;
import mythruna.db.DefaultLeafDatabase;
import mythruna.db.DefaultLeafFileLocator;
import mythruna.db.LeafData;
import mythruna.db.RevisionedLeafDatabase;
import mythruna.db.WorldDatabase;
import mythruna.db.WorldUtils;
import mythruna.db.user.DefaultUserDatabase;
import mythruna.db.user.UserDatabase;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.Name;
import mythruna.es.UserId;
import mythruna.es.sql.SqlEntityData;
import mythruna.event.CellEvent;
import mythruna.event.EventDispatcher;
import mythruna.event.EventListener;
import mythruna.event.EventType;
import mythruna.event.PlayerEvent;
import mythruna.event.PlayerEvents;
import mythruna.msg.AccountStatusMessage;
import mythruna.msg.BlueprintDataMessage;
import mythruna.msg.ConsoleMessage;
import mythruna.msg.CreateAccountMessage;
import mythruna.msg.EntityListUpdateMessage;
import mythruna.msg.EntityStateMessage;
import mythruna.msg.GetBlueprintMessage;
import mythruna.msg.GetLeafDataMessage;
import mythruna.msg.LoginMessage;
import mythruna.msg.LoginStatusMessage;
import mythruna.msg.Messages;
import mythruna.msg.ReturnLeafDataMessage;
import mythruna.msg.RunActionMessage;
import mythruna.msg.RunNamedActionMessage;
import mythruna.msg.SetBlockMessage;
import mythruna.msg.UserStateMessage;
import mythruna.script.ActionManager;
import mythruna.script.ScriptManager;
import mythruna.server.AbstractMessageDelegator;
import mythruna.server.HostedConnectionShell;
import mythruna.server.HostedEntityData;
import mythruna.server.LeafWriter;
import mythruna.server.PlayerConnectionContext;
import mythruna.server.Scheduler;
import mythruna.server.ServerShell;
import mythruna.server.ServerStats;
import mythruna.server.StateSender;
import mythruna.server.event.ChatEvent;
import mythruna.server.event.ServerEvent;
import mythruna.server.event.ServerEvents;
import mythruna.server.event.ServerPlayerEvent;
import mythruna.sim.ChangeMobCommand;
import mythruna.sim.FrameTransition;
import mythruna.sim.GameSimulation;
import mythruna.sim.Mob;
import mythruna.sim.MobClass;
import mythruna.sim.SetBlockCommand;
import mythruna.util.LogAdapter;
import mythruna.util.ReportSystem;
import mythruna.util.Reporter;
import org.progeeks.util.log.Log;

public class GameServer {
    static Log log = Log.getLog();
    static Log statsLog = Log.getLog((String)"stats");
    static Log chatLog = Log.getLog((String)"chat");
    public static final String KEY_VERSION = "version";
    private Server server;
    private GameSystems gameSystems;
    private World world;
    private WorldDatabase worldDb;
    private EntityData ed;
    private ServerShell shell;
    private ServerStats stats;
    private UserDatabase userDb;
    private ScheduledThreadPoolExecutor leafWriterExec;
    private LeafWriter leafWriter;
    private Scheduler scheduler;
    private long startupTime;
    private GameTime gameTime;
    private EventDispatcher eventDispatcher;
    private ScriptManager scripts;
    private Map<EntityId, HostedConnection> players = new ConcurrentHashMap<EntityId, HostedConnection>();

    public GameServer(Server server, GameSystems gameSystems, UserDatabase userDb, ServerStats stats) {
        this.gameSystems = gameSystems;
        this.world = gameSystems.getWorld();
        this.worldDb = this.world.getWorldDatabase();
        this.eventDispatcher = gameSystems.getEventDispatcher();
        this.userDb = userDb;
        this.server = server;
        this.scripts = gameSystems.getScriptManager();
        this.stats = stats;
        this.ed = gameSystems.getEntityData();
        this.scheduler = new Scheduler(5);
        this.leafWriterExec = new ScheduledThreadPoolExecutor(1);
        this.leafWriter = new LeafWriter(this.worldDb);
        BlockTypeIndex.initialize();
        Messages.initialize();
        MessageObserver l = new MessageObserver();
        server.addConnectionListener((ConnectionListener)l);
        server.addMessageListener((MessageListener)l, new Class[]{LoginMessage.class, CreateAccountMessage.class});
        new LoggedInMessageHandler().register(server);
        new EntityMessageDelegator().register(server);
        this.shell = new ServerShell(this, this.worldDb);
        PlayerObserver playerObserver = new PlayerObserver();
        this.eventDispatcher.addListener(ServerEvents.playerConnected, playerObserver);
        this.eventDispatcher.addListener(ServerEvents.playerDisconnected, playerObserver);
        ReportSystem.registerCacheReporter(new MemReporter());
    }

    public WorldDatabase getWorldDatabase() {
        return this.worldDb;
    }

    public World getWorld() {
        return this.world;
    }

    public UserDatabase getUserDatabase() {
        return this.userDb;
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public ServerStats getStats() {
        return this.stats;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public Server getServer() {
        return this.server;
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public ServerShell getShell() {
        return this.shell;
    }

    public EntityId getPlayerId(int clientId) {
        HostedConnection conn = this.server.getConnection(clientId);
        return (EntityId)conn.getAttribute("entityId");
    }

    public int getClientId(EntityId playerId) {
        HostedConnection conn = this.players.get(playerId);
        if (conn == null) {
            return -1;
        }
        return conn.getId();
    }

    public void start() {
        System.out.println("Scheduling simulation task.");
        this.startupTime = System.currentTimeMillis();
        this.leafWriterExec.scheduleAtFixedRate(this.leafWriter, 10L, 1000L, TimeUnit.MILLISECONDS);
        statsLog.info((Object)"Initializing game systems.");
        this.scripts.setBinding("server", this);
        this.scripts.setBinding("eventDispatcher", this.eventDispatcher);
        this.gameSystems.start();
        this.gameTime = this.gameSystems.getGameTime();
        this.gameSystems.getSymbolGroups().compile();
        this.gameSystems.getSimulation().setEndLoopProcessor(new StateSender(this.server, this.gameTime, this.worldDb, this.gameSystems.getSimulation()));
        this.server.start();
        this.eventDispatcher.publishEvent(ServerEvents.serverStarted, new ServerEvent<GameServer>(this));
        statsLog.info((Object)"============== Server started ===================");
    }

    public void shutdown() {
        statsLog.info((Object)"Server shutting down.");
        this.eventDispatcher.publishEvent(ServerEvents.serverStopping, new ServerEvent<GameServer>(this));
        for (HostedConnection conn : this.server.getConnections()) {
            conn.close("Server is shutting down.");
        }
        this.gameSystems.shutdown();
        System.out.println("Shutting down simulation thread...");
        this.scheduler.shutdown();
        this.leafWriterExec.shutdown();
        this.server.close();
        this.ed.close();
        statsLog.info((Object)"Server shut down.");
    }

    protected String getName(HostedConnection conn) {
        String name = (String)conn.getAttribute("name");
        if (name == null) {
            name = conn.getAddress();
        }
        return name;
    }

    public void sendChat(String message) {
        this.sendChat(null, message, true);
    }

    public void sendChat(String from, String message) {
        ConsoleMessage chat = new ConsoleMessage(GameSimulation.getTime(), -1, from, message);
        this.server.broadcast(1, null, (Message)chat);
        chatLog.info((Object)(from + ":" + message));
    }

    protected void sendChat(HostedConnection source, String message, boolean showOnConsole) {
        if (source == null) {
            ConsoleMessage chat = new ConsoleMessage(GameSimulation.getTime(), -1, null, message);
            this.server.broadcast(1, null, (Message)chat);
            chatLog.info((Object)message);
        } else {
            String name = this.getName(source);
            ConsoleMessage chat = new ConsoleMessage(GameSimulation.getTime(), source.getId(), name, message);
            this.server.broadcast(1, null, (Message)chat);
            chatLog.info((Object)(name + ":" + message));
        }
    }

    protected Mob getMob(HostedConnection source, boolean create) {
        Mob e = (Mob)source.getAttribute("entity");
        if (e != null) {
            return e;
        }
        EntityId playerEntity = (EntityId)source.getAttribute("entityId");
        if (playerEntity == null) {
            return null;
        }
        return this.getMob(source, playerEntity, create);
    }

    protected Mob getMob(HostedConnection source, EntityId playerEntity, boolean create) {
        Mob e = (Mob)source.getAttribute("entity");
        if (e != null) {
            return e;
        }
        String name = (String)source.getAttribute("name");
        System.out.println("Name:" + name);
        if (name == null) {
            return null;
        }
        e = this.gameSystems.getSimulation().getEntityManager().getMob(MobClass.PLAYER, playerEntity.getId());
        System.out.println("Retrieved entity for connection:" + source + " playerEntity:" + playerEntity + "  entity:" + e);
        source.setAttribute("entity", (Object)e);
        e.setName(name);
        EntityListUpdateMessage u = new EntityListUpdateMessage(e, EntityListUpdateMessage.ADDED);
        this.server.broadcast(2, null, (Message)u);
        return e;
    }

    public static World createServerWorld(WorldInfo info, File baseDir) throws IOException {
        SqlEntityData entityData;
        int seed = info.getSeed();
        System.out.println("Loading world with seed:" + seed);
        try {
            entityData = new SqlEntityData(new File(baseDir, "entities"), 100L);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error initializing entity database in:" + baseDir, e);
        }
        DefaultLeafDatabase leafDb = new DefaultLeafDatabase(baseDir, seed);
        DefaultBlueprintDatabase bpDb = new DefaultBlueprintDatabase(new File(baseDir, "blueprints"));
        DefaultLeafFileLocator locator = new DefaultLeafFileLocator(baseDir);
        ColumnFactory colFactory = WorldUtils.createDefaultColumnFactory(locator, seed);
        ColumnWorldDatabase worldDb = new ColumnWorldDatabase(new RevisionedLeafDatabase(new File(baseDir, "revs"), leafDb), colFactory);
        DefaultWorld world = new DefaultWorld(worldDb, bpDb, entityData);
        return world;
    }

    public static void main(String ... args) throws Exception {
        Log.initialize((URL)GameServer.class.getResource("/server-log4j.xml"));
        LogAdapter.initialize();
        File baseDir = new File("mythruna.db");
        int port = 4234;
        int seed = 0;
        for (int i = 0; i < args.length; ++i) {
            if ("-p".equals(args[i]) && i < args.length - 1) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-seed".equals(args[i]) && i < args.length - 1) {
                seed = Integer.parseInt(args[++i]);
                continue;
            }
            System.out.println("Unknown option:" + args[i]);
        }
        WorldInfo info = WorldInfo.load(baseDir);
        if (info == null) {
            info = WorldInfo.create(baseDir, "Mythruna:" + seed, seed);
        } else {
            seed = info.getSeed();
        }
        World world = GameServer.createServerWorld(info, baseDir);
        DefaultUserDatabase userDb = new DefaultUserDatabase(new File(baseDir, "users"));
        GameSystems gameSystems = new GameSystems(world);
        gameSystems.getScriptManager().addStandardScripts();
        gameSystems.getScriptManager().addScript("/mythruna/server/ServerEnvironment.groovy");
        gameSystems.getScriptManager().addScript(new File("scripts"));
        gameSystems.getDialogManager().addRoot(new File("dialog"));
        gameSystems.getDialogManager().addRoot("/dialog");
        gameSystems.getDialogManager().addStartupScript("/mythruna/script/BaseDialogEnvironment.groovy");
        Server server = Network.createServer((String)"Mythruna", (int)20120627, (int)port, (int)port);
        server.addChannel(port + 1);
        server.addChannel(port + 2);
        server.addChannel(port + 3);
        ServerStats stats = new ServerStats(new File(baseDir, "stats.json"));
        GameServer game = new GameServer(server, gameSystems, userDb, stats);
        game.start();
        game.shell.run();
        game.shutdown();
    }

    private class MemReporter
    implements Reporter {
        private MemReporter() {
        }

        @Override
        public void printReport(String type, PrintWriter out) {
            out.println("GameServer->players:" + GameServer.this.players.size());
        }
    }

    protected class EntityMessageDelegator
    extends AbstractMessageDelegator<HostedConnection> {
        public EntityMessageDelegator() {
            super(HostedEntityData.class, true);
        }

        @Override
        protected Object getSourceDelegate(HostedConnection source) {
            HostedEntityData hed = (HostedEntityData)source.getAttribute("hostedEntityData");
            if (hed == null) {
                log.warn((Object)"Received entity-related message for a connection with no HostedEntityData wrapper.");
                return null;
            }
            return hed;
        }
    }

    protected class LoggedInMessageHandler
    extends AbstractMessageDelegator<HostedConnection> {
        public LoggedInMessageHandler() {
            super(LoggedInMessageHandler.class, true);
        }

        @Override
        protected Object getSourceDelegate(HostedConnection source) {
            PlayerData p = (PlayerData)source.getAttribute("player");
            if (p == null) {
                log.warn((Object)("Ignoring message for unlogged in connection:" + source));
                return null;
            }
            return this;
        }

        protected void setBlock(HostedConnection source, SetBlockMessage m) {
            PlayerData p = (PlayerData)source.getAttribute("player");
            boolean nerfed = false;
            Boolean b = (Boolean)p.get("grant.nerfed");
            if (Boolean.TRUE.equals(b)) {
                nerfed = true;
            }
            boolean rejected = false;
            if (nerfed) {
                return;
            }
            EntityId playerEntity = (EntityId)source.getAttribute("entityId");
            if (playerEntity == null) {
                rejected = true;
            }
            if (rejected) {
                Vector3i loc = m.getLocation();
                int original = GameServer.this.worldDb.getCellType(loc.x, loc.y, loc.z);
                System.out.println("old value:" + original);
                m.setType(original);
                source.send(0, (Message)m);
                return;
            }
            Vector3i loc = m.getLocation();
            int i = p.increment("stats.blocksChanged");
            System.out.println(loc + " = " + m.getType() + " blocks changed:" + i + "  player:" + GameServer.this.getName(source));
            int original = GameServer.this.worldDb.getCellType(loc.x, loc.y, loc.z);
            SetBlockCommand cmd = new SetBlockCommand(m.getTime(), loc.x, loc.y, loc.z, m.getType(), original, playerEntity, new BlockReverter(source));
            GameServer.this.gameSystems.getSimulation().addCommand(cmd);
        }

        protected void sendLeaf(HostedConnection source, GetLeafDataMessage m) {
            ReturnLeafDataMessage[] array;
            LeafData leaf = GameServer.this.worldDb.getLeaf(m.getX(), m.getY(), m.getZ());
            if (leaf == null) {
                throw new RuntimeException("No such leaf for:" + (Object)((Object)m));
            }
            if (!leaf.contains(m.getX(), m.getY(), m.getZ())) {
                throw new RuntimeException("Leaf does not contain point, maybe file is misnamed... message:" + (Object)((Object)m));
            }
            for (ReturnLeafDataMessage msg : array = ReturnLeafDataMessage.createMessages(leaf)) {
                source.send(0, (Message)msg);
            }
        }

        protected void console(HostedConnection source, ConsoleMessage m) {
            String cmd = m.getMessage();
            if (cmd.startsWith("say ")) {
                PlayerConnectionContext ctx = (PlayerConnectionContext)source.getAttribute("context");
                String s = cmd.substring("say ".length());
                ChatEvent event = new ChatEvent(ctx, s);
                GameServer.this.eventDispatcher.publishEvent(ServerEvents.playerChatted, event);
                GameServer.this.sendChat(source, event.getMessage(), true);
            } else {
                HostedConnectionShell shell = (HostedConnectionShell)source.getAttribute("shell");
                if (shell != null) {
                    statsLog.info((Object)(source + " executing:" + cmd));
                    shell.execute(cmd);
                } else {
                    System.out.println(source + " tried to run a command with a null shell.");
                }
            }
        }

        protected void updateUserState(HostedConnection source, UserStateMessage m) {
            Mob e = GameServer.this.getMob(source, true);
            if (e == null) {
                return;
            }
            GameServer.this.gameSystems.getSimulation().addCommand(new ChangeMobCommand(m.getTime(), e, m.getLocation(), m.getFacing()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runAction(HostedConnection source, RunActionMessage m) {
            ActionManager actionManager = GameServer.this.gameSystems.getActionManager();
            synchronized (actionManager) {
                PlayerConnectionContext context = (PlayerConnectionContext)source.getAttribute("context");
                if (m.getTarget() != null) {
                    GameServer.this.gameSystems.getActionManager().execute(m.getActionId(), (PlayerContext)context, m.getTarget(), m.getActionParameter());
                } else {
                    GameServer.this.gameSystems.getActionManager().execute(m.getActionId(), context, m.getActionParameter());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runNamedAction(HostedConnection source, RunNamedActionMessage m) {
            String name = m.getName();
            if (name == null) {
                name = GameServer.this.gameSystems.getSymbolGroups().getString("entityActions", m.getNameId());
            }
            ActionManager actionManager = GameServer.this.gameSystems.getActionManager();
            synchronized (actionManager) {
                PlayerConnectionContext context = (PlayerConnectionContext)source.getAttribute("context");
                GameServer.this.gameSystems.getActionManager().execute(name, (PlayerContext)context, m.getTarget(), m.getActionParameter());
            }
        }

        protected void getBlueprint(HostedConnection source, GetBlueprintMessage m) {
            BlueprintData bpData = GameServer.this.world.getBlueprint(m.getBlueprintId());
            source.send(new BlueprintDataMessage(bpData).setReliable(true));
        }
    }

    protected class BlockReverter
    implements EventListener<CellEvent> {
        private HostedConnection conn;

        public BlockReverter(HostedConnection conn) {
            this.conn = conn;
        }

        @Override
        public void newEvent(EventType<CellEvent> type, CellEvent event) {
            log.info((Object)("Need to revert to:" + event + "  for conn:" + this.conn));
            Vector3i pos = event.getCell();
            GameServer.this.gameSystems.getSimulation();
            SetBlockMessage m = new SetBlockMessage(GameSimulation.getTime(), pos.x, pos.y, pos.z, event.getNewType());
            m.setReliable(true);
            this.conn.send(0, (Message)m);
        }
    }

    private class MessageObserver
    implements MessageListener<HostedConnection>,
    ConnectionListener {
        private MessageObserver() {
        }

        public void connectionAdded(Server server, HostedConnection conn) {
            statsLog.info((Object)("connectionAdded:" + conn));
            statsLog.info((Object)(server.getConnections().size() + " connections."));
            GameServer.this.eventDispatcher.publishEvent(ServerEvents.newConnection, new ServerEvent<HostedConnection>(conn));
        }

        public void connectionRemoved(Server server, HostedConnection conn) {
            try {
                HostedEntityData hed;
                PlayerPermissions perms;
                Mob e;
                String name = GameServer.this.getName(conn);
                if (name != null) {
                    GameServer.this.sendChat(null, name + " has left.", true);
                }
                PlayerData p = (PlayerData)conn.getAttribute("player");
                EntityId playerEntity = (EntityId)conn.getAttribute("entityId");
                if (playerEntity != null) {
                    System.out.println("Cleaning up player entity state:" + playerEntity);
                    if (GameServer.this.players.remove(playerEntity) == null) {
                        log.warn((Object)("Connection not found for playerEntity:" + playerEntity));
                    }
                }
                if ((e = (Mob)conn.getAttribute("entity")) != null) {
                    System.out.println("entity:" + e);
                    if (p != null) {
                        long t = GameSimulation.getTime();
                        FrameTransition ft = e.getFrame(t);
                        Vector3f pos = ft.getPosition(t);
                        System.out.println("Saving user:" + name + " location:" + pos);
                        p.setLocation("characterInfo.lastLocation", pos);
                        long stop = System.currentTimeMillis();
                        p.set("stats.lastDisconnect", stop);
                        Long start = p.getLong("stats.lastLogin");
                        if (start != null) {
                            long total = stop - start;
                            p.set("stats.lastDuration", total);
                            p.addValue("stats.totalDuration", total);
                        }
                        p.save();
                    }
                    GameServer.this.gameSystems.getSimulation().getEntityManager().remove(e);
                    EntityListUpdateMessage u = new EntityListUpdateMessage(e, EntityListUpdateMessage.REMOVED);
                    server.broadcast((Message)u);
                    PlayerConnectionContext context = (PlayerConnectionContext)conn.getAttribute("context");
                    GameServer.this.eventDispatcher.publishEvent(PlayerEvents.playerLeft, new PlayerEvent(context));
                    GameServer.this.eventDispatcher.publishEvent(ServerEvents.playerDisconnected, new ServerPlayerEvent(context));
                }
                if ((perms = (PlayerPermissions)conn.getAttribute("perms")) != null) {
                    perms.release();
                }
                if ((hed = (HostedEntityData)conn.getAttribute("hostedEntityData")) != null) {
                    hed.close();
                }
                statsLog.info((Object)(server.getConnections().size() + " connections remaining."));
            }
            catch (RuntimeException e) {
                log.error((Object)("Error closing out connection:" + conn), (Throwable)e);
            }
        }

        protected void createAccount(HostedConnection source, CreateAccountMessage m) {
            String userId = m.getUserId();
            PlayerData p = GameServer.this.userDb.getUser(userId);
            if (p != null) {
                source.send((Message)new AccountStatusMessage(userId, false, "Choose another user ID."));
                return;
            }
            String password = m.getPassword();
            String email = m.getEmail();
            String name = m.getName();
            p = GameServer.this.userDb.createUser(userId, password);
            p.set("characterInfo.name", name);
            p.set("userInfo.email", email);
            p.save();
            source.send((Message)new AccountStatusMessage(userId, true, "Account created for:" + userId));
        }

        protected void login(HostedConnection source, LoginMessage m) {
            EntityId playerEntity;
            System.out.println("login(" + (Object)((Object)m) + ")");
            String userId = m.getUserId();
            String password = m.getPassword();
            PlayerData p = GameServer.this.userDb.getUser(m.getUserId());
            System.out.println("player:" + p);
            if (p == null || password == null || !password.equals(p.get("userInfo.password"))) {
                System.out.println("Login failed for:" + p);
                source.send((Message)new LoginStatusMessage(false, "Invalid user ID or password.", null, new Vector3f()));
                return;
            }
            source.setAttribute("player", (Object)p);
            String name = (String)p.get("characterInfo.name");
            source.setAttribute("name", (Object)name);
            source.setAttribute(GameServer.KEY_VERSION, (Object)m.getBuildVersion());
            p.set("stats.lastLogin", System.currentTimeMillis());
            p.increment("stats.timesLoggedIn");
            p.set("stats.lastAddress", source.getAddress());
            p.save();
            Vector3f lastLoc = p.getLocation("characterInfo.lastLocation");
            Long characterEntity = p.getLong("characterInfo.entityId");
            if (characterEntity == null) {
                playerEntity = GameServer.this.world.getEntityData().createEntity();
                System.out.println("Created new player character entity ID:" + playerEntity);
                p.set("characterInfo.entityId", playerEntity.getId());
            } else {
                playerEntity = new EntityId(characterEntity);
            }
            GameServer.this.ed.setComponent(playerEntity, new UserId(userId));
            GameServer.this.ed.setComponent(playerEntity, new Name(name));
            DefaultPlayerPermissions perms = new DefaultPlayerPermissions(playerEntity, GameServer.this.ed);
            source.setAttribute("perms", (Object)perms);
            HostedEntityData hed = new HostedEntityData(playerEntity, perms, source, GameServer.this.world);
            GameServer.this.players.put(playerEntity, source);
            source.setAttribute("hostedEntityData", (Object)hed);
            source.setAttribute("entityId", (Object)playerEntity);
            Mob player = GameServer.this.getMob(source, playerEntity, true);
            if (lastLoc == null) {
                lastLoc = player.getPosition(GameSimulation.getTime());
            }
            source.send((Message)new LoginStatusMessage(true, null, playerEntity, lastLoc));
            GameServer.this.sendChat(null, name + " has joined.", true);
            for (Mob e : GameServer.this.gameSystems.getSimulation().getEntityManager().mobs(MobClass.PLAYER)) {
                EntityListUpdateMessage u = new EntityListUpdateMessage(e, EntityListUpdateMessage.ADDED);
                source.send(2, (Message)u);
                long t = GameSimulation.getTime();
                FrameTransition ft = e.getFrame(t);
                if (ft == null) continue;
                EntityStateMessage s = new EntityStateMessage(t, e, ft.getPosition(t, true), ft.getRotation(t, true));
                s.setReliable(true);
                source.send(2, (Message)s);
            }
            source.setAttribute("shell", (Object)new HostedConnectionShell(GameServer.this, source));
            PlayerConnectionContext context = new PlayerConnectionContext(GameServer.this, GameServer.this.gameSystems, source);
            source.setAttribute("context", (Object)context);
            GameServer.this.eventDispatcher.publishEvent(ServerEvents.playerConnected, new ServerPlayerEvent(context));
            GameServer.this.eventDispatcher.publishEvent(PlayerEvents.playerJoined, new PlayerEvent(context));
        }

        public void messageReceived(HostedConnection source, Message m) {
            if (m instanceof LoginMessage) {
                this.login(source, (LoginMessage)m);
            } else if (m instanceof CreateAccountMessage) {
                this.createAccount(source, (CreateAccountMessage)m);
            }
        }
    }

    private class PlayerObserver
    implements EventListener<ServerPlayerEvent> {
        private PlayerObserver() {
        }

        @Override
        public void newEvent(EventType<ServerPlayerEvent> type, ServerPlayerEvent event) {
            PlayerConnectionContext context = (PlayerConnectionContext)event.getContext();
            System.out.println("player event:" + type + "  event:" + event);
            System.out.println("connection:" + context.getConnection());
            PlayerData player = (PlayerData)context.getConnection().getAttribute("player");
            if (player == null) {
                log.warn((Object)("No player for event:" + event));
                return;
            }
            HashMap<String, String> m = new HashMap<String, String>();
            String name = (String)player.get("characterInfo.name");
            m.put("characterName", name);
            m.put("userId", (String)player.get("id"));
            if (type.equals(ServerEvents.playerConnected)) {
                m.put("type", "Login");
                m.put("time", (String)player.get("stats.lastLogin"));
            } else {
                m.put("type", "Logoff");
                m.put("time", (String)player.get("stats.lastDisconnect"));
            }
            GameServer.this.stats.add("recentActivity", m, 20);
            if (type.equals(ServerEvents.playerDisconnected)) {
                HashMap modder;
                Integer changed;
                PlayerData p2;
                TreeMap<Integer, PlayerData> modders;
                Comparator<Integer> reverse;
                List l = GameServer.this.stats.getList("topModders");
                if (l.isEmpty()) {
                    System.out.println("Regenerating top modders stats list.");
                    l.clear();
                    reverse = new Comparator<Integer>(){

                        @Override
                        public int compare(Integer i1, Integer i2) {
                            return i1.compareTo(i2) * -1;
                        }
                    };
                    modders = new TreeMap<Integer, PlayerData>(reverse);
                    for (String id : GameServer.this.userDb.getUserIds()) {
                        p2 = GameServer.this.userDb.getUser(id);
                        changed = (Integer)p2.get("stats.blocksChanged");
                        if (changed == null) continue;
                        modders.put(changed, p2);
                    }
                    int count = 0;
                    for (PlayerData p2 : modders.values()) {
                        modder = new HashMap();
                        modder.put("userId", p2.get("id"));
                        modder.put("characterName", p2.get("characterInfo.name"));
                        modder.put("blocksChanged", p2.get("stats.blocksChanged"));
                        l.add(modder);
                        if (++count < 10) continue;
                        break;
                    }
                } else {
                    Integer changed2 = (Integer)player.get("stats.blocksChanged");
                    if (changed2 != null) {
                        Map changedStats;
                        Integer c;
                        for (Map entry : l) {
                            if (!name.equals(entry.get("characterName"))) continue;
                            l.remove(entry);
                            break;
                        }
                        int index = 0;
                        Iterator i$ = l.iterator();
                        while (i$.hasNext() && changed2.compareTo(c = (Integer)(changedStats = (Map)i$.next()).get("blocksChanged")) <= 0) {
                            ++index;
                        }
                        if (index < 10) {
                            HashMap<String, Object> modder2 = new HashMap<String, Object>();
                            modder2.put("userId", player.get("id"));
                            modder2.put("characterName", name);
                            modder2.put("blocksChanged", changed2);
                            GameServer.this.stats.add("topModders", index, modder2, 10, true);
                        }
                    }
                }
                if ((l = GameServer.this.stats.getList("topLoggers")).isEmpty()) {
                    System.out.println("Regenerating top loggers stats list.");
                    l.clear();
                    reverse = new Comparator<Integer>(){

                        @Override
                        public int compare(Integer i1, Integer i2) {
                            return i1.compareTo(i2) * -1;
                        }
                    };
                    modders = new TreeMap(reverse);
                    for (String id : GameServer.this.userDb.getUserIds()) {
                        p2 = GameServer.this.userDb.getUser(id);
                        changed = (Integer)p2.get("stats.totalDuration");
                        if (changed == null) continue;
                        modders.put(changed, p2);
                    }
                    int count = 0;
                    for (PlayerData p2 : modders.values()) {
                        modder = new HashMap();
                        modder.put("userId", p2.get("id"));
                        modder.put("characterName", p2.get("characterInfo.name"));
                        modder.put("totalDuration", p2.get("stats.totalDuration"));
                        l.add(modder);
                        if (++count < 10) continue;
                        break;
                    }
                } else {
                    Long online = player.getLong("stats.totalDuration");
                    if (online != null) {
                        Map entry;
                        Number time;
                        long timeVal;
                        for (Map entry2 : l) {
                            if (!name.equals(entry2.get("characterName"))) continue;
                            l.remove(entry2);
                            break;
                        }
                        int index = 0;
                        Iterator i$ = l.iterator();
                        while (i$.hasNext() && online.compareTo(timeVal = (time = (Number)(entry = (Map)i$.next()).get("totalDuration")).longValue()) <= 0) {
                            ++index;
                        }
                        if (index < 10) {
                            HashMap<String, Object> modder3 = new HashMap<String, Object>();
                            modder3.put("characterName", name);
                            modder3.put("totalDuration", online);
                            GameServer.this.stats.add("topLoggers", index, modder3, 10, true);
                        }
                    }
                }
            }
            GameServer.this.stats.save();
        }
    }
}

