/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import mythruna.PlayerPermissions;
import mythruna.World;
import mythruna.es.ChangeQueue;
import mythruna.es.Entity;
import mythruna.es.EntityAction;
import mythruna.es.EntityActionEnvironment;
import mythruna.es.EntityChange;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.ObservableEntityData;
import mythruna.es.action.MoveObjectAction;
import mythruna.msg.ComponentChangeMessage;
import mythruna.msg.EntityActionMessage;
import mythruna.msg.EntityComponentsMessage;
import mythruna.msg.EntityDataMessage;
import mythruna.msg.EntityIdsMessage;
import mythruna.msg.FindEntitiesMessage;
import mythruna.msg.FindEntityMessage;
import mythruna.msg.GetComponentsMessage;
import mythruna.msg.GetEntitySetMessage;
import mythruna.msg.ObserveChangesMessage;
import mythruna.msg.ReleaseEntitySetMessage;
import mythruna.msg.ReleaseObserveChangesMessage;
import mythruna.msg.ResetEntitySetFilterMessage;
import mythruna.server.HostedConnectionShell;
import org.progeeks.util.log.Log;

public class HostedEntityData
implements EntityActionEnvironment {
    public static final String ATTRIBUTE = "hostedEntityData";
    static Log log = Log.getLog();
    private AtomicBoolean closing = new AtomicBoolean(false);
    private EntityId playerId;
    private HostedConnection conn;
    private World world;
    private ObservableEntityData ed;
    private PlayerPermissions perms;
    private Map<Integer, EntitySet> activeSets = new ConcurrentHashMap<Integer, EntitySet>();
    private Map<Integer, ChangeQueue> activeQueues = new ConcurrentHashMap<Integer, ChangeQueue>();
    private Set<EntityChange> changeBuffer = new HashSet<EntityChange>();
    private List<EntityDataMessage.ComponentData> dataBuffer = new ArrayList<EntityDataMessage.ComponentData>();
    private int maxPerMessage = 20;

    public HostedEntityData(EntityId playerId, PlayerPermissions perms, HostedConnection conn, World world) {
        this.playerId = playerId;
        this.conn = conn;
        this.world = world;
        this.ed = (ObservableEntityData)world.getEntityData();
        this.perms = perms;
    }

    public void close() {
        this.closing.set(true);
        for (Map.Entry<Integer, EntitySet> e : this.activeSets.entrySet()) {
            try {
                EntitySet set = e.getValue();
                log.trace((Object)("close(): Releasing set for ID:" + e.getKey()));
                set.release();
            }
            catch (RuntimeException ex) {
                log.error((Object)"Error releasing entity set", (Throwable)ex);
            }
        }
        this.activeSets.clear();
        for (ChangeQueue queue : this.activeQueues.values()) {
            try {
                queue.release();
            }
            catch (RuntimeException ex) {
                log.error((Object)"Error releasing change queue", (Throwable)ex);
            }
        }
        this.activeQueues.clear();
    }

    @Override
    public EntityId getPlayer() {
        return this.playerId;
    }

    @Override
    public EntityData getEntityData() {
        return this.ed;
    }

    @Override
    public PlayerPermissions getPerms() {
        return this.perms;
    }

    @Override
    public void echo(String s) {
        HostedConnectionShell shell = (HostedConnectionShell)this.conn.getAttribute("shell");
        shell.echo(s);
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    protected void getEntitySet(HostedConnection source, GetEntitySetMessage m) {
        int setId = m.getSetId();
        EntitySet set = this.activeSets.get(setId);
        if (set != null) {
            throw new RuntimeException("Set already exists for ID:" + setId);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating set for ID:" + m.getSetId()));
        }
        set = this.ed.getEntities(m.getFilter(), m.getComponentTypes());
        this.activeSets.put(setId, set);
        if (log.isTraceEnabled()) {
            log.trace((Object)("entity set:" + set));
        }
        ArrayList<EntityDataMessage.ComponentData> data = new ArrayList<EntityDataMessage.ComponentData>();
        for (Entity e : set) {
            data.add(new EntityDataMessage.ComponentData(e));
            if (data.size() <= 20) continue;
            source.send(2, new EntityDataMessage(setId, data).setReliable(true));
            data.clear();
        }
        if (!data.isEmpty()) {
            source.send(2, new EntityDataMessage(setId, data).setReliable(true));
            data.clear();
        }
    }

    protected void sendData(int setId, List<EntityDataMessage.ComponentData> data) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("sendData(" + setId + ", size:" + data.size() + ")"));
        }
        for (int i = 0; i < data.size(); i += this.maxPerMessage) {
            int start = i;
            int end = Math.min(i + this.maxPerMessage, data.size());
            this.conn.send(2, new EntityDataMessage(setId, data.subList(start, end)).setReliable(true));
        }
    }

    protected void getComponents(HostedConnection source, GetComponentsMessage m) {
        Entity e = this.ed.getEntity(m.getEntityId(), m.getComponentTypes());
        source.send(2, new EntityComponentsMessage(m.getRequestId(), e).setReliable(true));
    }

    protected void findEntity(HostedConnection source, FindEntityMessage m) {
        EntityId id = this.ed.findEntity(m.getFilter(), new Class[0]);
        source.send(2, new EntityComponentsMessage(m.getRequestId(), id).setReliable(true));
    }

    protected void findEntities(HostedConnection source, FindEntitiesMessage m) {
        Set<EntityId> results = this.ed.findEntities(m.getFilter(), m.getTypes());
        if (results.isEmpty()) {
            log.trace((Object)"findEntities() sending empty message.");
            source.send(2, (Message)new EntityIdsMessage(m.getRequestId()));
            return;
        }
        int maxSize = 1000;
        int parts = (int)Math.ceil((double)results.size() / (double)maxSize);
        int part = 1;
        if (log.isTraceEnabled()) {
            log.trace((Object)("findEntities()  parts:" + parts));
        }
        while (!results.isEmpty()) {
            int count = Math.min(maxSize, results.size());
            long[] ids = new long[count];
            int index = 0;
            Iterator<EntityId> it = results.iterator();
            while (it.hasNext()) {
                EntityId id = it.next();
                ids[index++] = id.getId();
                it.remove();
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("findEntities()  sending part:" + part + "/" + parts));
            }
            source.send(2, (Message)new EntityIdsMessage(m.getRequestId(), ids, part, parts));
            ++part;
        }
    }

    protected void entityAction(HostedConnection source, EntityActionMessage m) {
        this.executeAction(m.getAction(), m.getTarget());
    }

    protected void resetEntitySetFilter(HostedConnection source, ResetEntitySetFilterMessage m) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Reset entity set filter:" + (Object)((Object)m)));
        }
        EntitySet set = this.activeSets.get(m.getSetId());
        set.resetFilter(m.getFilter());
    }

    protected void releaseEntitySet(HostedConnection source, ReleaseEntitySetMessage m) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Release entity set:" + (Object)((Object)m)));
        }
        EntitySet set = this.activeSets.remove(m.getSetId());
        set.release();
    }

    protected void observeChanges(HostedConnection source, ObserveChangesMessage m) {
        int queueId = m.getQueueId();
        ChangeQueue queue = this.activeQueues.get(queueId);
        if (queue != null) {
            throw new RuntimeException("Queue already exists for ID:" + queueId);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating change queue for ID:" + queueId));
        }
        queue = this.ed.getChangeQueue(m.getComponentTypes());
        this.activeQueues.put(queueId, queue);
    }

    protected void releaseObserveChanges(HostedConnection source, ReleaseObserveChangesMessage m) {
        int queueId = m.getQueueId();
        ChangeQueue queue = this.activeQueues.remove(queueId);
        if (queue == null) {
            throw new RuntimeException("No releasble queue for id:" + queueId);
        }
        queue.release();
    }

    public void messageReceived(HostedConnection source, Message m) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Received message:" + m + "  for:" + source));
        }
        throw new RuntimeException("I don't think this is used anymore since the message delegator routes directly.");
    }

    public void executeAction(EntityAction action, EntityId target) {
        if (log.isInfoEnabled() && !(action instanceof MoveObjectAction)) {
            log.info((Object)("Executing action:" + action));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Executing action:" + action));
        }
        action.runAction(this, target);
    }

    public void sendChanges() {
        if (this.closing.get()) {
            return;
        }
        this.changeBuffer.clear();
        for (Map.Entry<Integer, EntitySet> e : this.activeSets.entrySet()) {
            EntitySet set = e.getValue();
            if (!set.applyChanges(this.changeBuffer)) continue;
            this.dataBuffer.clear();
            for (Entity entity : set.getRemovedEntities()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Entity removed from set[" + e.getKey() + "]:" + entity));
                }
                this.dataBuffer.add(new EntityDataMessage.ComponentData(entity.getId(), null));
            }
            for (Entity entity : set.getAddedEntities()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Entity added to set[" + e.getKey() + "]:" + entity));
                }
                this.dataBuffer.add(new EntityDataMessage.ComponentData(entity));
            }
            this.sendData(e.getKey(), this.dataBuffer);
            set.clearChangeSets();
        }
        if (!this.changeBuffer.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Change buffer:" + this.changeBuffer));
            }
            for (EntityChange c : this.changeBuffer) {
                this.conn.send(2, new ComponentChangeMessage(c).setReliable(true));
            }
        }
        for (ChangeQueue queue : this.activeQueues.values()) {
            EntityChange c = null;
            while ((c = (EntityChange)queue.poll()) != null) {
                if (!this.changeBuffer.add(c)) continue;
                this.conn.send(2, new ComponentChangeMessage(c).setReliable(true));
            }
        }
    }
}

