/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mythruna.db.LeafChangeEvent;
import mythruna.db.LeafChangeListener;
import mythruna.db.LeafData;
import mythruna.db.WorldDatabase;

public class LeafWriter
implements Runnable {
    private Object marker = new Object();
    private WorldDatabase worldDb;
    private Map<LeafData, Object> changed = new ConcurrentHashMap<LeafData, Object>();

    public LeafWriter(WorldDatabase worldDb) {
        this.worldDb = worldDb;
        worldDb.addLeafChangeListener(new LeafObserver());
    }

    public void flush() {
        System.out.println("Storing " + this.changed.size() + " leafs.");
        Iterator<LeafData> i = this.changed.keySet().iterator();
        while (i.hasNext()) {
            LeafData leaf = i.next();
            this.worldDb.markChanged(leaf);
            i.remove();
        }
    }

    @Override
    public void run() {
        if (this.changed.isEmpty()) {
            return;
        }
        try {
            this.flush();
        }
        catch (Exception e) {
            System.out.println("Error writing leaf objects.");
            e.printStackTrace();
        }
    }

    protected class LeafObserver
    implements LeafChangeListener {
        protected LeafObserver() {
        }

        @Override
        public void leafChanged(LeafChangeEvent event) {
            LeafWriter.this.changed.put(event.getLeaf(), LeafWriter.this.marker);
        }
    }
}

