/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import java.io.File;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import mythruna.server.GameServer;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.progeeks.util.StringUtils;
import org.progeeks.util.log.Log;

public class ScriptManagerOld {
    static Log log = Log.getLog();
    private GameServer server;
    private File scriptRoot;

    public ScriptManagerOld(File scriptRoot) {
        this.scriptRoot = scriptRoot;
    }

    public void initialize(GameServer server) {
        this.server = server;
        try {
            ScriptEngineManager factory = new ScriptEngineManager();
            ScriptEngine engine = factory.getEngineByName("groovy");
            ((GroovyScriptEngineImpl)engine).getClassLoader().addClasspath(this.scriptRoot.getPath());
            File[] libs = new File(this.scriptRoot, "lib").listFiles();
            if (libs != null) {
                for (File f : libs) {
                    if (!f.getName().endsWith(".jar")) continue;
                    log.info((Object)("Adding script dependency:" + f));
                    ((GroovyScriptEngineImpl)engine).getClassLoader().addClasspath(f.getPath());
                }
            }
            Bindings bindings = engine.createBindings();
            bindings.put("bindings", (Object)bindings);
            bindings.put("server", (Object)server);
            bindings.put("eventDispatcher", (Object)server.getEventDispatcher());
            engine.setBindings(bindings, 100);
            String initScript = StringUtils.readStringResource(this.getClass(), (String)"ScriptingEnvironment.groovy");
            engine.eval(initScript);
            File[] init = this.scriptRoot.listFiles();
            if (init != null) {
                for (File f : init) {
                    if (!f.getName().endsWith(".init.groovy")) continue;
                    log.info((Object)("Executing initialization script:" + f));
                    String script = StringUtils.readFile((File)f);
                    engine.eval(script);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing script support", e);
        }
    }
}

