/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mythruna.db.WorldDatabase;
import mythruna.server.ConsoleListener;
import mythruna.server.GameServer;
import mythruna.shell.CopyCommand;
import mythruna.shell.GcCommand;
import mythruna.shell.GrantCommand;
import mythruna.shell.KickCommand;
import mythruna.shell.MemoryCommand;
import mythruna.shell.ReportCommand;
import mythruna.shell.SendMessageCommand;
import mythruna.shell.ShowThreadsCommand;
import mythruna.shell.UptimeCommand;
import mythruna.shell.WhereCommand;
import mythruna.shell.WhoCommand;
import org.progeeks.tool.console.PrintCommand;
import org.progeeks.tool.console.Shell;
import org.progeeks.tool.console.ShellCommand;

public class ServerShell
extends Shell {
    private GameServer server;
    private WorldDatabase workdDb;
    private List<ConsoleListener> listeners = new ArrayList<ConsoleListener>();

    public ServerShell(GameServer server, WorldDatabase workdDb) {
        super("mythruna");
        this.registerCommand("print", (ShellCommand)new PrintCommand());
        this.registerCommand("who", (ShellCommand)new WhoCommand(server, true));
        this.registerCommand("where", (ShellCommand)new WhereCommand(server));
        this.registerCommand("mem", (ShellCommand)new MemoryCommand());
        this.registerCommand("send", (ShellCommand)new SendMessageCommand(server));
        this.registerCommand("gc", (ShellCommand)new GcCommand());
        this.registerCommand("kick", (ShellCommand)new KickCommand(server));
        this.registerCommand("uptime", (ShellCommand)new UptimeCommand(server, false));
        this.registerCommand("threads", (ShellCommand)new ShowThreadsCommand());
        this.registerCommand("copy", (ShellCommand)new CopyCommand(server));
        this.registerCommand("report", (ShellCommand)new ReportCommand());
        this.registerCommand("grant", (ShellCommand)new GrantCommand(server));
    }

    public void chatEcho(String from, String message) {
        if (from != null) {
            this.echo("chat-" + from + ":" + message);
        } else {
            this.echo("chat:" + message);
        }
    }

    public void addConsoleListener(ConsoleListener l) {
        this.listeners.add(l);
    }

    public void removeConsoleListener(ConsoleListener l) {
        this.listeners.remove(l);
    }

    protected void notifyListeners(Object s) {
        if (!this.listeners.isEmpty()) {
            for (ConsoleListener c : this.listeners) {
                c.echo(s);
            }
        }
    }

    public void echo(Object s) {
        super.echo(s);
        this.notifyListeners(s);
    }

    public void error(Object s) {
        super.error(s);
        this.notifyListeners("ERROR: " + s);
    }

    public void commandFinished() {
        super.commandFinished();
        this.notifyListeners(": " + this.getLastStatus());
    }

    public void stop() {
        super.stop();
        try {
            System.in.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing shell", e);
        }
    }
}

