/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.Server;
import java.util.ArrayList;
import java.util.List;
import mythruna.GameTime;
import mythruna.db.CellChangeEvent;
import mythruna.db.CellChangeListener;
import mythruna.db.LeafChangeEvent;
import mythruna.db.LeafChangeListener;
import mythruna.db.LeafData;
import mythruna.db.LeafInfo;
import mythruna.db.WorldDatabase;
import mythruna.msg.EntityStateMessage;
import mythruna.msg.ResetLeafMessage;
import mythruna.msg.SetBlockMessage;
import mythruna.msg.TimeMessage;
import mythruna.server.HostedEntityData;
import mythruna.sim.GameSimulation;
import mythruna.sim.Mob;
import mythruna.sim.MobChangeListener;

public class StateSender
implements Runnable {
    private Server server;
    private GameTime gameTime;
    private WorldDatabase worldDb;
    private int frequency = 20;
    private int skip = 60 / this.frequency;
    private int count = 0;
    private List<Message> outboundBuffer = new ArrayList<Message>();
    private List<Message> sending = new ArrayList<Message>();
    private GameSimulation sim;

    public StateSender(Server server, GameTime gameTime, WorldDatabase worldDb, GameSimulation sim) {
        this.server = server;
        this.gameTime = gameTime;
        this.worldDb = worldDb;
        WorldObserver l = new WorldObserver();
        worldDb.addCellChangeListener(l);
        worldDb.addLeafChangeListener(l);
        this.sim = sim;
        sim.getEntityManager().addMobChangeListener(new EntityObserver());
    }

    protected final synchronized void addMessage(Message m) {
        this.outboundBuffer.add(m);
    }

    protected final synchronized List<Message> swap() {
        List<Message> temp = this.outboundBuffer;
        this.outboundBuffer = this.sending;
        this.sending = temp;
        this.outboundBuffer.clear();
        return this.sending;
    }

    @Override
    public void run() {
        ++this.count;
        if (this.count < this.skip) {
            return;
        }
        this.count = 0;
        if (!this.server.hasConnections()) {
            return;
        }
        TimeMessage t = new TimeMessage(GameSimulation.getTime(), this.gameTime.getTime());
        t.setReliable(false);
        this.server.broadcast((Message)t);
        List<Message> toSend = this.swap();
        for (Message m : toSend) {
            this.server.broadcast(m);
        }
        toSend.clear();
        for (HostedConnection conn : this.server.getConnections()) {
            HostedEntityData hed = (HostedEntityData)conn.getAttribute("hostedEntityData");
            if (hed == null) continue;
            hed.sendChanges();
        }
    }

    protected class EntityObserver
    implements MobChangeListener {
        protected EntityObserver() {
        }

        @Override
        public void mobChanged(Mob entity, Vector3f newPos, Quaternion rot) {
            if (newPos == null || rot == null) {
                return;
            }
            EntityStateMessage m = new EntityStateMessage(GameSimulation.getTime(), entity.getType().getRawId(), entity.getId(), newPos, rot);
            StateSender.this.addMessage((Message)m);
        }
    }

    protected class WorldObserver
    implements CellChangeListener,
    LeafChangeListener {
        protected WorldObserver() {
        }

        @Override
        public void cellChanged(CellChangeEvent event) {
            SetBlockMessage m = new SetBlockMessage(GameSimulation.getTime(), event.getX(), event.getY(), event.getZ(), event.getCellType());
            StateSender.this.addMessage((Message)m);
        }

        @Override
        public void leafChanged(LeafChangeEvent event) {
            if (event.getType() != LeafChangeEvent.ChangeType.RESET) {
                return;
            }
            LeafData leaf = event.getLeaf();
            LeafInfo info = leaf.getInfo();
            ResetLeafMessage m = new ResetLeafMessage(GameSimulation.getTime(), info.x, info.y, info.z);
            StateSender.this.addMessage((Message)m);
        }
    }
}

