/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shell;

import java.util.StringTokenizer;
import mythruna.Vector3i;
import mythruna.db.LeafData;
import mythruna.db.WorldDatabase;
import mythruna.server.GameServer;
import org.progeeks.tool.console.AbstractShellCommand;
import org.progeeks.tool.console.ShellEnvironment;

public class CopyCommand
extends AbstractShellCommand {
    public static final String DESCRIPTION = "Copies an object or data.";
    public static final String[] HELP = new String[]{"Usage: copy <type> <parameters>", "Where:", "   <type> is currently just leaf.", "", "Parameters:", " leaf: <loc1> <loc2>", "       where location is in x,y,z form and the x,y,z elements are integers."};
    private GameServer server;

    public CopyCommand(GameServer server) {
        super(DESCRIPTION, HELP);
        this.server = server;
    }

    protected Vector3i toCoordinate(ShellEnvironment sEnv, String s) {
        try {
            Vector3i result = new Vector3i();
            StringTokenizer st = new StringTokenizer(s, ", ");
            if (st.countTokens() < 3) {
                sEnv.println((Object)("Missing values in coordinate string:" + s));
                return null;
            }
            result.x = Integer.parseInt(st.nextToken());
            result.y = Integer.parseInt(st.nextToken());
            result.z = Integer.parseInt(st.nextToken());
            return result;
        }
        catch (Exception e) {
            sEnv.println((Object)("Error parsing coordinate[" + s + "]:" + e));
            return null;
        }
    }

    protected int copyLeaf(ShellEnvironment sEnv, StringTokenizer st) {
        if (!st.hasMoreTokens()) {
            sEnv.println((Object)"No paremeters specified.");
            return -3;
        }
        Vector3i loc1 = this.toCoordinate(sEnv, st.nextToken());
        if (loc1 == null) {
            return -4;
        }
        if (!st.hasMoreTokens()) {
            sEnv.println((Object)"No target location specified.");
            return -3;
        }
        Vector3i loc2 = this.toCoordinate(sEnv, st.nextToken());
        if (loc1 == null) {
            return -4;
        }
        sEnv.println((Object)("copy leaf at:" + loc1 + "  to leaf at:" + loc2));
        WorldDatabase worldDb = this.server.getWorldDatabase();
        LeafData leaf1 = worldDb.getLeaf(loc1.x, loc1.y, loc1.z);
        LeafData leaf2 = worldDb.getLeaf(loc2.x, loc2.y, loc2.z);
        sEnv.println((Object)("Source:" + leaf1 + "  target:" + leaf2));
        if (leaf2 == null) {
            sEnv.println((Object)"Target does not exist.");
            return -5;
        }
        int[][][] source = leaf1 != null ? leaf1.getCells() : (int[][][])null;
        int[][][] target = leaf2.getCells();
        if (source == null && target == null) {
            sEnv.println((Object)"Nothing to copy.");
            return 0;
        }
        if (source == null) {
            sEnv.println((Object)"Source has no data.  Clearing target.");
        }
        if (target == null) {
            target = new int[32][32][32];
            leaf2.setCells(target);
        }
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                for (int k = 0; k < 32; ++k) {
                    target[i][j][k] = source == null ? 0 : source[i][j][k];
                }
            }
        }
        leaf2.getInfo().lit = false;
        leaf2.markChanged();
        worldDb.markChanged(leaf2);
        return 0;
    }

    public int execute(ShellEnvironment sEnv, String args) {
        StringTokenizer st = new StringTokenizer(args, " ");
        if (!st.hasMoreTokens()) {
            sEnv.println((Object)"No type specified.");
            return -1;
        }
        String type = st.nextToken();
        if ("leaf".equals(type)) {
            return this.copyLeaf(sEnv, st);
        }
        sEnv.println((Object)("Unknown type:" + type));
        return -2;
    }

    public boolean isSimple() {
        return true;
    }
}

