/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shell;

import com.jme3.math.Vector3f;
import com.jme3.network.HostedConnection;
import java.util.StringTokenizer;
import mythruna.server.GameServer;
import mythruna.sim.FrameTransition;
import mythruna.sim.Mob;
import org.progeeks.tool.console.AbstractShellCommand;
import org.progeeks.tool.console.ShellEnvironment;

public class WhereCommand
extends AbstractShellCommand {
    public static final String DESCRIPTION = "Shows where players are located in the game world.";
    public static final String[] HELP = new String[]{"Usage: where [<id list>]", "Where:", "  <id list>  is an optional list of client IDs to display specific information for.", "             The list can be space and/or comma delimited.", "", "  Leaving the id off displays location information for all users."};
    private GameServer server;

    public WhereCommand(GameServer server) {
        super(DESCRIPTION, HELP);
        this.server = server;
    }

    protected String connInfo(HostedConnection conn) {
        long time;
        FrameTransition ft;
        if (conn == null) {
            return "Invalid connection.";
        }
        String name = (String)conn.getAttribute("name");
        if (name == null) {
            name = "Unknown";
        }
        String loc = "Unknown";
        Mob e = (Mob)conn.getAttribute("entity");
        if (e != null && (ft = e.getFrame(time = System.currentTimeMillis())) != null) {
            Vector3f pos = ft.getPosition(time);
            loc = String.format("%.1f, %.1f, %.1f", Float.valueOf(pos.x), Float.valueOf(pos.y), Float.valueOf(pos.z));
        }
        return "id:" + conn.getId() + "  name:" + name + "  location:" + loc;
    }

    public int execute(ShellEnvironment sEnv, String args) {
        if (args.length() > 0) {
            StringTokenizer st = new StringTokenizer(args, ", ");
            while (st.hasMoreTokens()) {
                try {
                    String t = st.nextToken();
                    int id = Integer.parseInt(t);
                    HostedConnection conn = this.server.getServer().getConnection(id);
                    sEnv.println((Object)this.connInfo(conn));
                }
                catch (Exception e) {
                    sEnv.println((Object)e);
                }
            }
        } else {
            for (HostedConnection conn : this.server.getServer().getConnections()) {
                sEnv.println((Object)this.connInfo(conn));
            }
        }
        return 0;
    }

    public boolean isSimple() {
        return true;
    }
}

