/*
 * Decompiled with CFR 0.152.
 */
package mythruna.util;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.progeeks.util.log.Log;
import org.progeeks.util.log.LogLevel;

public class LogAdapter
extends Handler {
    private Set<String> seen = new HashSet<String>();

    public static void initialize() {
        Logger root = LogManager.getLogManager().getLogger("");
        for (Handler h : root.getHandlers()) {
            root.removeHandler(h);
        }
        LogAdapter adapter = new LogAdapter();
        root.addHandler(adapter);
        Log rootLog = Log.getRootLog();
        LogLevel main = rootLog.getLogLevel();
        if (main != null) {
            System.out.println("Setting root JUL log level to:" + LogAdapter.toJUL(main));
            root.setLevel(LogAdapter.toJUL(main));
        }
        Iterator it = Log.categoryNames();
        while (it.hasNext()) {
            String s = (String)it.next();
            Log l = Log.getLog((String)s);
            LogLevel lvl = l.getLogLevel();
            if (lvl == null) continue;
            LogAdapter.setJulLevel(s, lvl);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    protected static String foldMessage(LogRecord record) {
        String msg = record.getMessage();
        Object[] parms = record.getParameters();
        if (parms != null && parms.length > 0) {
            msg = MessageFormat.format(msg, record.getParameters());
        }
        return msg;
    }

    protected static LogLevel convert(Level lvl) {
        if (lvl == Level.CONFIG) {
            return LogLevel.INFO;
        }
        if (lvl == Level.FINE) {
            return LogLevel.DEBUG;
        }
        if (lvl == Level.FINER) {
            return LogLevel.TRACE;
        }
        if (lvl == Level.FINEST) {
            return LogLevel.TRACE;
        }
        if (lvl == Level.INFO) {
            return LogLevel.INFO;
        }
        if (lvl == Level.OFF) {
            return LogLevel.OFF;
        }
        if (lvl == Level.SEVERE) {
            return LogLevel.ERROR;
        }
        if (lvl == Level.WARNING) {
            return LogLevel.WARN;
        }
        return LogLevel.INFO;
    }

    protected static Level toJUL(LogLevel lvl) {
        if (lvl == LogLevel.TRACE) {
            return Level.FINER;
        }
        if (lvl == LogLevel.DEBUG) {
            return Level.FINE;
        }
        if (lvl == LogLevel.ERROR) {
            return Level.SEVERE;
        }
        if (lvl == LogLevel.FATAL) {
            return Level.SEVERE;
        }
        if (lvl == LogLevel.INFO) {
            return Level.INFO;
        }
        if (lvl == LogLevel.OFF) {
            return Level.OFF;
        }
        if (lvl == LogLevel.WARN) {
            return Level.WARNING;
        }
        return Level.INFO;
    }

    protected static void setJulLevel(String logger, LogLevel lvl) {
        Level newLevel = LogAdapter.toJUL(lvl);
        System.out.println("Setting JUL Log:" + logger + " level to:" + newLevel);
        Logger l = Logger.getLogger(logger);
        if (l == null) {
            return;
        }
        l.setLevel(newLevel);
    }

    @Override
    public void publish(LogRecord record) {
        LogLevel current;
        String message = LogAdapter.foldMessage(record);
        String logger = record.getLoggerName();
        if (logger == null) {
            logger = "";
        }
        Level lvl = record.getLevel();
        Log log = Log.getLog((String)logger);
        LogLevel msgLevel = LogAdapter.convert(lvl);
        if (this.seen.add(logger) && !msgLevel.isGreaterOrEqual(current = log.getEffectiveLogLevel())) {
            LogAdapter.setJulLevel(logger, current);
        }
        log.log((Object)message, msgLevel, record.getThrown());
    }
}

