/*
 * Decompiled with CFR 0.152.
 */
package mythruna.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SerializationUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doWrite(Serializable o, File f, boolean zipped) throws IOException {
        ObjectOutputStream out;
        FileOutputStream fOut = new FileOutputStream(f);
        if (zipped) {
            GZIPOutputStream gOut = new GZIPOutputStream(fOut);
            BufferedOutputStream bOut = new BufferedOutputStream(gOut, 16384);
            out = new ObjectOutputStream(bOut);
        } else {
            BufferedOutputStream bOut = new BufferedOutputStream(fOut, 16384);
            out = new ObjectOutputStream(bOut);
        }
        try {
            out.writeObject(o);
        }
        finally {
            out.close();
        }
    }

    protected static Object doRead(File f, boolean zipped) throws IOException {
        Object bIn;
        ObjectInputStream in;
        FileInputStream fIn = new FileInputStream(f);
        if (zipped) {
            GZIPInputStream gIn = new GZIPInputStream(fIn);
            BufferedInputStream bIn2 = new BufferedInputStream(gIn, 16384);
            in = new ObjectInputStream(bIn2);
        } else {
            bIn = new BufferedInputStream(fIn, 16384);
            in = new ObjectInputStream((InputStream)bIn);
        }
        try {
            bIn = in.readObject();
            return bIn;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found reading:" + f, e);
        }
        finally {
            in.close();
        }
    }

    public static void writeObject(Serializable o, File f) {
        SerializationUtils.writeObject(o, f, false);
    }

    public static void writeObject(Serializable o, File f, boolean zipped) {
        try {
            SerializationUtils.doWrite(o, f, zipped);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing object to:" + f, e);
        }
    }

    public static Object readObject(File f) {
        return SerializationUtils.readObject(f, false);
    }

    public static Object readObject(File f, boolean zipped) {
        try {
            return SerializationUtils.doRead(f, zipped);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading object from:" + f, e);
        }
    }
}

