/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.map;

import org.progeeks.map.AbstractElevationGenerator;
import org.progeeks.map.ElevationData;
import org.progeeks.map.PerlinNoise;

public abstract class AbstractNoiseElevationGenerator
extends AbstractElevationGenerator {
    protected PerlinNoise noise = new PerlinNoise();
    private int frequency = 256;
    private int seed;
    private boolean additive = false;
    private boolean affected = true;

    protected AbstractNoiseElevationGenerator(String name) {
        super(name);
    }

    @Override
    public void setSeed(int seed) {
        if (this.seed == seed) {
            return;
        }
        this.seed = seed;
        this.invalidate();
    }

    public int getSeed() {
        return this.seed;
    }

    public void setFrequency(int f) {
        if (this.frequency == f) {
            return;
        }
        this.frequency = f;
        this.invalidate();
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setAdditive(boolean additive) {
        if (this.additive == additive) {
            return;
        }
        this.additive = additive;
        this.invalidate();
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public void setAffected(boolean affected) {
        if (this.affected == affected) {
            return;
        }
        this.affected = affected;
        this.invalidate();
    }

    public boolean isAffected() {
        return this.affected;
    }

    protected void reinitialize() {
    }

    public int calculateElevation(int x, int y, int z) {
        ElevationData source = this.getSourceData();
        double scale = 1.0 / (double)this.frequency;
        int sourceScale = source.getElevationScale();
        int sourceOffset = source.getElevationOffset();
        double elevationScale = this.getElevationScale();
        double elevationOffset = this.getElevationOffset();
        double tx = (double)x * scale;
        double ty = (double)y * scale;
        double tz = z;
        tz = this.affected ? (double)(z - sourceOffset) / (double)sourceScale : 0.0;
        if (!this.additive) {
            return (int)Math.round(this.getElevation(tx, ty, tz) * elevationScale + elevationOffset);
        }
        return z + (int)Math.round(this.getElevation(tx, ty, tz) * elevationScale + elevationOffset);
    }

    protected abstract double getElevation(double var1, double var3, double var5);

    @Override
    protected ElevationData generateElevations(ElevationData result) {
        ElevationData source = this.getSourceData();
        int[][] sourceMap = source.getElevations();
        int mapSize = source.getMapSize();
        if (result == null) {
            result = new ElevationData(mapSize);
        }
        result.setBaseX(source.getBaseX());
        result.setBaseY(source.getBaseY());
        int sourceScale = source.getElevationScale();
        int sourceOffset = source.getElevationOffset();
        double elevationScale = this.getElevationScale();
        double elevationOffset = this.getElevationOffset();
        int adjustedScale = sourceScale + (int)(elevationScale + elevationOffset);
        int adjustedOffset = sourceOffset - (int)elevationOffset;
        result.setElevationScale(adjustedScale);
        result.setElevationOffset(adjustedOffset);
        if (this.noise.getSeed() != this.getSeed()) {
            this.noise.setSeed(this.getSeed());
        }
        int baseX = source.getBaseX();
        int baseY = source.getBaseY();
        int[][] map = result.getElevations();
        double scale = 1.0 / (double)this.frequency;
        this.reinitialize();
        for (int x = 0; x < mapSize; ++x) {
            for (int y = 0; y < mapSize; ++y) {
                double tx = ((double)baseX + (double)x) * scale;
                double ty = ((double)baseY + (double)y) * scale;
                double tz = 0.0;
                if (this.affected) {
                    tz = (double)(sourceMap[y][x] - sourceOffset) / (double)sourceScale;
                }
                map[y][x] = !this.additive ? (int)Math.round(this.getElevation(tx, ty, tz) * elevationScale + elevationOffset) : sourceMap[y][x] + (int)Math.round(this.getElevation(tx, ty, tz) * elevationScale + elevationOffset);
            }
        }
        return result;
    }
}

