/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.map;

import java.util.Arrays;
import java.util.Random;
import org.progeeks.map.AbstractElevationGenerator;
import org.progeeks.map.ElevationData;

public class MidpointDisplacementElevations
extends AbstractElevationGenerator {
    private double roughness = 3.0;
    private int roughnessBias = 5;
    private int seed;
    private int preseedFactor = 2;
    private int drift = 4;

    public MidpointDisplacementElevations() {
        super("Midpoint Displacement");
    }

    @Override
    public void setSeed(int seed) {
        if (this.seed == seed) {
            return;
        }
        this.seed = seed;
        this.invalidate();
    }

    public int getSeed() {
        return this.seed;
    }

    public void setPreseedFrequency(int s) {
        int mapSize = this.getSourceData().getMapSize();
        int seedMax = (int)Math.round(Math.log(mapSize) / Math.log(2.0));
        if (s > seedMax) {
            s = seedMax;
        } else if (s < 0) {
            s = 0;
        }
        if (this.preseedFactor == s) {
            return;
        }
        this.preseedFactor = s;
        this.invalidate();
    }

    public int getPreseedFrequency() {
        return this.preseedFactor;
    }

    public void setRoughnessScale(double r) {
        if (this.roughness == r) {
            return;
        }
        this.roughness = r;
        this.invalidate();
    }

    public double getRoughnessScale() {
        return this.roughness;
    }

    public void setRoughnessBias(int bias) {
        if (this.roughnessBias == bias) {
            return;
        }
        this.roughnessBias = bias;
        this.invalidate();
    }

    public int getRoughnessBias() {
        return this.roughnessBias;
    }

    public void setDrift(int drift) {
        if (this.drift == drift) {
            return;
        }
        this.drift = drift;
        this.invalidate();
    }

    public int getDrift() {
        return this.drift;
    }

    protected int driftedAverage(int v1, int v2, int drift, Random rand) {
        int r;
        int count = r = rand.nextInt(drift) + 1;
        int total = v1 * r;
        r = rand.nextInt(drift) + 1;
        return (total += v2 * r) / (count += r);
    }

    protected int driftedAverage(int v1, int v2, int v3, int v4, int drift, Random rand) {
        int r;
        int count = r = rand.nextInt(drift) + 1;
        int total = v1 * r;
        r = rand.nextInt(drift) + 1;
        count += r;
        total += v2 * r;
        r = rand.nextInt(drift) + 1;
        count += r;
        total += v3 * r;
        r = rand.nextInt(drift) + 1;
        return (total += v4 * r) / (count += r);
    }

    @Override
    protected ElevationData generateElevations(ElevationData result) {
        ElevationData source = this.getSourceData();
        int[][] sourceMap = source.getElevations();
        int mapSize = source.getMapSize();
        if (result == null) {
            result = new ElevationData(mapSize);
        }
        result.setElevationScale(this.getElevationScale());
        result.setElevationOffset(this.getElevationOffset());
        int sourceScale = source.getElevationScale();
        int sourceOffset = source.getElevationOffset();
        int scale = this.getElevationScale();
        int offset = this.getElevationOffset();
        int[][] map = result.getElevations();
        Random rand = new Random(this.getSeed());
        for (int y = 0; y <= mapSize; ++y) {
            Arrays.fill(map[y], offset);
        }
        int heightRange = scale;
        int seedMax = (int)Math.round(Math.log(mapSize) / Math.log(2.0));
        int seedStep = seedMax - this.preseedFactor;
        seedStep = (int)Math.pow(2.0, seedStep);
        for (int x = 0; x <= mapSize; x += seedStep) {
            for (int y = 0; y <= mapSize; y += seedStep) {
                if (y == 0 || x == 0 || x == mapSize || y == mapSize) continue;
                map[y][x] = sourceMap[y][x] != 0 ? sourceMap[y][x] : offset + rand.nextInt(scale);
            }
        }
        double cos45 = Math.cos(Math.toRadians(45.0));
        int step = seedStep;
        double displacement = (double)(scale / 2) * this.roughness;
        double count = Math.log(step) / Math.log(2.0);
        double displacementStep = Math.exp(Math.log(displacement) / (count += (double)this.roughnessBias));
        boolean doElevFactor = false;
        while (step > 1) {
            int halfStep = step / 2;
            int disp = (int)displacement;
            int halfDisp = disp / 2;
            for (int x = 0; x < mapSize; x += step) {
                for (int y = 0; y < mapSize; y += step) {
                    int nw = map[y][x];
                    int ne = map[y][x + step];
                    int sw = map[y + step][x];
                    int se = map[y + step][x + step];
                    int w = map[y + halfStep][x];
                    int n = map[y][x + halfStep];
                    int average = this.driftedAverage(ne, se, this.drift, rand);
                    int rise = disp > 0 ? rand.nextInt(disp) - halfDisp : 0;
                    int e = average + rise;
                    average = this.driftedAverage(sw, se, this.drift, rand);
                    rise = disp > 0 ? rand.nextInt(disp) - halfDisp : 0;
                    int s = average + rise;
                    average = this.driftedAverage(n, s, e, w, this.drift, rand);
                    rise = disp > 0 ? rand.nextInt(disp) - halfDisp : 0;
                    int center = average + rise;
                    map[y + step][x + halfStep] = s;
                    map[y + halfStep][x + step] = e;
                    map[y + halfStep][x + halfStep] = center;
                }
            }
            step = halfStep;
            displacement /= displacementStep;
        }
        return result;
    }
}

