/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.cmd.swing;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.progeeks.cmd.Command;
import org.progeeks.cmd.CommandProcessor;
import org.progeeks.cmd.Environment;
import org.progeeks.cmd.Result;
import org.progeeks.cmd.swing.ViewCommand;

public class SwingCommandProcessor
implements CommandProcessor,
Environment {
    public Result execute(Command cmd) {
        return this.execute(cmd, true);
    }

    public Result execute(Command cmd, boolean wait) {
        if (cmd instanceof ViewCommand) {
            return this.executeViewCommand((ViewCommand)cmd, wait);
        }
        return cmd.execute(this);
    }

    protected Result executeViewCommand(ViewCommand cmd, boolean wait) {
        if (cmd.isForeground()) {
            if (!wait) {
                CommandRunnable cmdRun = new CommandRunnable(cmd, this, false);
                SwingUtilities.invokeLater(cmdRun);
                return null;
            }
            if (EventQueue.isDispatchThread()) {
                return cmd.execute(this);
            }
            CommandRunnable cmdRun = new CommandRunnable(cmd, this, true);
            try {
                SwingUtilities.invokeAndWait(cmdRun);
                if (cmdRun.error != null) {
                    throw cmdRun.error;
                }
                if (cmdRun.exception != null) {
                    throw cmdRun.exception;
                }
                return cmdRun.result;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error running command", e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Command execution interrupted", e);
            }
        }
        if (wait) {
            return cmd.execute(this);
        }
        CommandRunnable cmdRun = new CommandRunnable(cmd, this, false);
        Thread t = new Thread(cmdRun);
        t.start();
        return null;
    }

    private static class CommandRunnable
    implements Runnable {
        private Error error;
        private RuntimeException exception;
        private boolean saveExceptions;
        private Result result;
        private ViewCommand cmd;
        private Environment env;

        public CommandRunnable(ViewCommand cmd, Environment env, boolean saveExceptions) {
            this.cmd = cmd;
            this.env = env;
            this.saveExceptions = saveExceptions;
        }

        public void run() {
            try {
                this.result = this.cmd.execute(this.env);
            }
            catch (Error e) {
                if (this.saveExceptions) {
                    this.error = e;
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (this.saveExceptions) {
                    this.exception = e;
                }
                throw e;
            }
        }
    }
}

