/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shadow;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.math.Matrix4f;
import com.jme3.math.Transform;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.scene.Geometry;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadowUtil {
    public static void updateFrustumPoints2(Camera viewCam, Vector3f[] points) {
        int w = viewCam.getWidth();
        int h = viewCam.getHeight();
        float n = viewCam.getFrustumNear();
        float f = viewCam.getFrustumFar();
        points[0].set(viewCam.getWorldCoordinates(new Vector2f(0.0f, 0.0f), n));
        points[1].set(viewCam.getWorldCoordinates(new Vector2f(0.0f, h), n));
        points[2].set(viewCam.getWorldCoordinates(new Vector2f(w, h), n));
        points[3].set(viewCam.getWorldCoordinates(new Vector2f(w, 0.0f), n));
        points[4].set(viewCam.getWorldCoordinates(new Vector2f(0.0f, 0.0f), f));
        points[5].set(viewCam.getWorldCoordinates(new Vector2f(0.0f, h), f));
        points[6].set(viewCam.getWorldCoordinates(new Vector2f(w, h), f));
        points[7].set(viewCam.getWorldCoordinates(new Vector2f(w, 0.0f), f));
    }

    public static void updateFrustumPoints(Camera viewCam, float nearOverride, float farOverride, float scale, Vector3f[] points) {
        float far_width;
        float far_height;
        float near_width;
        float near_height;
        Vector3f pos = viewCam.getLocation();
        Vector3f dir = viewCam.getDirection();
        Vector3f up = viewCam.getUp();
        float depthHeightRatio = viewCam.getFrustumTop() / viewCam.getFrustumNear();
        float near = nearOverride;
        float far = farOverride;
        float ftop = viewCam.getFrustumTop();
        float fright = viewCam.getFrustumRight();
        float ratio = fright / ftop;
        if (viewCam.isParallelProjection()) {
            near_height = ftop;
            near_width = near_height * ratio;
            far_height = ftop;
            far_width = far_height * ratio;
        } else {
            near_height = depthHeightRatio * near;
            near_width = near_height * ratio;
            far_height = depthHeightRatio * far;
            far_width = far_height * ratio;
        }
        Vector3f right = dir.cross(up).normalizeLocal();
        Vector3f temp = new Vector3f();
        temp.set(dir).multLocal(far).addLocal(pos);
        Vector3f farCenter = temp.clone();
        temp.set(dir).multLocal(near).addLocal(pos);
        Vector3f nearCenter = temp.clone();
        Vector3f nearUp = temp.set(up).multLocal(near_height).clone();
        Vector3f farUp = temp.set(up).multLocal(far_height).clone();
        Vector3f nearRight = temp.set(right).multLocal(near_width).clone();
        Vector3f farRight = temp.set(right).multLocal(far_width).clone();
        points[0].set(nearCenter).subtractLocal(nearUp).subtractLocal(nearRight);
        points[1].set(nearCenter).addLocal(nearUp).subtractLocal(nearRight);
        points[2].set(nearCenter).addLocal(nearUp).addLocal(nearRight);
        points[3].set(nearCenter).subtractLocal(nearUp).addLocal(nearRight);
        points[4].set(farCenter).subtractLocal(farUp).subtractLocal(farRight);
        points[5].set(farCenter).addLocal(farUp).subtractLocal(farRight);
        points[6].set(farCenter).addLocal(farUp).addLocal(farRight);
        points[7].set(farCenter).subtractLocal(farUp).addLocal(farRight);
        if (scale != 1.0f) {
            Vector3f center = new Vector3f();
            for (int i = 0; i < 8; ++i) {
                center.addLocal(points[i]);
            }
            center.divideLocal(8.0f);
            Vector3f cDir = new Vector3f();
            for (int i = 0; i < 8; ++i) {
                cDir.set(points[i]).subtractLocal(center);
                cDir.multLocal(scale - 1.0f);
                points[i].addLocal(cDir);
            }
        }
    }

    public static BoundingBox computeUnionBound(GeometryList list, Transform transform) {
        BoundingBox bbox = new BoundingBox();
        for (int i = 0; i < list.size(); ++i) {
            BoundingVolume vol = list.get(i).getWorldBound();
            BoundingVolume newVol = vol.transform(transform);
            if (Float.isNaN(newVol.getCenter().x) || Float.isInfinite(newVol.getCenter().x)) continue;
            bbox.mergeLocal(newVol);
        }
        return bbox;
    }

    public static BoundingBox computeUnionBound(GeometryList list, Matrix4f mat) {
        BoundingBox bbox = new BoundingBox();
        BoundingVolume store = null;
        for (int i = 0; i < list.size(); ++i) {
            BoundingVolume vol = list.get(i).getWorldBound();
            store = vol.clone().transform(mat, null);
            if (Float.isNaN(store.getCenter().x) || Float.isInfinite(store.getCenter().x)) continue;
            bbox.mergeLocal(store);
        }
        return bbox;
    }

    public static BoundingBox computeUnionBound(List<BoundingVolume> bv) {
        BoundingBox bbox = new BoundingBox();
        for (int i = 0; i < bv.size(); ++i) {
            BoundingVolume vol = bv.get(i);
            bbox.mergeLocal(vol);
        }
        return bbox;
    }

    public static BoundingBox computeBoundForPoints(Vector3f[] pts, Transform transform) {
        Vector3f min = new Vector3f(Vector3f.POSITIVE_INFINITY);
        Vector3f max = new Vector3f(Vector3f.NEGATIVE_INFINITY);
        Vector3f temp = new Vector3f();
        for (int i = 0; i < pts.length; ++i) {
            transform.transformVector(pts[i], temp);
            min.minLocal(temp);
            max.maxLocal(temp);
        }
        Vector3f center = min.add(max).multLocal(0.5f);
        Vector3f extent = max.subtract(min).multLocal(0.5f);
        return new BoundingBox(center, extent.x, extent.y, extent.z);
    }

    public static BoundingBox computeBoundForPoints(Vector3f[] pts, Matrix4f mat) {
        Vector3f min = new Vector3f(Vector3f.POSITIVE_INFINITY);
        Vector3f max = new Vector3f(Vector3f.NEGATIVE_INFINITY);
        Vector3f temp = new Vector3f();
        for (int i = 0; i < pts.length; ++i) {
            float w = mat.multProj(pts[i], temp);
            temp.x /= w;
            temp.y /= w;
            temp.z /= w;
            min.minLocal(temp);
            max.maxLocal(temp);
        }
        Vector3f center = min.add(max).multLocal(0.5f);
        Vector3f extent = max.subtract(min).multLocal(0.5f);
        return new BoundingBox(center, extent.x + 2.0f, extent.y + 2.0f, extent.z + 2.5f);
    }

    public static void updateShadowCamera(Camera shadowCam, Vector3f[] points) {
        boolean ortho = shadowCam.isParallelProjection();
        shadowCam.setProjectionMatrix(null);
        if (ortho) {
            shadowCam.setFrustum(-1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f);
        } else {
            shadowCam.setFrustumPerspective(45.0f, 1.0f, 1.0f, 150.0f);
        }
        Matrix4f viewProjMatrix = shadowCam.getViewProjectionMatrix();
        Matrix4f projMatrix = shadowCam.getProjectionMatrix();
        BoundingBox splitBB = ShadowUtil.computeBoundForPoints(points, viewProjMatrix);
        Vector3f splitMin = splitBB.getMin(null);
        Vector3f splitMax = splitBB.getMax(null);
        float scaleX = 2.0f / (splitMax.x - splitMin.x);
        float scaleY = 2.0f / (splitMax.y - splitMin.y);
        float offsetX = -0.5f * (splitMax.x + splitMin.x) * scaleX;
        float offsetY = -0.5f * (splitMax.y + splitMin.y) * scaleY;
        float scaleZ = 1.0f / (splitMax.z - splitMin.z);
        float offsetZ = -splitMin.z * scaleZ;
        Matrix4f cropMatrix = new Matrix4f(scaleX, 0.0f, 0.0f, offsetX, 0.0f, scaleY, 0.0f, offsetY, 0.0f, 0.0f, scaleZ, offsetZ, 0.0f, 0.0f, 0.0f, 1.0f);
        Matrix4f result = new Matrix4f();
        result.set(cropMatrix);
        result.multLocal(projMatrix);
        shadowCam.setProjectionMatrix(result);
    }

    public static void updateShadowCamera(GeometryList occluders, GeometryList receivers, Camera shadowCam, Vector3f[] points) {
        ShadowUtil.updateShadowCamera(occluders, receivers, shadowCam, points, null);
    }

    public static void updateShadowCamera(GeometryList occluders, GeometryList receivers, Camera shadowCam, Vector3f[] points, GeometryList splitOccluders) {
        boolean ortho = shadowCam.isParallelProjection();
        shadowCam.setProjectionMatrix(null);
        if (ortho) {
            shadowCam.setFrustum(-1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f);
        } else {
            shadowCam.setFrustumPerspective(45.0f, 1.0f, 1.0f, 150.0f);
        }
        Matrix4f viewProjMatrix = shadowCam.getViewProjectionMatrix();
        BoundingBox splitBB = ShadowUtil.computeBoundForPoints(points, viewProjMatrix);
        ArrayList<BoundingVolume> visRecvList = new ArrayList<BoundingVolume>();
        for (int i = 0; i < receivers.size(); ++i) {
            Geometry receiver = receivers.get(i);
            BoundingVolume bv = receiver.getWorldBound();
            BoundingVolume recvBox = bv.transform(viewProjMatrix, null);
            if (!splitBB.intersects(recvBox)) continue;
            visRecvList.add(recvBox);
        }
        ArrayList<BoundingVolume> visOccList = new ArrayList<BoundingVolume>();
        for (int i = 0; i < occluders.size(); ++i) {
            Geometry occluder = occluders.get(i);
            BoundingVolume bv = occluder.getWorldBound();
            BoundingVolume occBox = bv.transform(viewProjMatrix, null);
            boolean intersects = splitBB.intersects(occBox);
            if (!intersects && occBox instanceof BoundingBox) {
                BoundingBox occBB = (BoundingBox)occBox;
                occBB.setZExtent(occBB.getZExtent() + 50.0f);
                occBB.setCenter(occBB.getCenter().addLocal(0.0f, 0.0f, 25.0f));
                if (!splitBB.intersects(occBB)) continue;
                occBB.setZExtent(occBB.getZExtent() - 50.0f);
                occBB.setCenter(occBB.getCenter().subtractLocal(0.0f, 0.0f, 25.0f));
                visOccList.add(occBox);
                if (splitOccluders == null) continue;
                splitOccluders.add(occluder);
                continue;
            }
            if (!intersects) continue;
            visOccList.add(occBox);
            if (splitOccluders == null) continue;
            splitOccluders.add(occluder);
        }
        BoundingBox casterBB = ShadowUtil.computeUnionBound(visOccList);
        BoundingBox receiverBB = ShadowUtil.computeUnionBound(visRecvList);
        if (visOccList.size() != visRecvList.size()) {
            casterBB.setXExtent(casterBB.getXExtent() + 2.0f);
            casterBB.setYExtent(casterBB.getYExtent() + 2.0f);
            casterBB.setZExtent(casterBB.getZExtent() + 2.0f);
        }
        Vector3f casterMin = casterBB.getMin(null);
        Vector3f casterMax = casterBB.getMax(null);
        Vector3f receiverMin = receiverBB.getMin(null);
        Vector3f receiverMax = receiverBB.getMax(null);
        Vector3f splitMin = splitBB.getMin(null);
        Vector3f splitMax = splitBB.getMax(null);
        splitMin.z = 0.0f;
        if (!ortho) {
            shadowCam.setFrustumPerspective(45.0f, 1.0f, 1.0f, splitMax.z);
        }
        Matrix4f projMatrix = shadowCam.getProjectionMatrix();
        Vector3f cropMin = new Vector3f();
        Vector3f cropMax = new Vector3f();
        cropMin.x = Math.max(Math.max(casterMin.x, receiverMin.x), splitMin.x);
        cropMax.x = Math.min(Math.min(casterMax.x, receiverMax.x), splitMax.x);
        cropMin.y = Math.max(Math.max(casterMin.y, receiverMin.y), splitMin.y);
        cropMax.y = Math.min(Math.min(casterMax.y, receiverMax.y), splitMax.y);
        cropMin.z = Math.min(casterMin.z, splitMin.z);
        cropMax.z = Math.min(receiverMax.z, splitMax.z);
        float scaleX = 2.0f / (cropMax.x - cropMin.x);
        float scaleY = 2.0f / (cropMax.y - cropMin.y);
        float offsetX = -0.5f * (cropMax.x + cropMin.x) * scaleX;
        float offsetY = -0.5f * (cropMax.y + cropMin.y) * scaleY;
        float scaleZ = 1.0f / (cropMax.z - cropMin.z);
        float offsetZ = -cropMin.z * scaleZ;
        Matrix4f cropMatrix = new Matrix4f(scaleX, 0.0f, 0.0f, offsetX, 0.0f, scaleY, 0.0f, offsetY, 0.0f, 0.0f, scaleZ, offsetZ, 0.0f, 0.0f, 0.0f, 1.0f);
        Matrix4f result = new Matrix4f();
        result.set(cropMatrix);
        result.multLocal(projMatrix);
        shadowCam.setProjectionMatrix(result);
    }
}

