/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.input.SoftTextDialogInput;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystemDelegate;
import com.jme3.system.Platform;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmeSystem {
    private static JmeSystemDelegate systemDelegate;

    public static void setSystemDelegate(JmeSystemDelegate systemDelegate) {
        JmeSystem.systemDelegate = systemDelegate;
    }

    public static synchronized File getStorageFolder() {
        JmeSystem.checkDelegate();
        return systemDelegate.getStorageFolder();
    }

    public static String getFullName() {
        JmeSystem.checkDelegate();
        return systemDelegate.getFullName();
    }

    public static InputStream getResourceAsStream(String name) {
        JmeSystem.checkDelegate();
        return systemDelegate.getResourceAsStream(name);
    }

    public static URL getResource(String name) {
        JmeSystem.checkDelegate();
        return systemDelegate.getResource(name);
    }

    public static boolean trackDirectMemory() {
        JmeSystem.checkDelegate();
        return systemDelegate.trackDirectMemory();
    }

    public static void setLowPermissions(boolean lowPerm) {
        JmeSystem.checkDelegate();
        systemDelegate.setLowPermissions(lowPerm);
    }

    public static boolean isLowPermissions() {
        JmeSystem.checkDelegate();
        return systemDelegate.isLowPermissions();
    }

    public static void setSoftTextDialogInput(SoftTextDialogInput input) {
        JmeSystem.checkDelegate();
        systemDelegate.setSoftTextDialogInput(input);
    }

    public static SoftTextDialogInput getSoftTextDialogInput() {
        JmeSystem.checkDelegate();
        return systemDelegate.getSoftTextDialogInput();
    }

    public static AssetManager newAssetManager(URL configFile) {
        JmeSystem.checkDelegate();
        return systemDelegate.newAssetManager(configFile);
    }

    public static AssetManager newAssetManager() {
        JmeSystem.checkDelegate();
        return systemDelegate.newAssetManager();
    }

    public static boolean showSettingsDialog(AppSettings sourceSettings, boolean loadFromRegistry) {
        JmeSystem.checkDelegate();
        return systemDelegate.showSettingsDialog(sourceSettings, loadFromRegistry);
    }

    public static Platform getPlatform() {
        JmeSystem.checkDelegate();
        return systemDelegate.getPlatform();
    }

    public static JmeContext newContext(AppSettings settings, JmeContext.Type contextType) {
        JmeSystem.checkDelegate();
        return systemDelegate.newContext(settings, contextType);
    }

    public static AudioRenderer newAudioRenderer(AppSettings settings) {
        JmeSystem.checkDelegate();
        return systemDelegate.newAudioRenderer(settings);
    }

    public static void initialize(AppSettings settings) {
        JmeSystem.checkDelegate();
        systemDelegate.initialize(settings);
    }

    private static void checkDelegate() {
        if (systemDelegate == null) {
            try {
                Class<?> systemDelegateClass = Class.forName("com.jme3.system.JmeDesktopSystem");
                systemDelegate = (JmeSystemDelegate)systemDelegateClass.newInstance();
            }
            catch (InstantiationException ex) {
                Logger.getLogger(JmeSystem.class.getName()).log(Level.SEVERE, "No JmeSystemDelegate specified, cannot instantiate default JmeDesktopSystem:\n{0}", ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(JmeSystem.class.getName()).log(Level.SEVERE, "No JmeSystemDelegate specified, cannot instantiate default JmeDesktopSystem:\n{0}", ex);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(JmeSystem.class.getName()).log(Level.SEVERE, "No JmeSystemDelegate specified, cannot instantiate default JmeDesktopSystem:\n{0}", ex);
            }
        }
    }
}

