/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.optimize;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.material.MatParamTexture;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3tools.optimize.GeometryBatchFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextureAtlas {
    private static final Logger logger = Logger.getLogger(TextureAtlas.class.getName());
    private Map<String, byte[]> images;
    private int atlasWidth;
    private int atlasHeight;
    private Image.Format format = Image.Format.ABGR8;
    private Node root;
    private Map<String, TextureAtlasTile> locationMap;
    private Map<String, String> mapNameMap;
    private String rootMapName;

    public TextureAtlas(int width, int height) {
        this.atlasWidth = width;
        this.atlasHeight = height;
        this.root = new Node(0, 0, width, height);
        this.locationMap = new TreeMap<String, TextureAtlasTile>();
        this.mapNameMap = new HashMap<String, String>();
    }

    public boolean addGeometry(Geometry geometry) {
        Texture diffuse = TextureAtlas.getMaterialTexture(geometry, "DiffuseMap");
        Texture normal = TextureAtlas.getMaterialTexture(geometry, "NormalMap");
        Texture specular = TextureAtlas.getMaterialTexture(geometry, "SpecularMap");
        if (diffuse == null) {
            diffuse = TextureAtlas.getMaterialTexture(geometry, "ColorMap");
        }
        if (diffuse != null && diffuse.getKey() != null) {
            String keyName = diffuse.getKey().toString();
            if (!this.addTexture(diffuse, "DiffuseMap")) {
                return false;
            }
            if (normal != null && normal.getKey() != null) {
                this.addTexture(diffuse, "NormalMap", keyName);
            }
            if (specular != null && specular.getKey() != null) {
                this.addTexture(specular, "SpecularMap", keyName);
            }
            return true;
        }
        return true;
    }

    public boolean addTexture(Texture texture, String mapName) {
        if (texture == null) {
            throw new IllegalStateException("Texture cannot be null!");
        }
        String name = this.textureName(texture);
        if (texture.getImage() != null && name != null) {
            return this.addImage(texture.getImage(), name, mapName, null);
        }
        throw new IllegalStateException("Texture has no asset key name!");
    }

    public void addTexture(Texture texture, String mapName, Texture masterTexture) {
        String sourceTextureName = this.textureName(masterTexture);
        if (sourceTextureName == null) {
            throw new IllegalStateException("Supplied master map texture has no asset key name!");
        }
        this.addTexture(texture, mapName, sourceTextureName);
    }

    public void addTexture(Texture texture, String mapName, String sourceTextureName) {
        if (texture == null) {
            throw new IllegalStateException("Texture cannot be null!");
        }
        String name = this.textureName(texture);
        if (texture.getImage() == null || name == null) {
            throw new IllegalStateException("Texture has no asset key name!");
        }
        this.addImage(texture.getImage(), name, mapName, sourceTextureName);
    }

    private String textureName(Texture texture) {
        if (texture == null) {
            return null;
        }
        AssetKey key = texture.getKey();
        if (key != null) {
            return key.toString();
        }
        return null;
    }

    private boolean addImage(Image image, String name, String mapName, String sourceTextureName) {
        if (this.rootMapName == null) {
            this.rootMapName = mapName;
        }
        if (sourceTextureName == null && !this.rootMapName.equals(mapName)) {
            throw new IllegalStateException("Atlas already has a master map called " + this.rootMapName + "." + " Textures for new maps have to use a texture from the master map for their location.");
        }
        TextureAtlasTile location = this.locationMap.get(name);
        if (location != null) {
            if (!mapName.equals(this.mapNameMap.get(name))) {
                logger.log(Level.WARNING, "Same texture " + name + " is used in different maps! (" + mapName + " and " + this.mapNameMap.get(name) + "). Location will be based on location in " + this.mapNameMap.get(name) + "!");
                this.drawImage(image, location.getX(), location.getY(), mapName);
                return true;
            }
            return true;
        }
        if (sourceTextureName == null) {
            Node node = this.root.insert(image);
            if (node == null) {
                return false;
            }
            location = node.location;
        } else {
            location = this.locationMap.get(sourceTextureName);
            if (location == null) {
                throw new IllegalStateException("Cannot find master map texture for " + name + ".");
            }
            if (location.width != image.getWidth() || location.height != image.getHeight()) {
                throw new IllegalStateException(mapName + " " + name + " does not fit " + this.rootMapName + " tile size. Make sure all textures (diffuse, normal, specular) for one model are the same size.");
            }
        }
        this.mapNameMap.put(name, mapName);
        this.locationMap.put(name, location);
        this.drawImage(image, location.getX(), location.getY(), mapName);
        return true;
    }

    private void drawImage(Image source, int x, int y, String mapName) {
        byte[] image;
        if (this.images == null) {
            this.images = new HashMap<String, byte[]>();
        }
        if ((image = this.images.get(mapName)) == null) {
            image = new byte[this.atlasWidth * this.atlasHeight * 4];
            this.images.put(mapName, image);
        }
        ByteBuffer sourceData = source.getData(0);
        int height = source.getHeight();
        int width = source.getWidth();
        Image newImage = null;
        for (int yPos = 0; yPos < height; ++yPos) {
            for (int xPos = 0; xPos < width; ++xPos) {
                int j;
                int i = (xPos + x + (yPos + y) * this.atlasWidth) * 4;
                if (source.getFormat() == Image.Format.ABGR8) {
                    j = (xPos + yPos * width) * 4;
                    image[i] = sourceData.get(j);
                    image[i + 1] = sourceData.get(j + 1);
                    image[i + 2] = sourceData.get(j + 2);
                    image[i + 3] = sourceData.get(j + 3);
                    continue;
                }
                if (source.getFormat() == Image.Format.BGR8) {
                    j = (xPos + yPos * width) * 3;
                    image[i] = 1;
                    image[i + 1] = sourceData.get(j);
                    image[i + 2] = sourceData.get(j + 1);
                    image[i + 3] = sourceData.get(j + 2);
                    continue;
                }
                if (source.getFormat() == Image.Format.RGB8) {
                    j = (xPos + yPos * width) * 3;
                    image[i] = 1;
                    image[i + 1] = sourceData.get(j + 2);
                    image[i + 2] = sourceData.get(j + 1);
                    image[i + 3] = sourceData.get(j);
                    continue;
                }
                if (source.getFormat() == Image.Format.RGBA8) {
                    j = (xPos + yPos * width) * 4;
                    image[i] = sourceData.get(j + 3);
                    image[i + 1] = sourceData.get(j + 2);
                    image[i + 2] = sourceData.get(j + 1);
                    image[i + 3] = sourceData.get(j);
                    continue;
                }
                if (source.getFormat() == Image.Format.Luminance8) {
                    j = (xPos + yPos * width) * 1;
                    image[i] = 1;
                    image[i + 1] = sourceData.get(j);
                    image[i + 2] = sourceData.get(j);
                    image[i + 3] = sourceData.get(j);
                    continue;
                }
                if (source.getFormat() == Image.Format.Luminance8Alpha8) {
                    j = (xPos + yPos * width) * 2;
                    image[i] = sourceData.get(j + 1);
                    image[i + 1] = sourceData.get(j);
                    image[i + 2] = sourceData.get(j);
                    image[i + 3] = sourceData.get(j);
                    continue;
                }
                if (newImage == null) {
                    newImage = this.convertImageToAwt(source);
                    if (newImage != null) {
                        source = newImage;
                        sourceData = source.getData(0);
                        j = (xPos + yPos * width) * 4;
                        image[i] = sourceData.get(j);
                        image[i + 1] = sourceData.get(j + 1);
                        image[i + 2] = sourceData.get(j + 2);
                        image[i + 3] = sourceData.get(j + 3);
                        continue;
                    }
                    throw new UnsupportedOperationException("Cannot draw or convert textures with format " + (Object)((Object)source.getFormat()));
                }
                throw new UnsupportedOperationException("Cannot draw textures with format " + (Object)((Object)source.getFormat()));
            }
        }
    }

    private Image convertImageToAwt(Image source) {
        try {
            Class<?> clazz = Class.forName("jme3tools.converters.ImageToAwt");
            if (clazz == null) {
                return null;
            }
            Image newImage = new Image(this.format, source.getWidth(), source.getHeight(), BufferUtils.createByteBuffer(source.getWidth() * source.getHeight() * 4));
            clazz.getMethod("convert", Image.class, Image.class).invoke(clazz.newInstance(), source, newImage);
            return newImage;
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (IllegalArgumentException ex) {
        }
        catch (InvocationTargetException ex) {
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public TextureAtlasTile getAtlasTile(Texture texture) {
        String sourceTextureName = this.textureName(texture);
        if (sourceTextureName != null) {
            return this.getAtlasTile(sourceTextureName);
        }
        return null;
    }

    private TextureAtlasTile getAtlasTile(String assetName) {
        return this.locationMap.get(assetName);
    }

    public Texture getAtlasTexture(String mapName) {
        if (this.images == null) {
            return null;
        }
        byte[] image = this.images.get(mapName);
        if (image != null) {
            Texture2D tex = new Texture2D(new Image(this.format, this.atlasWidth, this.atlasHeight, BufferUtils.createByteBuffer(image)));
            tex.setMagFilter(Texture.MagFilter.Bilinear);
            tex.setMinFilter(Texture.MinFilter.BilinearNearestMipMap);
            tex.setWrap(Texture.WrapMode.Clamp);
            return tex;
        }
        return null;
    }

    public boolean applyCoords(Geometry geom) {
        return this.applyCoords(geom, 0, geom.getMesh());
    }

    public boolean applyCoords(Geometry geom, int offset, Mesh outMesh) {
        Mesh inMesh = geom.getMesh();
        geom.computeWorldMatrix();
        VertexBuffer inBuf = inMesh.getBuffer(VertexBuffer.Type.TexCoord);
        VertexBuffer outBuf = outMesh.getBuffer(VertexBuffer.Type.TexCoord);
        if (inBuf == null || outBuf == null) {
            throw new IllegalStateException("Geometry mesh has no texture coordinate buffer.");
        }
        Texture tex = TextureAtlas.getMaterialTexture(geom, "DiffuseMap");
        if (tex == null) {
            tex = TextureAtlas.getMaterialTexture(geom, "ColorMap");
        }
        if (tex != null) {
            TextureAtlasTile tile = this.getAtlasTile(tex);
            if (tile != null) {
                FloatBuffer inPos = (FloatBuffer)inBuf.getData();
                FloatBuffer outPos = (FloatBuffer)outBuf.getData();
                tile.transformTextureCoords(inPos, offset, outPos);
                return true;
            }
            return false;
        }
        throw new IllegalStateException("Geometry has no proper texture.");
    }

    public static TextureAtlas createAtlas(Spatial root, int atlasSize) {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        GeometryBatchFactory.gatherGeoms(root, geometries);
        TextureAtlas atlas = new TextureAtlas(atlasSize, atlasSize);
        for (Geometry geometry : geometries) {
            if (atlas.addGeometry(geometry)) continue;
            logger.log(Level.WARNING, "Texture atlas size too small, cannot add all textures");
            return null;
        }
        return atlas;
    }

    public static Geometry makeAtlasBatch(Spatial spat, AssetManager mgr, int atlasSize) {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        GeometryBatchFactory.gatherGeoms(spat, geometries);
        TextureAtlas atlas = TextureAtlas.createAtlas(spat, atlasSize);
        if (atlas == null) {
            return null;
        }
        Geometry geom = new Geometry();
        Mesh mesh = new Mesh();
        GeometryBatchFactory.mergeGeometries(geometries, mesh);
        TextureAtlas.applyAtlasCoords(geometries, mesh, atlas);
        mesh.updateCounts();
        mesh.updateBound();
        geom.setMesh(mesh);
        Material mat = new Material(mgr, "Common/MatDefs/Light/Lighting.j3md");
        mat.getAdditionalRenderState().setAlphaTest(true);
        Texture diffuseMap = atlas.getAtlasTexture("DiffuseMap");
        Texture normalMap = atlas.getAtlasTexture("NormalMap");
        Texture specularMap = atlas.getAtlasTexture("SpecularMap");
        if (diffuseMap != null) {
            mat.setTexture("DiffuseMap", diffuseMap);
        }
        if (normalMap != null) {
            mat.setTexture("NormalMap", normalMap);
        }
        if (specularMap != null) {
            mat.setTexture("SpecularMap", specularMap);
        }
        mat.setFloat("Shininess", 16.0f);
        geom.setMaterial(mat);
        return geom;
    }

    private static void applyAtlasCoords(List<Geometry> geometries, Mesh outMesh, TextureAtlas atlas) {
        int globalVertIndex = 0;
        for (Geometry geom : geometries) {
            Mesh inMesh = geom.getMesh();
            geom.computeWorldMatrix();
            int geomVertCount = inMesh.getVertexCount();
            VertexBuffer inBuf = inMesh.getBuffer(VertexBuffer.Type.TexCoord);
            VertexBuffer outBuf = outMesh.getBuffer(VertexBuffer.Type.TexCoord);
            if (inBuf == null || outBuf == null) continue;
            atlas.applyCoords(geom, globalVertIndex, outMesh);
            globalVertIndex += geomVertCount;
        }
    }

    private static Texture getMaterialTexture(Geometry geometry, String mapName) {
        Material mat = geometry.getMaterial();
        if (mat == null || mat.getParam(mapName) == null || !(mat.getParam(mapName) instanceof MatParamTexture)) {
            return null;
        }
        MatParamTexture param = (MatParamTexture)mat.getParam(mapName);
        Texture texture = param.getTextureValue();
        if (texture == null) {
            return null;
        }
        return texture;
    }

    public class TextureAtlasTile {
        private int x;
        private int y;
        private int width;
        private int height;

        public TextureAtlasTile(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public Vector2f getLocation(Vector2f previousLocation) {
            float x = (float)this.getX() / (float)TextureAtlas.this.atlasWidth;
            float y = (float)this.getY() / (float)TextureAtlas.this.atlasHeight;
            float w = (float)this.getWidth() / (float)TextureAtlas.this.atlasWidth;
            float h = (float)this.getHeight() / (float)TextureAtlas.this.atlasHeight;
            Vector2f location = new Vector2f(x, y);
            float prevX = previousLocation.x;
            float prevY = previousLocation.y;
            location.addLocal(prevX * w, prevY * h);
            return location;
        }

        public void transformTextureCoords(FloatBuffer inBuf, int offset, FloatBuffer outBuf) {
            Vector2f tex = new Vector2f();
            offset *= 2;
            for (int i = 0; i < inBuf.capacity() / 2; ++i) {
                tex.x = inBuf.get(i * 2 + 0);
                tex.y = inBuf.get(i * 2 + 1);
                Vector2f location = this.getLocation(tex);
                outBuf.put(offset + i * 2 + 0, location.x);
                outBuf.put(offset + i * 2 + 1, location.y);
            }
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    private class Node {
        public TextureAtlasTile location;
        public Node[] child;
        public boolean occupied;

        public Node(int x, int y, int width, int height) {
            this.location = new TextureAtlasTile(x, y, width, height);
            this.child = new Node[2];
            this.child[0] = null;
            this.child[1] = null;
            this.occupied = false;
        }

        public boolean isLeaf() {
            return this.child[0] == null && this.child[1] == null;
        }

        public Node insert(Image image) {
            int dh;
            if (!this.isLeaf()) {
                Node newNode = this.child[0].insert(image);
                if (newNode != null) {
                    return newNode;
                }
                return this.child[1].insert(image);
            }
            if (this.occupied) {
                return null;
            }
            if (image.getWidth() > this.location.getWidth() || image.getHeight() > this.location.getHeight()) {
                return null;
            }
            if (image.getWidth() == this.location.getWidth() && image.getHeight() == this.location.getHeight()) {
                this.occupied = true;
                return this;
            }
            int dw = this.location.getWidth() - image.getWidth();
            if (dw > (dh = this.location.getHeight() - image.getHeight())) {
                this.child[0] = new Node(this.location.getX(), this.location.getY(), image.getWidth(), this.location.getHeight());
                this.child[1] = new Node(this.location.getX() + image.getWidth(), this.location.getY(), this.location.getWidth() - image.getWidth(), this.location.getHeight());
            } else {
                this.child[0] = new Node(this.location.getX(), this.location.getY(), this.location.getWidth(), image.getHeight());
                this.child[1] = new Node(this.location.getX(), this.location.getY() + image.getHeight(), this.location.getWidth(), this.location.getHeight() - image.getHeight());
            }
            return this.child[0].insert(image);
        }
    }
}

