/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.error.Error;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class ExpressionTable
extends Expression {
    boolean isTable;
    boolean ordinality = false;

    ExpressionTable(Expression[] expressionArray, SubQuery subQuery, boolean bl) {
        super(30);
        this.nodes = expressionArray;
        this.subQuery = subQuery;
        this.ordinality = bl;
    }

    @Override
    public String getSQL() {
        if (this.isTable) {
            return "TABLE";
        }
        return "UNNEST";
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        if (this.isTable) {
            stringBuffer.append("TABLE").append(' ');
        } else {
            stringBuffer.append("UNNEST").append(' ');
        }
        stringBuffer.append(this.nodes[0].describe(session, n));
        return stringBuffer.toString();
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            this.nodes[n].resolveTypes(session, this);
        }
        if (this.nodes.length == 1 && this.nodes[0].dataType.isRowType()) {
            if (this.ordinality) {
                throw Error.error(5581, "ORDINALITY");
            }
            this.nodeDataTypes = ((RowType)this.nodes[0].dataType).getTypesArray();
            this.subQuery.prepareTable(session);
            this.subQuery.getTable().columnList = ((FunctionSQLInvoked)this.nodes[0]).routine.getTable().columnList;
            this.isTable = true;
            return;
        }
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n].dataType.isArrayType()) continue;
            throw Error.error(5563, "UNNEST");
        }
        n = this.ordinality ? this.nodes.length + 1 : this.nodes.length;
        this.nodeDataTypes = new Type[n];
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodeDataTypes[i] = this.nodes[i].dataType.collectionBaseType();
        }
        if (this.ordinality) {
            this.nodeDataTypes[this.nodes.length] = Type.SQL_INTEGER;
        }
        this.subQuery.prepareTable(session);
    }

    @Override
    public Result getResult(Session session) {
        switch (this.opType) {
            case 30: {
                RowSetNavigatorData rowSetNavigatorData = this.subQuery.getNavigator(session);
                Result result = Result.newResult(rowSetNavigatorData);
                result.metaData = this.subQuery.queryExpression.getMetaData();
                return result;
            }
        }
        throw Error.runtimeError(201, "ExpressionTable");
    }

    @Override
    public Object[] getRowValue(Session session) {
        switch (this.opType) {
            case 30: {
                return this.subQuery.queryExpression.getValues(session);
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    @Override
    Object getValue(Session session, Type type) {
        switch (this.opType) {
            case 30: {
                this.materialise(session);
                Object[] objectArray = this.subQuery.getValues(session);
                if (objectArray.length == 1) {
                    return objectArray[0];
                }
                return objectArray;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    @Override
    public Object getValue(Session session) {
        return this.valueData;
    }

    @Override
    void insertValuesIntoSubqueryTable(Session session, PersistentStore persistentStore) {
        if (this.isTable) {
            this.insertTableValues(session, persistentStore);
        } else {
            this.insertArrayValues(session, persistentStore);
        }
    }

    private void insertTableValues(Session session, PersistentStore persistentStore) {
        Result result = this.nodes[0].getResult(session);
        RowSetNavigator rowSetNavigator = result.navigator;
        int n = rowSetNavigator.getSize();
        while (rowSetNavigator.hasNext()) {
            Object[] objectArray = rowSetNavigator.getNext();
            Row row = (Row)persistentStore.getNewCachedObject(session, objectArray, false);
            try {
                persistentStore.indexRow(session, row);
            }
            catch (HsqlException hsqlException) {}
        }
    }

    private void insertArrayValues(Session session, PersistentStore persistentStore) {
        int n;
        Object[][] objectArrayArray = new Object[this.nodes.length][];
        for (n = 0; n < objectArrayArray.length; ++n) {
            Object[] objectArray = (Object[])this.nodes[n].getValue(session);
            if (objectArray == null) {
                objectArray = ValuePool.emptyObjectArray;
            }
            objectArrayArray[n] = objectArray;
        }
        n = 0;
        while (true) {
            boolean bl = false;
            Object[] objectArray = new Object[this.nodeDataTypes.length];
            for (int i = 0; i < objectArrayArray.length; ++i) {
                if (n >= objectArrayArray[i].length) continue;
                objectArray[i] = objectArrayArray[i][n];
                bl = true;
            }
            if (!bl) break;
            if (this.ordinality) {
                objectArray[this.nodes.length] = ValuePool.getInt(n + 1);
            }
            Row row = (Row)persistentStore.getNewCachedObject(session, objectArray, false);
            persistentStore.indexRow(session, row);
            ++n;
        }
    }
}

