/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Comparator;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.QueryExpression;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.TableDerived;
import org.hsqldb.TableUtil;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataTable;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;

class SubQuery
implements Comparator {
    int level;
    private boolean isResolved;
    private boolean isCorrelated;
    private boolean isExistsPredicate;
    private boolean isRecursive;
    private boolean uniqueRows;
    private boolean fullOrder;
    QueryExpression queryExpression;
    Database database;
    private TableDerived table;
    View view;
    View parentView;
    String sql;
    Expression dataExpression;
    boolean isDataExpression;
    SubQuery recursiveSubQuery;
    HsqlNameManager.SimpleName[] columnNames;
    int parsePosition;
    public static final SubQuery[] emptySubqueryArray = new SubQuery[0];

    SubQuery(Database database, int n, QueryExpression queryExpression, int n2) {
        this.level = n;
        this.queryExpression = queryExpression;
        this.database = database;
        switch (n2) {
            case 55: {
                this.isExistsPredicate = true;
                break;
            }
            case 54: {
                this.uniqueRows = true;
                if (queryExpression == null) break;
                queryExpression.setFullOrder();
                break;
            }
            case 57: {
                this.fullOrder = true;
                if (queryExpression == null) break;
                queryExpression.setFullOrder();
            }
        }
    }

    SubQuery(Database database, int n, QueryExpression queryExpression, SubQuery subQuery) {
        this.level = n;
        this.queryExpression = queryExpression;
        this.database = database;
        this.isRecursive = true;
        this.recursiveSubQuery = subQuery;
    }

    SubQuery(Database database, int n, Expression expression, int n2) {
        this.level = n;
        this.database = database;
        this.dataExpression = expression;
        expression.subQuery = this;
        this.isDataExpression = true;
        switch (n2) {
            case 54: {
                this.uniqueRows = true;
            }
        }
    }

    SubQuery(Database database, int n, QueryExpression queryExpression, View view) {
        this.level = n;
        this.queryExpression = queryExpression;
        this.database = database;
        this.view = view;
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    public boolean isCorrelated() {
        return this.isCorrelated;
    }

    public void setCorrelated() {
        this.isCorrelated = true;
    }

    public void setUniqueRows() {
        this.uniqueRows = true;
    }

    public TableDerived getTable() {
        return this.table;
    }

    public void createTable() {
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.getSubqueryTableName();
        this.table = new TableDerived(this.database, hsqlName, 2, this.queryExpression, this);
    }

    public void prepareTable(Session session, HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName[] hsqlNameArray) {
        if (this.isResolved) {
            return;
        }
        if (this.table == null) {
            this.table = new TableDerived(this.database, hsqlName, 2, this.queryExpression, this);
        }
        this.table.columnCount = this.queryExpression.getColumnCount();
        this.table.columnList = this.queryExpression.getColumns();
        if (hsqlNameArray != null) {
            if (hsqlNameArray.length != this.table.columnList.size()) {
                throw Error.error(5593);
            }
            for (int i = 0; i < this.table.columnCount; ++i) {
                this.table.columnList.setKey(i, hsqlNameArray[i].name);
                ColumnSchema columnSchema = (ColumnSchema)this.table.columnList.get(i);
                columnSchema.getName().rename(hsqlNameArray[i]);
            }
        }
        TableUtil.setTableIndexesForSubquery(this.table, this.uniqueRows || this.fullOrder, this.uniqueRows);
        this.isResolved = true;
    }

    public void prepareTable(Session session) {
        if (this.isResolved) {
            return;
        }
        if (this.view == null) {
            if (this.table == null) {
                HsqlNameManager.HsqlName hsqlName = this.database.nameManager.getSubqueryTableName();
                this.table = new TableDerived(this.database, hsqlName, 2, this.queryExpression, this);
            }
            if (this.isDataExpression) {
                TableUtil.addAutoColumns(this.table, this.dataExpression.nodeDataTypes);
                TableUtil.setTableIndexesForSubquery(this.table, this.uniqueRows || this.fullOrder, this.uniqueRows);
            } else {
                this.table.columnList = this.queryExpression.getColumns();
                this.table.columnCount = this.queryExpression.getColumnCount();
                TableUtil.setTableIndexesForSubquery(this.table, this.uniqueRows || this.fullOrder, this.uniqueRows);
            }
        } else {
            this.table = new TableDerived(this.database, this.view.getName(), 8, this.queryExpression, this);
            this.table.columnList = this.view.columnList;
            this.table.columnCount = this.table.columnList.size();
            this.table.createPrimaryKey();
        }
        this.isResolved = true;
    }

    public void setColumnNames(HsqlNameManager.SimpleName[] simpleNameArray) {
        this.columnNames = simpleNameArray;
    }

    public HsqlNameManager.SimpleName[] getColumnNames() {
        return this.columnNames;
    }

    public void materialiseCorrelated(Session session) {
        if (this.isCorrelated) {
            this.materialise(session);
        }
    }

    public void materialise(Session session) {
        if (this.isDataExpression) {
            PersistentStore persistentStore = session.sessionData.getSubqueryRowStore(this.table);
            this.dataExpression.insertValuesIntoSubqueryTable(session, persistentStore);
            return;
        }
        Result result = this.isRecursive ? this.queryExpression.getResultRecursive(session, this.recursiveSubQuery.table) : this.queryExpression.getResult(session, this.isExistsPredicate ? 1 : 0);
        if (this.uniqueRows) {
            RowSetNavigatorData rowSetNavigatorData = (RowSetNavigatorData)result.getNavigator();
            rowSetNavigatorData.removeDuplicates(session);
        }
        PersistentStore persistentStore = session.sessionData.getSubqueryRowStore(this.table);
        this.table.insertResult(session, persistentStore, result);
        result.getNavigator().close();
    }

    public boolean hasUniqueNotNullRows(Session session) {
        RowSetNavigatorDataTable rowSetNavigatorDataTable = new RowSetNavigatorDataTable(session, this.table);
        boolean bl = ((RowSetNavigatorData)rowSetNavigatorDataTable).hasUniqueNotNullRows(session);
        return bl;
    }

    public Object[] getValues(Session session) {
        RowIterator rowIterator = this.table.rowIterator(session);
        if (rowIterator.hasNext()) {
            Row row = rowIterator.getNextRow();
            if (rowIterator.hasNext()) {
                throw Error.error(3201);
            }
            return row.getData();
        }
        return new Object[this.table.getColumnCount()];
    }

    public Object getValue(Session session) {
        Object[] objectArray = this.getValues(session);
        return objectArray[0];
    }

    public RowSetNavigatorData getNavigator(Session session) {
        RowSetNavigatorDataTable rowSetNavigatorDataTable = new RowSetNavigatorDataTable(session, this.table);
        return rowSetNavigatorDataTable;
    }

    public int compare(Object object, Object object2) {
        SubQuery subQuery = (SubQuery)object;
        SubQuery subQuery2 = (SubQuery)object2;
        if (subQuery.parentView == null && subQuery2.parentView == null) {
            return subQuery2.level - subQuery.level;
        }
        if (subQuery.parentView != null && subQuery2.parentView != null) {
            int n;
            int n2 = this.database.schemaManager.getTableIndex(subQuery.parentView);
            int n3 = this.database.schemaManager.getTableIndex(subQuery2.parentView);
            if (n2 == -1) {
                n2 = this.database.schemaManager.getTables(subQuery.parentView.getSchemaName().name).size();
            }
            if (n3 == -1) {
                n3 = this.database.schemaManager.getTables(subQuery2.parentView.getSchemaName().name).size();
            }
            return (n = n2 - n3) == 0 ? subQuery2.level - subQuery.level : n;
        }
        return subQuery.parentView == null ? 1 : -1;
    }
}

